/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.actions.ChangeCellEditorFileEncodingAction;
import com.intellij.database.run.actions.LoadFileAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridTextCellEditorBase;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.util.EventObject;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultBlobEditorFactory
implements GridCellEditorFactory {
    DefaultBlobEditorFactory() {
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(1);
        }
        if (column == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(2);
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column));
        switch (ExtractorsUtil.guessJdbcType(c)) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, @Nullable Object object, EventObject initiator) {
        if (grid == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(3);
        }
        if (row == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(4);
        }
        if (column == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(5);
        }
        BlobTextCellEditor blobTextCellEditor = new BlobTextCellEditor(grid, column, object, initiator);
        if (blobTextCellEditor == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(6);
        }
        return blobTextCellEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBlobEditorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBlobEditorFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BlobTextCellEditor
    extends GridTextCellEditorBase
    implements LoadFileAction.LoadFileActionHandler {
        public BlobTextCellEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> column, @Nullable Object value, EventObject initiator) {
            if (grid == null) {
                BlobTextCellEditor.$$$reportNull$$$0(0);
            }
            if (column == null) {
                BlobTextCellEditor.$$$reportNull$$$0(1);
            }
            super(grid, column, value, initiator);
        }

        @Override
        @Nullable
        protected String getInitialText() {
            return this.myValue instanceof ObjectFormatter.TextInfo ? null : super.getInitialText();
        }

        @Override
        @Nullable
        protected byte[] getInitialBytes() {
            return this.myValue instanceof ObjectFormatter.TextInfo ? ((ObjectFormatter.TextInfo)this.myValue).bytes : null;
        }

        @Override
        @Nullable
        public Object getValue() {
            if (!this.isValueEditable()) {
                return this.myValue;
            }
            FileDocumentManager documentManager = FileDocumentManager.getInstance();
            Document document = this.myTextField.getDocument();
            documentManager.saveDocumentAsIs(document);
            VirtualFile file = documentManager.getFile(document);
            byte[] bytes = null;
            try {
                bytes = file != null ? file.contentsToByteArray() : null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bytes == null ? null : new ObjectFormatter.TextInfo(document.getText(), bytes);
        }

        @Override
        protected boolean isValueEditable() {
            return this.myValue == null || this.myValue instanceof ObjectFormatter.TextInfo;
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (LoadFileAction.LOAD_FILE_ACTION_HANDLER_KEY.is(dataId)) {
                return this;
            }
            if (ChangeCellEditorFileEncodingAction.ENCODING_CHANGE_SUPPORTED_KEY.is(dataId) && this.isValueEditable()) {
                return Boolean.TRUE;
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return this.getVirtualFile();
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                return new VirtualFile[]{this.getVirtualFile()};
            }
            return null;
        }

        @Override
        public void fileChosen(@NotNull VirtualFile file) {
            if (file == null) {
                BlobTextCellEditor.$$$reportNull$$$0(2);
            }
            this.myValue = DbImplUtil.blobFromFile(file);
            this.myGrid.stopEditing();
        }

        private VirtualFile getVirtualFile() {
            return FileDocumentManager.getInstance().getFile(this.myTextField.getDocument());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBlobEditorFactory$BlobTextCellEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileChosen";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

