/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.GridSearchSession;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.EditorHeaderToggleAction;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.editorHeaderActions.ToggleWholeWordsOnlyAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridSearchSession
implements GridSearchSession<DataConsumer.Row, DataConsumer.Column>,
DataProvider,
SearchReplaceComponent.Listener,
FindModel.FindModelObserver {
    private static final String FILTERING_ENABLED_PROPERTY = "grid.search.filter.rows";
    private final Project myProject;
    private final DataGrid myGrid;
    private final FindModel myFindModel;
    private final SearchReplaceComponent mySearchComponent;
    private final Component myPreviousTopComponent;
    private final EventDispatcher<GridSearchSession.Listener> myDispatcher;
    private boolean myFilteringEnabled;

    public DataGridSearchSession(@Nullable Project project, @NotNull DataGrid grid) {
        if (grid == null) {
            DataGridSearchSession.$$$reportNull$$$0(0);
        }
        this.myDispatcher = EventDispatcher.create(GridSearchSession.Listener.class);
        this.myProject = project;
        this.myGrid = grid;
        this.mySearchComponent = this.createSearchComponent();
        this.myPreviousTopComponent = grid.getTopComponent();
        this.myFindModel = this.createFindModel();
        this.myFilteringEnabled = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(FILTERING_ENABLED_PROPERTY);
        this.myGrid.setTopComponent((Component)this.mySearchComponent);
        this.myGrid.searchSessionStarted(this);
        UIUtil.putClientProperty((JComponent)this.mySearchComponent, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)new Iterable<Component>(){

            @Override
            @NotNull
            public Iterator<Component> iterator() {
                Component component = DataGridSearchSession.this.myPreviousTopComponent;
                if (component != null && component.getParent() == null) {
                    Iterator<Component> iterator = Collections.singleton(component).iterator();
                    if (iterator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return iterator;
                }
                Iterator iterator = ContainerUtil.emptyIterator();
                if (iterator == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/DataGridSearchSession$1", "iterator"));
            }
        });
    }

    @NotNull
    private FindModel createFindModel() {
        FindModel findModel = new FindModel();
        findModel.copyFrom(FindManager.getInstance((Project)this.myProject).getFindInFileModel());
        findModel.addObserver((FindModel.FindModelObserver)this);
        FindModel findModel2 = findModel;
        if (findModel2 == null) {
            DataGridSearchSession.$$$reportNull$$$0(1);
        }
        return findModel2;
    }

    @NotNull
    private SearchReplaceComponent createSearchComponent() {
        SearchReplaceComponent searchReplaceComponent = SearchReplaceComponent.buildFor((Project)this.myProject, (JComponent)this.myGrid.getComponent()).addPrimarySearchActions(new AnAction[]{new PrevOccurrenceAction(), new NextOccurrenceAction()}).addExtraSearchActions(new AnAction[]{new ToggleMatchCase(), new ToggleRegex(), new ToggleWholeWordsOnlyAction(), new ToggleFilteringAction(), new StatusTextAction()}).withCloseAction(this::close).withDataProvider((DataProvider)this).build();
        searchReplaceComponent.addListener((SearchReplaceComponent.Listener)this);
        SearchReplaceComponent searchReplaceComponent2 = searchReplaceComponent;
        if (searchReplaceComponent2 == null) {
            DataGridSearchSession.$$$reportNull$$$0(2);
        }
        return searchReplaceComponent2;
    }

    @NotNull
    public SearchReplaceComponent getComponent() {
        SearchReplaceComponent searchReplaceComponent = this.mySearchComponent;
        if (searchReplaceComponent == null) {
            DataGridSearchSession.$$$reportNull$$$0(3);
        }
        return searchReplaceComponent;
    }

    @Override
    public boolean isMatchedCell(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (rowIdx == null) {
            DataGridSearchSession.$$$reportNull$$$0(4);
        }
        if (columnIdx == null) {
            DataGridSearchSession.$$$reportNull$$$0(5);
        }
        return FindManager.getInstance((Project)this.myProject).findString((CharSequence)this.getText(rowIdx, columnIdx), 0, this.myFindModel).isStringFound();
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.myFilteringEnabled && this.isFilteringAvailable();
    }

    @Override
    public void addListener(@NotNull GridSearchSession.Listener listener, @NotNull Disposable parent) {
        if (listener == null) {
            DataGridSearchSession.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            DataGridSearchSession.$$$reportNull$$$0(7);
        }
        this.myDispatcher.addListener((EventListener)listener, parent);
    }

    public void searchFieldDocumentChanged() {
        String textToFind = this.mySearchComponent.getSearchTextComponent().getText();
        this.myFindModel.setStringToFind(textToFind);
        this.myFindModel.setMultiline(textToFind.contains("\n"));
        this.fireSessionUpdated();
    }

    public void replaceFieldDocumentChanged() {
    }

    public void multilineStateChanged() {
        this.myFindModel.setMultiline(this.mySearchComponent.isMultiline());
    }

    @NotNull
    public FindModel getFindModel() {
        FindModel findModel = this.myFindModel;
        if (findModel == null) {
            DataGridSearchSession.$$$reportNull$$$0(8);
        }
        return findModel;
    }

    public boolean hasMatches() {
        return this.findOccurrence(true, true) != null;
    }

    public void searchForward() {
        this.selectOccurrence(false, true);
    }

    public void searchBackward() {
        this.selectOccurrence(false, false);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (SearchSession.KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    public void findModelChanged(FindModel findModel) {
        String stringToFind = this.myFindModel.getStringToFind();
        boolean incorrectRegex = this.myFindModel.isRegularExpressions() && this.myFindModel.compileRegExp() == null;
        boolean hasMatches = this.hasMatches();
        if (incorrectRegex || StringUtil.isNotEmpty((String)stringToFind) && !hasMatches) {
            this.mySearchComponent.setNotFoundBackground();
        } else {
            this.mySearchComponent.setRegularBackground();
        }
        this.mySearchComponent.setStatusText(incorrectRegex ? "Incorrect regular expression" : "");
        this.mySearchComponent.update(stringToFind, "", false, this.myFindModel.isMultiline());
        if (hasMatches) {
            this.selectOccurrence(true, true);
        }
        FindUtil.updateFindInFileModel((Project)this.myProject, (FindModel)this.myFindModel, (boolean)false);
        this.fireSessionUpdated();
    }

    public void close() {
        this.myGrid.setTopComponent(this.myPreviousTopComponent);
        this.myGrid.searchSessionStopped(this);
    }

    private void fireSessionUpdated() {
        ((GridSearchSession.Listener)this.myDispatcher.getMulticaster()).searchSessionUpdated();
    }

    private boolean isFilteringAvailable() {
        return !this.myGrid.isTransposed();
    }

    private void selectOccurrence(boolean selectCurrent, boolean next) {
        Pair.NonNull<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>> cell = this.findOccurrence(selectCurrent, next);
        if (cell != null) {
            SelectionModel selectionModel = this.myGrid.getSelectionModel();
            selectionModel.setRowSelection((ModelIndex)cell.first);
            selectionModel.setColumnSelection((ModelIndex)cell.second);
        }
    }

    @Nullable
    private Pair.NonNull<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>> findOccurrence(boolean includeStart, boolean forward) {
        List rows = this.myGrid.getVisibleRows().asList();
        List columns2 = this.myGrid.getVisibleColumns().asList();
        if (rows.isEmpty() || columns2.isEmpty()) {
            return null;
        }
        ModelIndex startRow = this.myGrid.getSelectionModel().getSelectedRow();
        ModelIndex startColumn = this.myGrid.getSelectionModel().getSelectedColumn();
        int startRowIdx = rows.indexOf(startRow);
        int startColumnIdx = columns2.indexOf(startColumn);
        if (startRowIdx == -1 || startColumnIdx == -1) {
            startRowIdx = 0;
            startColumnIdx = 0;
        }
        GridIt it = new GridIt(startRowIdx, startColumnIdx, rows.size(), columns2.size(), forward, includeStart);
        while (it.hasNext()) {
            ModelIndex column;
            ModelIndex row = (ModelIndex)rows.get(it.row());
            if (this.isMatchedCell(row, column = (ModelIndex)columns2.get(it.column()))) {
                return new Pair.NonNull((Object)row, (Object)column);
            }
            it.advance();
        }
        return null;
    }

    @NotNull
    private String getText(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (rowIdx == null) {
            DataGridSearchSession.$$$reportNull$$$0(9);
        }
        if (columnIdx == null) {
            DataGridSearchSession.$$$reportNull$$$0(10);
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> model = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        DataConsumer.Row row = (DataConsumer.Row)ObjectUtils.assertNotNull((Object)model.getRow(rowIdx));
        DataConsumer.Column column = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)model.getColumn(columnIdx));
        String string = this.getText(row, column);
        if (string == null) {
            DataGridSearchSession.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private String getText(DataConsumer.Row row, DataConsumer.Column column) {
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(this.myGrid);
        String string = this.myGrid.getObjectFormatter().getPlainValue(column, row, (DatabaseDialect)dialect);
        if (string == null) {
            DataGridSearchSession.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/DataGridSearchSession";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/DataGridSearchSession";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFindModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindModel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMatchedCell";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GridIt {
        private final ModuloIt myRowIt;
        private final ModuloIt myColumnIt;
        private final boolean myForward;

        GridIt(int startRow, int startColumn, int rowCount, int columnCount, boolean forward, boolean includeStart) {
            this.myRowIt = new ModuloIt(startRow, rowCount);
            this.myColumnIt = new ModuloIt(startColumn, columnCount);
            this.myForward = forward;
            if (!includeStart) {
                this.advance();
            }
        }

        boolean hasNext() {
            this.advance();
            boolean result2 = !this.myRowIt.atTheStart() || !this.myColumnIt.atTheStart();
            this.advance(!this.myForward);
            return result2;
        }

        void advance() {
            this.advance(this.myForward);
        }

        void advance(boolean forward) {
            if (this.myColumnIt.atTheEnd(forward)) {
                this.myRowIt.advance(forward);
                this.myColumnIt.advance(forward);
                return;
            }
            this.myColumnIt.advance(forward);
        }

        int row() {
            return this.myRowIt.value();
        }

        int column() {
            return this.myColumnIt.value();
        }

        private static class ModuloIt {
            private final int myMax;
            private final int myStart;
            private int myCurrent;

            ModuloIt(int start, int max) {
                this.myCurrent = start;
                this.myStart = start;
                this.myMax = max;
            }

            int value() {
                return this.myCurrent;
            }

            void advance(boolean forward) {
                this.myCurrent = this.nextValue(forward);
            }

            boolean atTheEnd(boolean forward) {
                return forward ? this.myCurrent == this.myMax - 1 : this.myCurrent == 0;
            }

            boolean atTheStart() {
                return this.myCurrent == this.myStart;
            }

            int nextValue(boolean forward) {
                int delta = forward ? 1 : -1;
                int byModulo = (this.myCurrent + delta) % this.myMax;
                return byModulo < 0 ? byModulo + this.myMax : byModulo;
            }
        }
    }

    private class ToggleFilteringAction
    extends EditorHeaderToggleAction {
        protected ToggleFilteringAction() {
            super("&Filter rows");
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(DataGridSearchSession.this.isFilteringAvailable());
        }

        protected boolean isSelected(@NotNull SearchSession session) {
            if (session == null) {
                ToggleFilteringAction.$$$reportNull$$$0(0);
            }
            return DataGridSearchSession.this.myFilteringEnabled && DataGridSearchSession.this.isFilteringAvailable();
        }

        protected void setSelected(@NotNull SearchSession session, boolean selected) {
            if (session == null) {
                ToggleFilteringAction.$$$reportNull$$$0(1);
            }
            boolean wasEnabled = DataGridSearchSession.this.myFilteringEnabled;
            DataGridSearchSession.this.myFilteringEnabled = selected;
            if (wasEnabled != selected) {
                DataGridSearchSession.this.fireSessionUpdated();
            }
            PropertiesComponent.getInstance((Project)DataGridSearchSession.this.myProject).setValue(DataGridSearchSession.FILTERING_ENABLED_PROPERTY, DataGridSearchSession.this.myFilteringEnabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "session";
            objectArray2[1] = "com/intellij/database/run/ui/grid/DataGridSearchSession$ToggleFilteringAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

