/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadFileAction
extends AnAction
implements DumbAware {
    public static final DataKey<LoadFileActionHandler> LOAD_FILE_ACTION_HANDLER_KEY = DataKey.create((String)"LoadFileActionHandler");

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(LoadFileAction.getActionHandler(e.getDataContext()) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext context = e.getDataContext();
        DataGrid grid = DataGridUtil.getDataGrid(context);
        LoadFileActionHandler handler = LoadFileAction.getActionHandler(context);
        if (grid == null || handler == null) {
            return;
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, true, false, false);
        descriptor.setTitle("Choose File to Upload");
        descriptor.setDescription("Chose file to upload to the selected database table row/column.");
        descriptor.setShowFileSystemRoots(true);
        Project project = e.getProject();
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project, (Component)grid.getComponent());
        VirtualFile chosenFile = (VirtualFile)ArrayUtil.getFirstElement((Object[])chooser.choose(project, new VirtualFile[0]));
        if (chosenFile != null) {
            handler.fileChosen(chosenFile);
        }
    }

    @Nullable
    private static LoadFileActionHandler getActionHandler(@NotNull DataContext context) {
        DataGrid grid;
        if (context == null) {
            LoadFileAction.$$$reportNull$$$0(0);
        }
        return (grid = DataGridUtil.getDataGrid(context)) != null ? (grid.isEditing() ? (LoadFileActionHandler)LOAD_FILE_ACTION_HANDLER_KEY.getData(context) : LoadFileAction.getViewModeHandler(grid)) : null;
    }

    @Nullable
    private static LoadFileActionHandler getViewModeHandler(final @NotNull DataGrid grid) {
        if (grid == null) {
            LoadFileAction.$$$reportNull$$$0(1);
        }
        SelectionModel selectionModel = grid.getSelectionModel();
        GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
        DataConsumer.Column selectedColumn = (DataConsumer.Column)model.getColumn(selectionModel.getSelectedColumn());
        if (!grid.isEditable() || selectedColumn == null || selectionModel.getSelectedRowCount() != 1 || selectionModel.getSelectedColumnCount() != 1 || DataGridUtil.getDatabaseColumn(grid, selectedColumn) == null || !DbImplUtil.canInsertBlob(selectedColumn) && !DbImplUtil.canInsertClob(selectedColumn)) {
            return null;
        }
        final ModelIndexSet selectedRows = selectionModel.getSelectedRows();
        final ModelIndexSet selectedColumns = selectionModel.getSelectedColumns();
        final boolean fileAsClob = DbImplUtil.canInsertClob(selectedColumn);
        return new LoadFileActionHandler(){

            @Override
            public void fileChosen(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                grid.setCells(selectedRows, selectedColumns, fileAsClob ? DbImplUtil.clobFromFile(file) : DbImplUtil.blobFromFile(file));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/actions/LoadFileAction$1", "fileChosen"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/LoadFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getViewModeHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface LoadFileActionHandler {
        public void fileChosen(@NotNull VirtualFile var1);
    }
}

