/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.diff.TableDiffTool;
import com.intellij.database.editor.CsvTableFileEditor;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.run.ConsoleDataConsumer;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareWithGroup
extends ActionGroup
implements DumbAware {
    private static final AnAction[] EMPTY_ARRAY = new AnAction[]{new AnAction("Nothing to compare with"){
        {
            this.getTemplatePresentation().setEnabled(false);
        }

        public void actionPerformed(AnActionEvent e) {
        }
    }};

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (EMPTY_ARRAY == null) {
                CompareWithGroup.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }
        Pair<String, GridDataHookUpManager.HookUpHandle> current = CompareWithGroup.getCurrentHookUp(e.getDataContext());
        if (current == null) {
            if (EMPTY_ARRAY == null) {
                CompareWithGroup.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        CompareWithGroup.appendConsoles(result2, e.getDataContext(), (String)current.getFirst(), (GridDataHookUpManager.HookUpHandle)current.getSecond());
        CompareWithGroup.appendEditors(result2, e.getDataContext(), (String)current.getFirst(), (GridDataHookUpManager.HookUpHandle)current.getSecond());
        AnAction[] anActionArray = result2.isEmpty() ? EMPTY_ARRAY : result2.toArray(new AnAction[result2.size()]);
        if (anActionArray == null) {
            CompareWithGroup.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    private static void appendConsoles(@NotNull List<AnAction> result2, @NotNull DataContext ctx, @NotNull String curName, @NotNull GridDataHookUpManager.HookUpHandle curHandle) {
        Project project;
        if (result2 == null) {
            CompareWithGroup.$$$reportNull$$$0(3);
        }
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(4);
        }
        if (curName == null) {
            CompareWithGroup.$$$reportNull$$$0(5);
        }
        if (curHandle == null) {
            CompareWithGroup.$$$reportNull$$$0(6);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(ctx)) == null) {
            return;
        }
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance(project);
        for (JdbcConsole console : JdbcConsole.getActiveConsoles(project)) {
            for (Content content : console.getUi().getContents()) {
                GridDataHookUpManager.HookUpHandle handle;
                DataGrid grid = ConsoleDataConsumer.getDataGrid(content);
                if (grid == null || (handle = hookUpManager.getHandle(grid.getDataHookup())).equals(curHandle)) continue;
                result2.add((AnAction)new MyDiffAction(curName, content.getTabName(), curHandle, handle));
            }
        }
    }

    private static void appendEditors(@NotNull List<AnAction> result2, @NotNull DataContext ctx, @NotNull String curName, @NotNull GridDataHookUpManager.HookUpHandle curHandle) {
        Project project;
        if (result2 == null) {
            CompareWithGroup.$$$reportNull$$$0(7);
        }
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(8);
        }
        if (curName == null) {
            CompareWithGroup.$$$reportNull$$$0(9);
        }
        if (curHandle == null) {
            CompareWithGroup.$$$reportNull$$$0(10);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(ctx)) == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance(project);
        for (FileEditor editor : editorManager.getAllEditors()) {
            GridDataHookUpManager.HookUpHandle handle;
            TableEditorBase tableEditor = (TableEditorBase)((Object)ObjectUtils.tryCast((Object)editor, TableEditorBase.class));
            if (tableEditor == null || (handle = hookUpManager.getHandle(tableEditor.getDataGrid().getDataHookup())).equals(curHandle)) continue;
            result2.add((AnAction)new MyDiffAction(curName, CompareWithGroup.getEditorTitle(tableEditor), curHandle, handle));
        }
    }

    @Nullable
    private static Pair<String, GridDataHookUpManager.HookUpHandle> getCurrentHookUp(@NotNull DataContext ctx) {
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(11);
        }
        return (Pair)ObjectUtils.chooseNotNull(CompareWithGroup.getCurrentConsoleHookUp(ctx), CompareWithGroup.getCurrentEditorHookUp(ctx));
    }

    @Nullable
    private static Pair<String, GridDataHookUpManager.HookUpHandle> getCurrentConsoleHookUp(@NotNull DataContext ctx) {
        DataGrid currentGrid;
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(12);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(ctx);
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext((DataContext)ctx, (boolean)false);
        if (contentManager == null || project == null) {
            return null;
        }
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance(project);
        Content currentContent = contentManager.getSelectedContent();
        DataGrid dataGrid = currentGrid = currentContent != null ? ConsoleDataConsumer.getDataGrid(currentContent) : null;
        if (currentGrid == null) {
            return null;
        }
        return Pair.create((Object)currentContent.getTabName(), (Object)hookUpManager.getHandle(currentGrid.getDataHookup()));
    }

    @Nullable
    private static Pair<String, GridDataHookUpManager.HookUpHandle> getCurrentEditorHookUp(@NotNull DataContext ctx) {
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(13);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(ctx);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(ctx);
        if (project == null || file == null) {
            return null;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance(project);
        TableEditorBase editor = (TableEditorBase)((Object)ObjectUtils.tryCast((Object)editorManager.getSelectedEditor(file), TableEditorBase.class));
        if (editor == null) {
            return null;
        }
        return Pair.create((Object)CompareWithGroup.getEditorTitle(editor), (Object)hookUpManager.getHandle(editor.getDataGrid().getDataHookup()));
    }

    private static String getEditorTitle(@NotNull TableEditorBase editor) {
        if (editor == null) {
            CompareWithGroup.$$$reportNull$$$0(14);
        }
        String name = "";
        if (editor instanceof DatabaseTableFileEditor) {
            name = ((DatabaseTableFileEditor)editor).getFile().getPresentableName();
        } else if (editor instanceof CsvTableFileEditor) {
            name = ((CsvTableFileEditor)editor).getFile().getPresentableName();
        }
        return name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/CompareWithGroup";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curName";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curHandle";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/CompareWithGroup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendConsoles";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendEditors";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentHookUp";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentConsoleHookUp";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentEditorHookUp";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDiffAction
    extends DumbAwareAction {
        private final String myName1;
        private final String myName2;
        GridDataHookUpManager.HookUpHandle myHandle1;
        GridDataHookUpManager.HookUpHandle myHandle2;

        public MyDiffAction(@NotNull String name1, @NotNull String name2, @NotNull GridDataHookUpManager.HookUpHandle handle1, @NotNull GridDataHookUpManager.HookUpHandle handle2) {
            if (name1 == null) {
                MyDiffAction.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                MyDiffAction.$$$reportNull$$$0(1);
            }
            if (handle1 == null) {
                MyDiffAction.$$$reportNull$$$0(2);
            }
            if (handle2 == null) {
                MyDiffAction.$$$reportNull$$$0(3);
            }
            super(name2);
            this.myName1 = name1;
            this.myName2 = name2;
            this.myHandle1 = handle1;
            this.myHandle2 = handle2;
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = e.getProject();
            SimpleDiffRequest dr = new SimpleDiffRequest(this.myName1 + " vs " + this.myName2, (DiffContent)new TableDiffTool.TableDiffContent(this.myHandle1, project), (DiffContent)new TableDiffTool.TableDiffContent(this.myHandle2, project), this.myName1, this.myName2);
            DiffManager.getInstance().showDiff(project, (DiffRequest)dr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name2";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handle1";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handle2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/CompareWithGroup$MyDiffAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

