/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.actions.AddRowAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;

public class CloneRowAction
extends DumbAwareAction
implements GridAction {
    public void update(AnActionEvent e) {
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        boolean available = dataGrid != null && dataGrid.getSelectionModel().getSelectedRowCount() == 1 && AddRowAction.canAddRow(dataGrid) && !dataGrid.isEditing();
        e.getPresentation().setVisible(available);
        e.getPresentation().setEnabled(available);
    }

    public void actionPerformed(AnActionEvent e) {
        ModelIndex<DataConsumer.Row> selectedRow;
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        ModelIndex<DataConsumer.Row> modelIndex = selectedRow = dataGrid != null ? dataGrid.getSelectionModel().getSelectedRow() : null;
        if (selectedRow != null && selectedRow.isValid(dataGrid)) {
            dataGrid.cloneRow(selectedRow);
        }
    }
}

