/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.MeasuringDataAuditor;
import com.intellij.database.util.DbUIUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.lang.ref.WeakReference;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleDataAuditor
extends MeasuringDataAuditor {
    private final AbstractQueryLanguageConsole<?> myConsole;

    public ConsoleDataAuditor(AbstractQueryLanguageConsole<?> console) {
        this.myConsole = console;
        this.myConsole.getMessageBus().addAuditor(this);
    }

    @Override
    public void requestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            ConsoleDataAuditor.$$$reportNull$$$0(0);
        }
        super.requestStarted(context);
        if (!(context.request instanceof DataRequest.TxRequest)) {
            this.myConsole.setCurrentTx(context.txMarker);
        }
        this.myConsole.updateConsoleOnRequestStarted(context);
        if (context.request instanceof ConsoleDataRequest) {
            ((ConsoleDataRequest)context.request).onStarted();
        }
    }

    @Override
    public void requestFinished(@NotNull DataRequest.Context context) {
        if (context == null) {
            ConsoleDataAuditor.$$$reportNull$$$0(1);
        }
        super.requestFinished(context);
        this.myConsole.updateConsoleOnRequestFinished(context);
        if (context.request instanceof ConsoleDataRequest) {
            ((ConsoleDataRequest)context.request).onFinished();
        }
    }

    @Override
    public void txCompleted(@NotNull DataRequest.Context context, boolean commit) {
        if (context == null) {
            ConsoleDataAuditor.$$$reportNull$$$0(2);
        }
        super.txCompleted(context, commit);
        this.myConsole.updateConsoleOnTxCompleted(context, commit);
        this.myConsole.setCurrentTx(DataRequest.START_NEW);
    }

    @Override
    public void print(@NotNull DataRequest.Context context, @Nullable String message) {
        if (context == null) {
            ConsoleDataAuditor.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)message)) {
            return;
        }
        this.myConsole.getHistoryLogger().print(context, message);
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myConsole.getProject());
        if (statusBar != null) {
            statusBar.setInfo(message, this.myConsole.getToolWindowId());
        }
    }

    @Override
    public void warn(@NotNull DataRequest.Context context, @Nullable String message) {
        if (context == null) {
            ConsoleDataAuditor.$$$reportNull$$$0(4);
        }
        this.myConsole.getHistoryLogger().warn(context, message);
    }

    @Override
    public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
        if (context == null) {
            ConsoleDataAuditor.$$$reportNull$$$0(5);
        }
        super.error(context, message, th);
        boolean isWarning = th instanceof JdbcEngine.EngineWarningException;
        String logMessage = isWarning ? ((JdbcEngine.EngineWarningException)th).getLogMessage() : message;
        this.myConsole.getHistoryLogger().error(context, logMessage, isWarning ? null : th);
        if (context.request instanceof ConsoleDataRequest) {
            ConsoleDataRequest request = (ConsoleDataRequest)context.request;
            if (isWarning) {
                request.onWarning(message);
            } else {
                request.onError(message, th);
            }
        }
        this.bringAttentionToOutput(context, true);
    }

    @Override
    protected void bringAttentionToOutput(@NotNull DataRequest.Context context, boolean isError) {
        if (context == null) {
            ConsoleDataAuditor.$$$reportNull$$$0(6);
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            if (context == null) {
                ConsoleDataAuditor.$$$reportNull$$$0(11);
            }
            if (!this.myConsole.isValid()) {
                return;
            }
            ConsoleDataRequest cr = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class);
            boolean wasShowing = this.myConsole.getUi().getComponent().isShowing();
            Consumer runnable = aVoid -> {
                if (!this.myConsole.isValid()) {
                    return;
                }
                Content content = this.myConsole.getOutputContent();
                if (content != null) {
                    boolean focus;
                    this.myConsole.getUi().setBouncing(content, true);
                    boolean bl = focus = !wasShowing || isError && cr == null;
                    if (focus) {
                        this.myConsole.getUi().selectAndFocus(content, false, false);
                        this.myConsole.getHistoryLogger().scrollToEnd();
                    }
                }
            };
            if (!(cr == null || cr.queryIndex != 0 && cr.hasNext)) {
                this.myConsole.showConsole(true, false).done(runnable);
            } else {
                runnable.consume(null);
            }
        });
    }

    @Override
    protected void bringAttentionByNotification(@NotNull DataRequest.Context context) {
        if (context == null) {
            ConsoleDataAuditor.$$$reportNull$$$0(7);
        }
        boolean hasErrors = this.getStat((DataRequest.Context)context).errorCount > 0L;
        NotificationType type = hasErrors ? NotificationType.ERROR : NotificationType.INFORMATION;
        String query = context.getQuery();
        String text2 = (query.isEmpty() ? "Request" : StringUtil.trimMiddle((String)query, (int)60)) + "... <a href=\"\">finished!</a>";
        ConsoleDataAuditor.fireBackToConsoleNotification(this.myConsole, type, text2);
    }

    private static void fireBackToConsoleNotification(@NotNull AbstractQueryLanguageConsole<?> console, @NotNull NotificationType type, @NotNull String text2) {
        if (console == null) {
            ConsoleDataAuditor.$$$reportNull$$$0(8);
        }
        if (type == null) {
            ConsoleDataAuditor.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            ConsoleDataAuditor.$$$reportNull$$$0(10);
        }
        String title = console.getTitle();
        final WeakReference consoleRef = new WeakReference(console);
        DatabaseNotifications.DATABASE_LONG_RUNNING_GROUP.createNotification(title, text2, type, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                AbstractQueryLanguageConsole console;
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((console = (AbstractQueryLanguageConsole)consoleRef.get()) != null) {
                    console.showConsole(true, false);
                } else {
                    notification.expire();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/ConsoleDataAuditor$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(console.getProject());
        SystemNotifications.getInstance().notify("ConsoleDataAuditor", title, text2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ConsoleDataAuditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "requestStarted";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "requestFinished";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "txCompleted";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "print";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "warn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "bringAttentionToOutput";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "bringAttentionByNotification";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "fireBackToConsoleNotification";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$bringAttentionToOutput$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

