/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DbRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        PsiElement psiElement = PsiElementRenameHandler.getElement((DataContext)dataContext);
        return psiElement instanceof DatabaseStructure.DbGroup || psiElement instanceof DbElement && !DbRenameHandler.isVetoedElement((DbElement)psiElement);
    }

    public static boolean isVetoedElement(@NotNull DbElement dbElement) {
        ObjectKind pkind;
        if (dbElement == null) {
            DbRenameHandler.$$$reportNull$$$0(0);
        }
        if (dbElement instanceof DbDataSource) {
            return false;
        }
        if (DataImporter.isBusy(dbElement)) {
            return true;
        }
        if (DbSqlUtil.isSqlElement(dbElement)) {
            return false;
        }
        DbElement parent = dbElement.getParent();
        ObjectKind kind = dbElement.getKind();
        ObjectKind objectKind = pkind = parent == null ? null : parent.getKind();
        if (pkind != ObjectKind.TABLE && (kind == ObjectKind.COLUMN || kind == ObjectKind.INDEX)) {
            return true;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(dbElement);
        if (dbElement instanceof DasNamespace) {
            if (dbElement.getKind() == ObjectKind.SCHEMA && dialect.supportsRenameSchema()) {
                return false;
            }
            return dbElement.getKind() != ObjectKind.DATABASE || !dialect.supportsRenameDatabase();
        }
        DatabaseEditorCapabilities.DbEditorCaps caps = dialect.getSchemaEditor().getDbEditorCaps();
        if (kind == ObjectKind.VIEW) {
            return !dialect.supportsRenameView();
        }
        if (dbElement instanceof DbRoutine) {
            return ((DbRoutine)dbElement).getPackageName() != null || !dialect.supportsRenameRoutine();
        }
        DatabaseEditorCapabilities.ObjectEditorCaps modifyCaps = caps.getModifyCaps(kind);
        return modifyCaps == null || !modifyCaps.getRename().isAvailable();
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        PsiElement element;
        Object delegate;
        if (project == null) {
            DbRenameHandler.$$$reportNull$$$0(1);
        }
        Object object = delegate = (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) instanceof DbElement ? ((DbElement)element).getDelegate() : null;
        if (delegate instanceof DasTable || delegate instanceof DasTableChild || delegate instanceof DasRoutine || delegate instanceof DasNamespace) {
            RefactoringActionHandlerFactory.getInstance().createRenameHandler().invoke(project, new PsiElement[]{element}, dataContext);
        } else if (element instanceof DbDataSource) {
            String initialName = ((DbDataSource)element).getName();
            String newName = Messages.showInputDialog((Project)project, (String)("Rename Data Source '" + initialName + "' to:"), (String)"Rename", (Icon)Messages.getQuestionIcon(), (String)initialName, null);
            if (StringUtil.isNotEmpty((String)newName)) {
                ((DbDataSource)element).setName(newName);
            }
        } else if (element instanceof DatabaseStructure.DbGroup) {
            DatabaseStructure.DbGroup group2 = (DatabaseStructure.DbGroup)element;
            String initialName = group2.getName();
            String newName = Messages.showInputDialog((Project)project, (String)("Rename Group '" + initialName + "' to:"), (String)"Rename", (Icon)Messages.getQuestionIcon(), (String)initialName, null);
            if (StringUtil.isNotEmpty((String)newName)) {
                DatabaseStructure.renameGroup(project, group2, newName);
            }
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            DbRenameHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            DbRenameHandler.$$$reportNull$$$0(3);
        }
        this.invoke(project, null, null, dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/psi/DbRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isVetoedElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DatabaseVetoRenameCondition
    implements Condition<PsiElement> {
        public boolean value(PsiElement element) {
            return element instanceof DbElement && DbRenameHandler.isVetoedElement((DbElement)element);
        }
    }
}

