/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasicDbPsiManager<T extends DatabaseSystem>
extends DbPsiManagerSpi {
    @NotNull
    private final Map<T, DbDataSource> myDataSourcesMap;
    @NotNull
    protected final DbPsiFacade myDbFacade;

    protected BasicDbPsiManager(@NotNull DbPsiFacade dbFacade, @NotNull List<? extends T> sources) {
        if (dbFacade == null) {
            BasicDbPsiManager.$$$reportNull$$$0(0);
        }
        if (sources == null) {
            BasicDbPsiManager.$$$reportNull$$$0(1);
        }
        this.myDbFacade = dbFacade;
        this.myDataSourcesMap = Collections.synchronizedMap(ContainerUtil.newLinkedHashMap());
        if (!sources.isEmpty()) {
            this.resetElementMap(sources);
        }
        Disposer.register((Disposable)this.myDbFacade.getProject(), (Disposable)new Disposable(){

            public void dispose() {
                BasicDbPsiManager.this.detachAll();
            }
        });
    }

    protected void resetElementMap(@NotNull List<? extends T> sources) {
        if (sources == null) {
            BasicDbPsiManager.$$$reportNull$$$0(2);
        }
        HashSet<T> oldSources = new HashSet<T>(this.myDataSourcesMap.keySet());
        HashSet<T> newSources = new HashSet<T>(sources);
        for (DatabaseSystem source : oldSources) {
            if (newSources.contains(source)) continue;
            this.detachDataSource(source);
        }
        for (DatabaseSystem source : newSources) {
            DbDataSource existentWrapper = this.myDataSourcesMap.get(source);
            if (existentWrapper == null) {
                this.attachDataSource(source);
                continue;
            }
            existentWrapper.clearCaches();
        }
    }

    public void attachDataSource(@NotNull T source) {
        if (source == null) {
            BasicDbPsiManager.$$$reportNull$$$0(3);
        }
        DbDataSource wrapper = this.createDataSourceElement(source);
        this.myDataSourcesMap.put(source, wrapper);
        this.dataSourceAttached(source, wrapper);
    }

    public void detachDataSource(@NotNull T source) {
        DbDataSource wrapper;
        if (source == null) {
            BasicDbPsiManager.$$$reportNull$$$0(4);
        }
        if ((wrapper = this.myDataSourcesMap.remove(source)) != null) {
            this.dataSourceDetached(source, wrapper);
        }
    }

    private void detachAll() {
        if (this.myDataSourcesMap.isEmpty()) {
            return;
        }
        ArrayList<T> sources = new ArrayList<T>(this.myDataSourcesMap.keySet());
        for (DatabaseSystem source : sources) {
            this.detachDataSource(source);
        }
    }

    protected void dataSourceAttached(@NotNull T source, @NotNull DbDataSource wrapper) {
        if (source == null) {
            BasicDbPsiManager.$$$reportNull$$$0(5);
        }
        if (wrapper == null) {
            BasicDbPsiManager.$$$reportNull$$$0(6);
        }
    }

    protected void dataSourceDetached(@NotNull T source, @NotNull DbDataSource wrapper) {
        if (source == null) {
            BasicDbPsiManager.$$$reportNull$$$0(7);
        }
        if (wrapper == null) {
            BasicDbPsiManager.$$$reportNull$$$0(8);
        }
    }

    @NotNull
    protected DbDataSource createDataSourceElement(@NotNull T info) {
        if (info == null) {
            BasicDbPsiManager.$$$reportNull$$$0(9);
        }
        DbDataSource dbDataSource = ((DbPsiFacadeImpl)this.myDbFacade).createDataSourceWrapperElement((DatabaseSystem)info, this);
        if (dbDataSource == null) {
            BasicDbPsiManager.$$$reportNull$$$0(10);
        }
        return dbDataSource;
    }

    @Nullable
    public DbDataSource getDataSourceWrapper(@Nullable T dataSource) {
        if (dataSource == null) {
            return null;
        }
        return this.myDataSourcesMap.get(dataSource);
    }

    public List<DbDataSource> getDataSources() {
        return new ArrayList<DbDataSource>(this.myDataSourcesMap.values());
    }

    @Override
    public boolean isDataSourceElementValid(@NotNull DbDataSource element) {
        if (element == null) {
            BasicDbPsiManager.$$$reportNull$$$0(11);
        }
        return this.myDataSourcesMap.containsKey(element.getDelegate());
    }

    public abstract void addDataSource(@NotNull T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbFacade";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/BasicDbPsiManager";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/BasicDbPsiManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetElementMap";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "attachDataSource";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detachDataSource";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dataSourceAttached";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dataSourceDetached";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceElement";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDataSourceElementValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

