/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.ui;

import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanTreeNode;
import com.intellij.icons.AllIcons;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class PlanRenderers {

    public static class ActionRenderer
    implements TreeCellRenderer {
        private final JLabel myLabel = new JLabel();

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            PlanTreeNode node = (PlanTreeNode)ObjectUtils.tryCast((Object)value, PlanTreeNode.class);
            this.myLabel.setForeground(UIUtil.getListForeground((boolean)selected));
            if (node == null) {
                this.myLabel.setIcon(null);
                this.myLabel.setText(null);
            } else {
                if (node.getNode().getType().isKindOf(PlanModel.NodeType.SET_OP)) {
                    this.myLabel.setIcon(AllIcons.Toolbar.Filterdups);
                } else if (node.getNode().getType().isKindOf(PlanModel.NodeType.TEMPORARY)) {
                    this.myLabel.setIcon(DatabaseIcons.Table);
                } else if (node.getNode().getType().isKindOf(PlanModel.NodeType.SUBQUERY)) {
                    this.myLabel.setIcon(((PlanModel.SubQueryNode)node.getNode()).isCorrelated() ? DatabaseIcons.SchemaRefresh : DatabaseIcons.Rollback);
                } else if (node.getNode().getType().isKindOf(PlanModel.NodeType.SELECT)) {
                    this.myLabel.setIcon(DatabaseIcons.SqlSelectStatement);
                } else if (node.getNode().getType().isKindOf(PlanModel.NodeType.STATEMENT)) {
                    this.myLabel.setIcon(DatabaseIcons.SqlDmlStatement);
                } else if (node.getNode().getType().isKindOf(PlanModel.NodeType.INDEX_SCAN)) {
                    this.myLabel.setIcon(DatabaseIcons.GoldKey);
                } else if (node.getNode().getType().isKindOf(PlanModel.NodeType.DATA)) {
                    this.myLabel.setIcon(DatabaseIcons.Table);
                } else if (node.getNode().getType().isKindOf(PlanModel.NodeType.GROUP_BY)) {
                    this.myLabel.setIcon(DatabaseIcons.SqlGroupByType);
                } else {
                    this.myLabel.setIcon(null);
                }
                this.myLabel.setText(node.getNode().getDisplayTitle());
            }
            return this.myLabel;
        }
    }
}

