/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.oracle;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.oracle.OracleExplainPlanComponent;
import com.intellij.database.plan.oracle.OraclePlanModelBuilder;
import com.intellij.database.script.ScriptModel;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleExplainPlanProvider
extends ExplainPlanProvider {
    private static final String PLAN_TABLE_KEY = "PLAN_TABLE_KEY";
    private static final String DEFAULT_PLAN_TABLE = "PLAN_TABLE";

    @Override
    @NotNull
    public String getName() {
        if ("Oracle" == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(0);
        }
        return "Oracle";
    }

    @Override
    @Nullable
    public ConfigurableUi<LocalDataSource> createOptionsComponent() {
        return new OracleExplainPlanComponent();
    }

    @Override
    public boolean isAvailableFor(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(1);
        }
        return DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource).isOracle();
    }

    @Override
    @NotNull
    public <V> ScriptModel<V> adjustModel(@NotNull ScriptModel<V> model) {
        if (model == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(2);
        }
        ScriptModel scriptModel = model.rawTransform(st -> {
            SyntaxTraverser.Api api = st.api;
            return (SyntaxTraverser)st.forceIgnore(v -> {
                if (!(v instanceof SqlParameter)) {
                    return false;
                }
                CharSequence text2 = api.textOf(v);
                return text2.equals("?") || StringUtil.startsWith((CharSequence)text2, (CharSequence)":");
            });
        });
        if (scriptModel == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(3);
        }
        return scriptModel;
    }

    @NotNull
    public static String getExplainPlanTable(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(4);
        }
        String res = dataSource.getExplainPlanConfiguration().getProviderConfig().get(PLAN_TABLE_KEY);
        String string = (String)ObjectUtils.chooseNotNull((Object)res, (Object)DEFAULT_PLAN_TABLE);
        if (string == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void setExplainPlanTable(@NotNull LocalDataSource dataSource, @Nullable String table) {
        if (dataSource == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(6);
        }
        Map<String, String> config = dataSource.getExplainPlanConfiguration().getProviderConfig();
        if (table == null || table.equals(DEFAULT_PLAN_TABLE)) {
            config.remove(PLAN_TABLE_KEY);
        } else {
            config.put(PLAN_TABLE_KEY, table);
        }
    }

    @Override
    @Nullable
    public DataRequest.RawRequest createExplainRequest(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull LocalDataSource dataSource, @NotNull String statement, boolean run) {
        if (owner == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(8);
        }
        if (dataSource == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(9);
        }
        if (statement == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(10);
        }
        return new OraclePlanModelBuilder(owner, consumer, statement, OracleExplainPlanProvider.getExplainPlanTable(dataSource));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/oracle/OracleExplainPlanProvider";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/oracle/OracleExplainPlanProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplainPlanTable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "adjustModel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExplainPlanTable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setExplainPlanTable";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createExplainRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

