/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.PostgresIntrospectionException;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.PositioningFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.StringKt;
import gnu.trove.TLongHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000v\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0002\u001a\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017\u001a \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010 \u001a\u00020\u0017H\u0000\u001a\u001d\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0002\u0010\"\u001a%\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010#\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\u0010$\u001a0\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170\u001e2\b\u0010&\u001a\u0004\u0018\u00010\u00172\u0006\u0010 \u001a\u00020\u00172\u000e\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0(H\u0000\u001a7\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\"\u0010.\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002000/0\u000e\"\n\u0012\u0006\b\u0001\u0012\u0002000/\u00a2\u0006\u0002\u00101\u001a!\u00102\u001a\u00020\u00012\u0012\u00103\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0017\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\u00104\u001a\u0010\u00105\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017H\u0000\u001a\f\u00106\u001a\u00020\u0017*\u00020\u0017H\u0000\u001a\f\u00107\u001a\u00020\u0017*\u00020\u0017H\u0000\u001a\u0014\u00108\u001a\u00020\u0017*\u00020\u00172\u0006\u00109\u001a\u00020\u0006H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"$\u0010\f\u001a\u00020\r*\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u001a\u0010\f\u001a\u00020\r*\u0004\u0018\u00010\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0013\u00a8\u0006:"}, d2={"NO_CHARS", "", "POSITION_OF_OID", "", "POSITION_OF_XMIN", "REL_ANY", "", "REL_TABLE", "REL_VIEW", "goodNameTemplate", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "length", "", "", "", "getLength", "([Ljava/lang/Object;)I", "", "([J)I", "dataTypeOf", "Lcom/intellij/database/model/DataType;", "spec", "", "isNotEmpty", "", "array", "normalizeDefaultExpression", "expression", "parseArrayOfPositions", "", "str", "what", "parseArrayOfStrings", "(Ljava/lang/String;)[Ljava/lang/String;", "delimiter", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "peekColNames", "columnPositions", "columns", "Lcom/intellij/database/model/families/PositioningFamily;", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "removeDroppedChildren", "", "existentIds", "Lgnu/trove/TLongHashSet;", "families", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "(Lgnu/trove/TLongHashSet;[Lcom/intellij/database/model/families/ModIdentifyingFamily;)V", "stringsToChars", "strings", "([Ljava/lang/String;)[C", "unescape", "nameToScript", "normalizeDataTypeSpec", "removeSuffix", "c", "database-introspection"})
public final class PostgresIntrospectorBaseKt {
    private static final short POSITION_OF_XMIN = -3;
    private static final short POSITION_OF_OID = -2;
    private static final char REL_TABLE = 'r';
    private static final char REL_VIEW = 'v';
    public static final char REL_ANY = '\u0000';
    private static final char[] NO_CHARS = new char[0];
    private static final Pattern goodNameTemplate = Pattern.compile("^\\p{IsLowercase}[\\p{IsLowercase}0-9_]*$");

    /*
     * WARNING - void declaration
     */
    public static final void removeDroppedChildren(@NotNull TLongHashSet existentIds, ModIdentifyingFamily<? extends BasicModIdentifiedElement> ... families) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)existentIds, (String)"existentIds");
        Intrinsics.checkParameterIsNotNull(families, (String)"families");
        ArrayList<BasicModIdentifiedElement> objectsToRemove = new ArrayList<BasicModIdentifiedElement>();
        for (n = 0; n < families.length; ++n) {
            ModIdentifyingFamily<? extends BasicModIdentifiedElement> family = families[n];
            for (BasicModIdentifiedElement basicModIdentifiedElement : family) {
                long id = basicModIdentifiedElement.getObjectId();
                if (existentIds.contains(id)) continue;
                objectsToRemove.add(basicModIdentifiedElement);
            }
        }
        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)objectsToRemove)));
        int family = intProgression.getFirst();
        n = intProgression.getLast();
        int n2 = intProgression.getStep();
        int n3 = family;
        int n4 = n;
        if (n2 > 0 ? n3 <= n4 : n3 >= n4) {
            while (true) {
                void i2;
                BasicModElement objectToRemove = (BasicModElement)objectsToRemove.get((int)i2);
                objectToRemove.drop();
                if (i2 == n) break;
                void var3_5 = i2 + n2;
            }
        }
    }

    private static final DataType dataTypeOf(String spec) {
        String string = spec;
        if (string == null || (string = PostgresIntrospectorBaseKt.normalizeDataTypeSpec(string)) == null) {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataType.UNKNOWN");
            return dataType;
        }
        String s = string;
        DataType dataType = DataTypeFactory.of(s);
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(s)");
        return dataType;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final String normalizeDataTypeSpec(@NotNull String $receiver) {
        block27: {
            block26: {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                p1 = StringsKt.indexOf$default((CharSequence)$receiver, (char)'(', (int)0, (boolean)false, (int)6, null);
                v0 = p2 = p1 >= 0 ? StringsKt.lastIndexOf$default((CharSequence)$receiver, (char)')', (int)0, (boolean)false, (int)6, null) : -1;
                if (p1 >= 0) {
                    var4_3 = $receiver;
                    var5_4 = 0;
                    v1 = var4_3.substring(var5_4, p1);
                    v2 = v1;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    v2 = s1 = $receiver;
                }
                if (p1 >= 0) {
                    if (p2 > p1) {
                        var5_5 = $receiver;
                        var6_8 = p1 + 1;
                        v3 = var5_5.substring(var6_8, p2);
                        v4 = v3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    } else {
                        var5_5 = $receiver;
                        var6_8 = p1 + 1;
                        v5 = var5_5.substring(var6_8);
                        v4 = v5;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"(this as java.lang.String).substring(startIndex)");
                    }
                } else {
                    v4 = s2 = null;
                }
                if (p2 > p1) {
                    var6_9 = $receiver;
                    var7_11 = p2 + 1;
                    v6 = var6_9.substring(var7_11);
                    v7 = v6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"(this as java.lang.String).substring(startIndex)");
                } else {
                    v7 = null;
                }
                s3 = v7;
                v8 = var6_10 = s1;
                if (v8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                s1 = StringsKt.trim((CharSequence)v8).toString();
                v9 = s2;
                if (v9 == null) ** GOTO lbl-1000
                v10 = var6_10 = v9;
                if (v10 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                v9 = StringsKt.trim((CharSequence)v10).toString();
                if (v9 != null) {
                    v11 = StringKt.nullize$default((String)v9, (boolean)false, (int)1, null);
                } else lbl-1000:
                // 2 sources

                {
                    v11 = s2 = null;
                }
                if ((v12 = s3) == null) ** GOTO lbl-1000
                v13 = var6_10 = v12;
                if (v13 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                v12 = StringsKt.trim((CharSequence)v13).toString();
                if (v12 != null) {
                    v14 = StringKt.nullize$default((String)v12, (boolean)false, (int)1, null);
                } else lbl-1000:
                // 2 sources

                {
                    v14 = null;
                }
                s3 = v14;
                var6_10 = s1;
                switch (var6_10.hashCode()) {
                    case 1564195625: {
                        if (!var6_10.equals("character")) ** break;
                        break;
                    }
                    case 392943421: {
                        if (!var6_10.equals("timestamp without time zone")) ** break;
                        break block26;
                    }
                    case -510877388: {
                        if (!var6_10.equals("time without time zone")) ** break;
                        break block27;
                    }
                    case -1198484871: {
                        if (!var6_10.equals("character varying")) ** break;
                        s1 = "varchar";
                        ** break;
                    }
                }
                s1 = "char";
                ** break;
            }
            s1 = "timestamp";
            ** break;
        }
        s1 = "time";
lbl82:
        // 9 sources

        if (s2 == null && s3 == null) {
            return s1;
        }
        if (Intrinsics.areEqual((Object)s2, (Object)"1") && (Intrinsics.areEqual((Object)s1, (Object)"char") || Intrinsics.areEqual((Object)s1, (Object)"bit"))) {
            s2 = null;
        }
        if (Intrinsics.areEqual((Object)s3, (Object)"without time zone") && (Intrinsics.areEqual((Object)s1, (Object)"timestamp") || Intrinsics.areEqual((Object)s1, (Object)"time"))) {
            s3 = null;
        }
        b = new StringBuilder($receiver.length());
        b.append(s1);
        if (s2 != null) {
            b.append('(').append(s2).append(')');
        }
        if (s3 != null) {
            b.append(' ').append(s3);
        }
        v15 = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"b.toString()");
        return v15;
    }

    @NotNull
    public static final String normalizeDefaultExpression(@NotNull String expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        return StringsKt.replace$default((String)expression, (String)"::character varying", (String)"", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> peekColNames(@Nullable String columnPositions, @NotNull String what, @NotNull PositioningFamily<? extends BasicTableOrViewColumn> columns2) {
        Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
        Intrinsics.checkParameterIsNotNull(columns2, (String)"columns");
        List<Short> positions = PostgresIntrospectorBaseKt.parseArrayOfPositions(columnPositions, what);
        int n = positions.size();
        ArrayList<String> names = new ArrayList<String>(n);
        int n2 = 0;
        int n3 = n - 1;
        if (n2 <= n3) {
            while (true) {
                void i2;
                short position;
                if ((position = ((Number)positions.get((int)i2)).shortValue()) > 0) {
                    BasicTableOrViewColumn column = columns2.getByNaturalPosition(position);
                    if (column != null) {
                        names.add(column.getName());
                    }
                } else if (position < 0) {
                    switch (position) {
                        case -3: {
                            names.add("xmin");
                            break;
                        }
                        case -2: {
                            names.add("oid");
                        }
                    }
                }
                if (i2 == n3) break;
                ++i2;
            }
        }
        return names;
    }

    @NotNull
    public static final List<Short> parseArrayOfPositions(@Nullable String str, @NotNull String what) {
        Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
        String[] strings = PostgresIntrospectorBaseKt.parseArrayOfStrings(str);
        int n = PostgresIntrospectorBaseKt.getLength(strings);
        if (n == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList positions = new ArrayList(n);
        try {
            for (int j = 0; j < strings.length; ++j) {
                String s = strings[j];
                Collection collection = positions;
                Short s2 = Short.parseShort(s);
                collection.add(s2);
            }
        }
        catch (NumberFormatException nfe) {
            PostgresIntrospectionException postgresIntrospectionException;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Cannot parse %s: '%s'";
            Object[] objectArray = new Object[]{what, str};
            PostgresIntrospectionException postgresIntrospectionException2 = postgresIntrospectionException;
            PostgresIntrospectionException postgresIntrospectionException3 = postgresIntrospectionException;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            postgresIntrospectionException2(string3, nfe);
            throw (Throwable)postgresIntrospectionException3;
        }
        return positions;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final char[] stringsToChars(@Nullable String[] strings) {
        block4: {
            if (strings == null || PostgresIntrospectorBaseKt.getLength(strings) == 0) {
                return PostgresIntrospectorBaseKt.NO_CHARS;
            }
            n = PostgresIntrospectorBaseKt.getLength(strings);
            chars = new char[n];
            var3_3 = 0;
            var4_4 = n - 1;
            if (var3_3 > var4_4) break block4;
            while (true) {
                s = strings[i];
                v0 = chars;
                v1 = i;
                if (s == null) ** GOTO lbl-1000
                var6_6 = s;
                var8_8 = v1;
                var7_7 = v0;
                var9_9 = var6_6.length() > 0;
                v0 = var7_7;
                v1 = var8_8;
                if (var9_9) {
                    v2 = s.charAt(0);
                } else lbl-1000:
                // 2 sources

                {
                    v2 = v0[v1] = '\u0000';
                }
                if (i == var4_4) break;
                ++i;
            }
        }
        return chars;
    }

    @NotNull
    public static final String[] parseArrayOfStrings(@Nullable String str) {
        return PostgresIntrospectorBaseKt.parseArrayOfStrings(str, ",");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final String[] parseArrayOfStrings(@Nullable String str, @NotNull String delimiter) {
        List list;
        String[] stringArray;
        Object thisCollection$iv2;
        block10: {
            block14: {
                ListIterator iterator$iv;
                List list2;
                block15: {
                    void $receiver$iv$iv;
                    List list3;
                    Object iterator$iv2;
                    block9: {
                        block12: {
                            List list4;
                            block13: {
                                block11: {
                                    int len;
                                    Intrinsics.checkParameterIsNotNull((Object)delimiter, (String)"delimiter");
                                    String string = str;
                                    int n = len = string != null ? string.length() : 0;
                                    if (len == 0) {
                                        Intrinsics.checkExpressionValueIsNotNull((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"ArrayUtil.EMPTY_STRING_ARRAY");
                                        return ArrayUtil.EMPTY_STRING_ARRAY;
                                    }
                                    if (len < 2) break block11;
                                    String string2 = str;
                                    if (string2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    if (string2.charAt(0) != '{' || str.charAt(len - 1) != '}') break block11;
                                    String string3 = str;
                                    int n2 = 1;
                                    int n3 = len - 1;
                                    String string4 = string3.substring(n2, n3);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    CharSequence charSequence = string4;
                                    String string5 = delimiter;
                                    string5 = new Regex(string5);
                                    n3 = 0;
                                    list4 = string5.split(charSequence, n3);
                                    if (list4.isEmpty()) break block12;
                                    iterator$iv2 = list4.listIterator(list4.size());
                                    break block13;
                                }
                                String string = str;
                                if (string == null) {
                                    Intrinsics.throwNpe();
                                }
                                CharSequence charSequence = string;
                                thisCollection$iv2 = " ";
                                thisCollection$iv2 = new Regex((String)thisCollection$iv2);
                                int $i$f$toTypedArray = 0;
                                list2 = thisCollection$iv2.split(charSequence, $i$f$toTypedArray);
                                if (list2.isEmpty()) break block14;
                                iterator$iv = list2.listIterator(list2.size());
                                break block15;
                            }
                            while (iterator$iv2.hasPrevious()) {
                                String p1 = (String)iterator$iv2.previous();
                                CharSequence charSequence = p1;
                                if (charSequence.length() == 0) continue;
                                list3 = CollectionsKt.take((Iterable)list4, (int)(iterator$iv2.nextIndex() + 1));
                                break block9;
                            }
                        }
                        list3 = CollectionsKt.emptyList();
                    }
                    Iterable iterable = list3;
                    iterator$iv2 = iterable;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void p1;
                        String $i$f$dropLastWhile = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        String string = PostgresIntrospectorBaseKt.unescape((String)p1);
                        collection.add(string);
                    }
                    Collection collection = (List)destination$iv$iv;
                    Collection thisCollection$iv2 = collection;
                    String[] stringArray2 = thisCollection$iv2.toArray(new String[thisCollection$iv2.size()]);
                    if (stringArray2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    stringArray = stringArray2;
                    return stringArray;
                }
                while (iterator$iv.hasPrevious()) {
                    String p1 = (String)iterator$iv.previous();
                    CharSequence charSequence = p1;
                    if (charSequence.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)list2, (int)(iterator$iv.nextIndex() + 1));
                    break block10;
                }
            }
            list = CollectionsKt.emptyList();
        }
        Collection collection = list;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        thisCollection$iv2 = collection2;
        String[] stringArray3 = thisCollection$iv2.toArray(new String[thisCollection$iv2.size()]);
        if (stringArray3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        stringArray = stringArray3;
        return stringArray;
    }

    @NotNull
    public static final String unescape(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        int last = str.length() - 1;
        if (str.length() < 2 || str.charAt(0) != '\"' || str.charAt(last) != '\"') {
            return str;
        }
        StringBuilder unescaped = new StringBuilder(str.length() - 2);
        for (int i2 = 1; i2 < last; ++i2) {
            char c = str.charAt(i2);
            if (c == '/' && i2 + 1 < last) {
                ++i2;
            }
            unescaped.append(c);
        }
        String string = unescaped.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"unescaped.toString()");
        return string;
    }

    @NotNull
    public static final String nameToScript(@NotNull String $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CharSequence charSequence = $receiver;
        Pattern pattern = goodNameTemplate;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"goodNameTemplate");
        if (BaseIntrospectionFunctions.matches(charSequence, pattern)) {
            string = $receiver;
        } else {
            char c = '\"';
            String string2 = StringsKt.replace$default((String)$receiver, (String)"\"", (String)"\"\"", (boolean)false, (int)4, null);
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = String.valueOf(c) + string2;
            string = stringBuilder.append(string3).append('\"').toString();
        }
        return string;
    }

    private static final boolean isNotEmpty(long[] array) {
        long[] lArray;
        long[] lArray2;
        return array != null && !((lArray2 = (lArray = array)).length == 0);
    }

    public static final int getLength(@Nullable Object[] $receiver) {
        return $receiver != null ? $receiver.length : 0;
    }

    public static final int getLength(@Nullable long[] $receiver) {
        return $receiver != null ? $receiver.length : 0;
    }

    @NotNull
    public static final String removeSuffix(@NotNull String $receiver, char c) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int n = $receiver.length();
        if (n > 0 || $receiver.charAt(n - 1) == c) {
            String string = $receiver;
            int n2 = 0;
            int n3 = n - 1;
            String string2 = string.substring(n2, n3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string2;
        }
        return $receiver;
    }

    public static final /* synthetic */ boolean access$isNotEmpty(@Nullable long[] array) {
        return PostgresIntrospectorBaseKt.isNotEmpty(array);
    }

    @NotNull
    public static final /* synthetic */ DataType access$dataTypeOf(@Nullable String spec) {
        return PostgresIntrospectorBaseKt.dataTypeOf(spec);
    }
}

