/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import java.sql.Timestamp;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.sql.Scriptum;
import org.jetbrains.dekaf.sql.SqlQuery;

public final class ExasolIntroQueries {
    static ExasolIntroQueries QUERIES = new ExasolIntroQueries();
    @NotNull
    private final Scriptum myScriptum = Scriptum.of(ExasolIntroQueries.class);
    final SqlQuery<Timestamp> askForTimeNow = new SqlQuery("select sysdate", Layouts.rowOf((RowLayout)Layouts.oneOf(Timestamp.class)));
    final SqlQuery<String> askOpenedSchema = new SqlQuery("select current_schema", Layouts.rowOf((RowLayout)Layouts.oneOf(String.class)));
    final SqlQuery<List<SchemaInfo>> retrieveAllSchemas = this.myScriptum.query("RetrieveAllSchemas", Layouts.listOf((RowLayout)Layouts.structOf(SchemaInfo.class)));
    final SqlQuery<List<ObjectInfo>> retrieveAllObjects = this.myScriptum.query("RetrieveAllObjects", Layouts.listOf((RowLayout)Layouts.structOf(ObjectInfo.class)));
    final SqlQuery<List<ObjectInfo>> retrieveAllSysObjects = this.myScriptum.query("RetrieveAllSysObjects", Layouts.listOf((RowLayout)Layouts.structOf(ObjectInfo.class)));
    final SqlQuery<List<ColumnInfo>> retrieveColumns = this.myScriptum.query("RetrieveColumns", Layouts.listOf((RowLayout)Layouts.structOf(ColumnInfo.class)));
    final SqlQuery<List<ConstraintColumnInfo>> retrieveConstraints = this.myScriptum.query("RetrieveConstraints", Layouts.listOf((RowLayout)Layouts.structOf(ConstraintColumnInfo.class)));
    final SqlQuery<List<ViewInfo>> retrieveViews = this.myScriptum.query("RetrieveViews", Layouts.listOf((RowLayout)Layouts.structOf(ViewInfo.class)));
    final SqlQuery<List<FunctionInfo>> retrieveFunctions = this.myScriptum.query("RetrieveFunctions", Layouts.listOf((RowLayout)Layouts.structOf(FunctionInfo.class)));
    final SqlQuery<List<ScriptInfo>> retrieveScripts = this.myScriptum.query("RetrieveScripts", Layouts.listOf((RowLayout)Layouts.structOf(ScriptInfo.class)));
    final SqlQuery<List<UserInfo>> retrieveUsers = this.myScriptum.query("RetrieveUsers", Layouts.listOf((RowLayout)Layouts.structOf(UserInfo.class)));
    final SqlQuery<List<RoleInfo>> retrieveRoles = this.myScriptum.query("RetrieveRoles", Layouts.listOf((RowLayout)Layouts.structOf(RoleInfo.class)));
    final SqlQuery<List<ConnectionInfo>> retrieveConnections = this.myScriptum.query("RetrieveConnections", Layouts.listOf((RowLayout)Layouts.structOf(ConnectionInfo.class)));
    final SqlQuery<List<String>> retrievePrivileges = this.myScriptum.query("RetrievePrivileges", Layouts.listOf((RowLayout)Layouts.oneOf(String.class)));

    static final class ConnectionInfo {
        String name;
        String comment;
        String connection_string;
        String user_name;

        ConnectionInfo() {
        }
    }

    static final class RoleInfo {
        String name;
        String comment;
        Boolean is_system;

        RoleInfo() {
        }
    }

    static final class UserInfo {
        String name;
        String comment;
        Boolean is_system;

        UserInfo() {
        }
    }

    static final class ScriptInfo {
        String name;
        String type;
        String lang;
        String input_type;
        String result_type;
        String text;

        ScriptInfo() {
        }
    }

    static final class FunctionInfo {
        String name;
        String text;

        FunctionInfo() {
        }
    }

    static final class ViewInfo {
        String name;
        String text;

        ViewInfo() {
        }
    }

    static final class ConstraintColumnInfo {
        String table_name;
        Boolean is_pk;
        String name;
        String column_name;
        Short pos;
        String ref_schema;
        String ref_table;
        String ref_column;

        ConstraintColumnInfo() {
        }
    }

    static final class ColumnInfo {
        String table_name;
        Boolean is_table;
        String name;
        String type;
        Short pos;
        Boolean is_nullable;
        Boolean is_dist_key;
        String def;
        Long ident;
        String comment;

        ColumnInfo() {
        }
    }

    static final class ObjectInfo {
        String name;
        Long id;
        String comment;
        String type;

        ObjectInfo() {
        }
    }

    static final class SchemaInfo {
        Long id;
        String name;
        Boolean is_virtual;
        String comment;

        SchemaInfo() {
        }
    }
}

