/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.SqlValuesExtractor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlInsertValuesExtractor
extends SqlValuesExtractor {
    public SqlInsertValuesExtractor(@NotNull ObjectFormatter converter, @Nullable DasTable databaseTable) {
        if (converter == null) {
            SqlInsertValuesExtractor.$$$reportNull$$$0(0);
        }
        super(converter, databaseTable);
    }

    @Override
    public DataExtractor.Extraction startExtraction(CharOut out, DatabaseDialectEx dialect, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new SqlInsertExtraction(out, dialect, forceSkipHeader, allColumns, selectedColumns);
    }

    private static void removeComputedAndAutoVal(int[] selectedColumns, TIntObjectHashMap<DataConsumer.Column> columnsMap, DasTable databaseTable) {
        boolean skipGenerated = DataExtractorProperties.isSkipGeneratedColumns();
        boolean skipComputed = DataExtractorProperties.isSkipComputed();
        for (int selectedColumn : selectedColumns) {
            DasColumn dasColumn;
            DataConsumer.Column column = (DataConsumer.Column)columnsMap.get(selectedColumn);
            if (column == null) continue;
            if (DbImplUtil.isRowId(column)) {
                columnsMap.remove(selectedColumn);
                continue;
            }
            if (databaseTable == null || (dasColumn = (DasColumn)DasUtil.findChild((DasObject)databaseTable, DasColumn.class, (ObjectKind)ObjectKind.COLUMN, (String)column.name)) == null || (!skipGenerated || !DasUtil.isAutoGenerated((DasColumn)dasColumn)) && (!skipComputed || !DasUtil.isComputed((DasColumn)dasColumn))) continue;
            columnsMap.remove(selectedColumn);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/database/extractors/SqlInsertValuesExtractor", "<init>"));
    }

    private class SqlInsertExtraction
    extends SqlValuesExtractor.SqlExtractionBase {
        public SqlInsertExtraction(CharOut output, DatabaseDialectEx dialect, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            super(SqlInsertValuesExtractor.this, output, dialect, forceSkipHeader, allColumns, selectedColumnIndices);
        }

        @Override
        protected void appendHeader(boolean appendNewLine) {
            if (SqlInsertValuesExtractor.this.myDatabaseTable == null) {
                this.myDdlBuilder.keyword("CREATE").space().keyword("TABLE").space().identifier("MY_TABLE").space().symbol("(").newLine();
                boolean first = true;
                for (DataConsumer.Column column : this.myAllColumns) {
                    if (DbImplUtil.isRowId(column)) continue;
                    if (first) {
                        first = false;
                    } else {
                        this.myDdlBuilder.symbol(",").newLine();
                    }
                    String typeName = StringUtil.isEmpty((String)column.typeName) ? "unknown" : column.typeName;
                    this.myDdlBuilder.space(2).columnRef(column.name).space().type(typeName);
                }
                this.myDdlBuilder.newLine().symbol(")").newStatement();
            } else if (DataExtractorProperties.isIncludeCreateTable()) {
                this.myDdlBuilder.table(SqlInsertValuesExtractor.this.myDatabaseTable).newStatement();
            }
        }

        @Override
        protected void appendData(List<DataConsumer.Row> rows) {
            int[] selectedColumns = ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
            TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
            SqlInsertValuesExtractor.removeComputedAndAutoVal(selectedColumns, (TIntObjectHashMap<DataConsumer.Column>)columnsMap, SqlInsertValuesExtractor.this.myDatabaseTable);
            for (DataConsumer.Row row : rows) {
                DataConsumer.Column column;
                this.myDdlBuilder.keyword("INSERT").space().keyword("INTO").space();
                if (SqlInsertValuesExtractor.this.myDatabaseTable != null) {
                    this.myDdlBuilder.qualifiedRef((DasObject)SqlInsertValuesExtractor.this.myDatabaseTable).space();
                } else {
                    this.myDdlBuilder.identifier("MY_TABLE");
                }
                boolean first = true;
                this.myDdlBuilder.symbol("(");
                for (int selectedColumn : selectedColumns) {
                    column = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        this.myDdlBuilder.symbol(",").space();
                    }
                    this.myDdlBuilder.columnRef(column.name);
                }
                this.myDdlBuilder.symbol(")").space();
                first = true;
                this.myDdlBuilder.keyword("VALUES").space().symbol("(");
                for (int selectedColumn : selectedColumns) {
                    column = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        this.myDdlBuilder.symbol(",").space();
                    }
                    this.myDdlBuilder.literal(SqlInsertValuesExtractor.this.getValueLiteral(row, column, this.myDialect));
                }
                this.myDdlBuilder.symbol(")");
                this.myDdlBuilder.newStatement();
            }
        }
    }
}

