/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.csv;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.csv.CsvPreviewComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatComponent
implements ImportComponent<Object, CsvPreviewComponent.CsvPreviewInfo> {
    private final Disposable myDisposable;
    private final CsvFormatsSelectionUI myForm;
    private final ImportAction.ImportEditorContext myContext;
    private final VirtualFile myFile;

    public CsvFormatComponent(@NotNull ImportAction.ImportEditorContext context, @NotNull VirtualFile file) {
        if (context == null) {
            CsvFormatComponent.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CsvFormatComponent.$$$reportNull$$$0(1);
        }
        this.myDisposable = context.getDisposable();
        this.myForm = CsvFormatsSelectionUI.createDatabaseSettingsBackedForm(context.getDisposable(), context.getBuilder().getImportType().getCsvFormatSettings());
        this.myContext = context;
        this.myFile = file;
        this.selectMoreSuitableFormat();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myForm.getComponent();
        if (jComponent == null) {
            CsvFormatComponent.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener<?> listener) {
        if (listener == null) {
            CsvFormatComponent.$$$reportNull$$$0(3);
        }
        this.myForm.addFormatChangeListener(source -> {
            if (listener == null) {
                CsvFormatComponent.$$$reportNull$$$0(9);
            }
            listener.changed(this, this.getInfo());
        }, this.myDisposable);
    }

    @Override
    @NotNull
    public CompletionStage<CsvPreviewComponent.CsvPreviewInfo> notifyChanged(@Nullable Object object) {
        CompletableFuture<CsvPreviewComponent.CsvPreviewInfo> completableFuture = CompletableFuture.completedFuture(this.getInfo());
        if (completableFuture == null) {
            CsvFormatComponent.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    @Override
    public boolean dependsOn(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            CsvFormatComponent.$$$reportNull$$$0(5);
        }
        return observer instanceof CsvPreviewComponent;
    }

    @Override
    public void build(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            CsvFormatComponent.$$$reportNull$$$0(6);
        }
        CsvFormat format = this.myForm.getSelectedFormat();
        builder.csvFormat((CsvFormat)ObjectUtils.assertNotNull((Object)format));
        CsvFormatResolver.saveCsvFormat((CsvFormat)ObjectUtils.assertNotNull((Object)format), this.myFile);
    }

    @Override
    public boolean isVisible(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            CsvFormatComponent.$$$reportNull$$$0(7);
        }
        return builder.getFormat() == null;
    }

    @NotNull
    private CsvPreviewComponent.FormatInfo getInfo() {
        CsvPreviewComponent.FormatInfo formatInfo = new CsvPreviewComponent.FormatInfo((CsvFormat)ObjectUtils.assertNotNull((Object)this.myForm.getSelectedFormat()));
        if (formatInfo == null) {
            CsvFormatComponent.$$$reportNull$$$0(8);
        }
        return formatInfo;
    }

    private void selectMoreSuitableFormat() {
        Project project = this.myContext.getProject();
        CsvFormat format = CsvFormatResolver.getFormat((Project)ObjectUtils.assertNotNull((Object)project), this.myFile);
        if (format != null) {
            this.myForm.select(format);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/csv/CsvFormatComponent";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/csv/CsvFormatComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyChanged";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dependsOn";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addListener$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

