/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportErrorHandler;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.util.containers.ContainerUtil;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.LinkedTransferQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImporterGenerator {
    private final Thread myReaderThread;
    private final ReaderTask myReaderTask;
    private final LinkedTransferQueue<ReaderTask.Result> myTransferQueue;
    private final ImportInfo myInfo;
    private final ImportErrorHandler myHandler;
    private final ImportManager myManager;
    private boolean myStopped;

    ImporterGenerator(@NotNull ImportInfo info, @NotNull ImportErrorHandler handler, @NotNull ImportManager manager, @NotNull ReaderTask.Input input) {
        if (info == null) {
            ImporterGenerator.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            ImporterGenerator.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            ImporterGenerator.$$$reportNull$$$0(2);
        }
        if (input == null) {
            ImporterGenerator.$$$reportNull$$$0(3);
        }
        this.myInfo = info;
        this.myHandler = handler;
        this.myManager = manager;
        this.myTransferQueue = new LinkedTransferQueue();
        this.myReaderTask = new ReaderTask(input, this.myTransferQueue);
        this.myReaderThread = new Thread((Runnable)this.myReaderTask, "Import data reader");
    }

    protected void retrieveColumns(@NotNull DatabaseConnection connection) throws Exception {
        DdlBuilder builder;
        List<ColumnDescriptor> columns2;
        if (connection == null) {
            ImporterGenerator.$$$reportNull$$$0(4);
        }
        if ((columns2 = this.getColumns(connection, builder = this.myManager.getDialect().sqlSelectAll(ImportManager.createConfiguredBuilder(this.myInfo.getContext()), this.myInfo.getTable(), (DatabaseSystem)this.myInfo.getContext().getDataSource(), null, null, false, 1))) == null) {
            return;
        }
        if (columns2.size() != this.myInfo.getConsumers().size()) {
            throw new IllegalStateException("Column count is different from expected");
        }
        this.myInfo.setConsumers(columns2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<ColumnDescriptor> getColumns(@NotNull DatabaseConnection connection, @NotNull DdlBuilder builder) throws Exception {
        if (connection == null) {
            ImporterGenerator.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            ImporterGenerator.$$$reportNull$$$0(6);
        }
        Statement statement = connection.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery(builder.getStatement());
            if (resultSet == null) {
                List<ColumnDescriptor> list = null;
                return list;
            }
            List list = ContainerUtil.list((Object[])JdbcEngine.getColumnDescriptors(resultSet, this.myManager.getDialect()));
            return list;
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
    }

    @Nullable
    ReaderTask.Importer generate() throws Exception {
        if (this.myStopped) {
            return null;
        }
        ReaderTask.Result result2 = this.receiveParameters();
        if (result2 == ReaderTask.Result.POISON) {
            this.myStopped = true;
            return null;
        }
        return result2.prepare(this.myInfo);
    }

    void stop() {
        this.myReaderTask.stop();
        this.myReaderThread.interrupt();
        this.myHandler.stop();
    }

    void start(@NotNull DatabaseConnection connection) throws Exception {
        if (connection == null) {
            ImporterGenerator.$$$reportNull$$$0(7);
        }
        this.retrieveColumns(connection);
        this.myReaderThread.start();
        this.myHandler.start();
    }

    @Nullable
    String getError() {
        return this.myReaderTask.getError();
    }

    @NotNull
    private ReaderTask.Result receiveParameters() {
        ReaderTask.Result result2;
        try {
            result2 = this.myTransferQueue.take();
        }
        catch (InterruptedException e) {
            ReaderTask.Result result3 = ReaderTask.Result.POISON;
            if (result3 == null) {
                ImporterGenerator.$$$reportNull$$$0(9);
            }
            return result3;
        }
        if (result2 == null) {
            ImporterGenerator.$$$reportNull$$$0(8);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImporterGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImporterGenerator";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "receiveParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "retrieveColumns";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

