/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url;

import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataInterchange
implements UserDataHolder {
    public static final Key<?> ACTIVITY = Key.create((String)"ACTIVITY");
    private final DataSourceConfigurable myConfigurable;
    private final Map<String, String> myProperties;
    private final Set<String> myPersistentProperties;
    private final Map<Key, Object> myUserData;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final EventDispatcher<UserDataListener> myDispatcher;
    private final EventDispatcher<NestedChangeListener> myNestedDispatcher;
    private int myDepth;

    public void addGroupedChangeListener(@NotNull NestedChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            DataInterchange.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            DataInterchange.$$$reportNull$$$0(1);
        }
        this.myNestedDispatcher.addListener((EventListener)listener, parent);
    }

    public DataInterchange(@NotNull DataSourceConfigurable configurable) {
        if (configurable == null) {
            DataInterchange.$$$reportNull$$$0(2);
        }
        this.myProperties = ContainerUtil.newHashMap();
        this.myPersistentProperties = ContainerUtil.newHashSet();
        this.myUserData = ContainerUtil.newHashMap();
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myDispatcher = EventDispatcher.create(UserDataListener.class);
        this.myNestedDispatcher = EventDispatcher.create(NestedChangeListener.class);
        this.myDepth = 0;
        this.myConfigurable = configurable;
    }

    public Project getProject() {
        return this.myConfigurable.getProject();
    }

    public void showError(@Nullable String message, @NotNull Object id) {
        if (id == null) {
            DataInterchange.$$$reportNull$$$0(3);
        }
        this.myConfigurable.showErrorNotification(message, id);
    }

    @NotNull
    public Set<String> getPersistentProperties() {
        Set<String> set = this.myPersistentProperties;
        if (set == null) {
            DataInterchange.$$$reportNull$$$0(4);
        }
        return set;
    }

    public void addPersistentProperty(@NotNull String key2) {
        if (key2 == null) {
            DataInterchange.$$$reportNull$$$0(5);
        }
        this.myPersistentProperties.add(key2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putProperty(@NotNull String key2, @Nullable String val) {
        if (key2 == null) {
            DataInterchange.$$$reportNull$$$0(6);
        }
        this.startNested();
        try {
            String prev = this.myProperties.put(key2, val);
            this.myPropertyChangeSupport.firePropertyChange(key2, prev, val);
        }
        finally {
            this.endNested();
        }
    }

    @Nullable
    public String getProperty(@NotNull String key2) {
        if (key2 == null) {
            DataInterchange.$$$reportNull$$$0(7);
        }
        return this.myProperties.get(key2);
    }

    public void addPropertyChangeListener(final @NotNull PropertyChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            DataInterchange.$$$reportNull$$$0(8);
        }
        if (parent == null) {
            DataInterchange.$$$reportNull$$$0(9);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                DataInterchange.this.myPropertyChangeSupport.removePropertyChangeListener(listener);
            }
        });
    }

    public void addPropertyChangeListener(final @NotNull String key2, final @NotNull PropertyChangeListener listener, @NotNull Disposable parent) {
        if (key2 == null) {
            DataInterchange.$$$reportNull$$$0(10);
        }
        if (listener == null) {
            DataInterchange.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            DataInterchange.$$$reportNull$$$0(12);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(key2, listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                DataInterchange.this.myPropertyChangeSupport.removePropertyChangeListener(key2, listener);
            }
        });
    }

    public void forceUpdateProperty(@NotNull String key2) {
        if (key2 == null) {
            DataInterchange.$$$reportNull$$$0(13);
        }
        this.startNested();
        try {
            String prev = this.myProperties.get(key2);
            this.myPropertyChangeSupport.firePropertyChange(key2, prev == null ? "" : null, prev);
        }
        finally {
            this.endNested();
        }
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            DataInterchange.$$$reportNull$$$0(14);
        }
        return (T)key2.get(this.myUserData);
    }

    public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value) {
        if (key2 == null) {
            DataInterchange.$$$reportNull$$$0(15);
        }
        if (Comparing.equal(this.getUserData(key2), value)) {
            return;
        }
        key2.set(this.myUserData, value);
        this.fireUserDataChanged(key2);
    }

    public void fireUserDataChanged(@NotNull Key changed) {
        if (changed == null) {
            DataInterchange.$$$reportNull$$$0(16);
        }
        ((UserDataListener)this.myDispatcher.getMulticaster()).userDataChanged(changed);
    }

    public void addUserDataListener(@NotNull UserDataListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            DataInterchange.$$$reportNull$$$0(17);
        }
        if (parent == null) {
            DataInterchange.$$$reportNull$$$0(18);
        }
        this.myDispatcher.addListener((EventListener)listener, parent);
    }

    public void startNested() {
        ++this.myDepth;
    }

    public void endNested() {
        ((NestedChangeListener)this.myNestedDispatcher.getMulticaster()).nestedChange(--this.myDepth);
    }

    @NotNull
    public LocalDataSource buildDataSource() {
        LocalDataSource result2 = new LocalDataSource();
        this.myConfigurable.saveData(result2, true, true);
        LocalDataSource localDataSource = result2;
        if (localDataSource == null) {
            DataInterchange.$$$reportNull$$$0(19);
        }
        return localDataSource;
    }

    @Nullable
    public DatabaseDriver getDriver() {
        return this.myConfigurable.getTempDataSource().getDatabaseDriver();
    }

    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this.myConfigurable.getTempDataSource();
        if (localDataSource == null) {
            DataInterchange.$$$reportNull$$$0(20);
        }
        return localDataSource;
    }

    @NotNull
    public LocalDataSource getDataSourceRef() {
        LocalDataSource localDataSource = this.myConfigurable.getTempDataSource();
        if (localDataSource == null) {
            DataInterchange.$$$reportNull$$$0(21);
        }
        return localDataSource;
    }

    @Nullable
    public StatelessJdbcUrlParser getActiveParser() {
        return this.myConfigurable.getActiveParser();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: 
            case 9: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/DataInterchange";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/DataInterchange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistentProperties";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDataSource";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addGroupedChangeListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 4: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPersistentProperty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "forceUpdateProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fireUserDataChanged";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addUserDataListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface NestedChangeListener
    extends EventListener {
        public void nestedChange(int var1);
    }

    public static interface UserDataListener
    extends EventListener {
        public void userDataChanged(@NotNull Key var1);
    }
}

