/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendFiles;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendZipData;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

class DbSrcBackend {
    private final DbSrcBackendFiles myFiles;

    public DbSrcBackend(@NotNull String root2, @NotNull Listener listener) {
        if (root2 == null) {
            DbSrcBackend.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            DbSrcBackend.$$$reportNull$$$0(1);
        }
        this.myFiles = new DbSrcBackendFiles(root2, listener);
    }

    @NotNull
    public @SystemDependent String getRoot() {
        String string = this.myFiles.getRoot();
        if (string == null) {
            DbSrcBackend.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public Pair<List<DbSrcPath>, List<DbSrcPath>> list(@Nullable DbSrcPath object, @NotNull String group2, boolean staging) {
        DbSrcBackendZipData data;
        if (group2 == null) {
            DbSrcBackend.$$$reportNull$$$0(3);
        }
        if ((data = this.getZipData(object, staging, true)) != null) {
            return data.list(object, group2);
        }
        return this.myFiles.list(object, group2, staging);
    }

    @NotNull
    public Iterable<String> listGroups(@Nullable DbSrcPath object, boolean staging) {
        DbSrcBackendZipData data = this.getZipData(object, staging, true);
        if (data != null) {
            Iterable<String> iterable = data.listGroups(object);
            if (iterable == null) {
                DbSrcBackend.$$$reportNull$$$0(4);
            }
            return iterable;
        }
        Iterable<String> iterable = this.myFiles.listGroups(object, staging);
        if (iterable == null) {
            DbSrcBackend.$$$reportNull$$$0(5);
        }
        return iterable;
    }

    public boolean hasChildren(@Nullable DbSrcPath object, boolean staging) {
        DbSrcBackendZipData data = this.getZipData(object, staging, true);
        if (data != null) {
            return data.hasChildren(object);
        }
        return this.myFiles.hasChildren(object, staging);
    }

    public boolean hasGroup(@Nullable DbSrcPath object, @NotNull String group2, boolean staging) {
        DbSrcBackendZipData data;
        if (group2 == null) {
            DbSrcBackend.$$$reportNull$$$0(6);
        }
        if ((data = this.getZipData(object, staging, true)) != null) {
            return data.hasGroup(object, group2);
        }
        return this.myFiles.hasGroup(object, group2, staging);
    }

    public void dropObject(@Nullable DbSrcPath object, boolean staging) throws IOException {
        DbSrcPath zipRoot;
        DbSrcPath dbSrcPath = zipRoot = staging ? null : DbSrcBackend.getZipRoot(object);
        if (zipRoot != null) {
            DbSrcBackendZipData data;
            DbSrcBackendZipData dbSrcBackendZipData = data = zipRoot == object ? this.myFiles.getCachedZipData(zipRoot) : this.myFiles.getZipData(zipRoot);
            if (data != null) {
                data.dropObject(object);
            }
        } else {
            this.myFiles.dropObject(object, staging);
        }
    }

    @Nullable
    public byte[] getContent(@NotNull DbSrcPath object, boolean staging) throws IOException {
        DbSrcBackendZipData data;
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(7);
        }
        if ((data = this.getZipData(object, staging, false)) != null) {
            return data.getContent(object);
        }
        return this.myFiles.getContent(object, staging);
    }

    @Nullable
    public InputStream getContentInputStream(@NotNull DbSrcPath object, boolean staging) throws IOException {
        DbSrcBackendZipData data;
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(8);
        }
        if ((data = this.getZipData(object, staging, false)) != null) {
            byte[] content = data.getContent(object);
            return content == null ? null : new BufferExposingByteArrayInputStream(content);
        }
        return this.myFiles.getContentInputStream(object, staging);
    }

    @Nullable
    public FileAttributes getSrcAttributes(@NotNull DbSrcPath object, boolean staging) {
        DbSrcBackendZipData data;
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(9);
        }
        if ((data = this.getZipData(object, staging, false)) != null) {
            return data.getSrcAttributes(object);
        }
        return this.myFiles.getSrcAttributes(object, staging);
    }

    public void putContent(@NotNull DbSrcPath object, boolean staging, @Nullable byte[] content, @Nullable DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(10);
        }
        if (metaData == null && !staging) {
            metaData = this.getMetaData(object);
        }
        if (metaData == null) {
            metaData = DbSrcStorageDsMetadata.MetaData.EMPTY;
        }
        this.putMetaData(object, staging, metaData);
        DbSrcBackendZipData data = this.getZipData(object, staging, false);
        if (data != null) {
            data.putContent(object, content);
        } else {
            this.myFiles.putContent(object, staging, content);
        }
    }

    public void setTimestamp(@NotNull DbSrcPath object, boolean staging, long timestamp) throws IOException {
        DbSrcBackendZipData data;
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(11);
        }
        if ((data = this.getZipData(object, staging, false)) != null) {
            data.setTimestamp(object, timestamp);
        } else {
            this.myFiles.setTimestamp(object, staging, timestamp);
        }
    }

    private void cascadeObjectCreation(@NotNull DbSrcPath object, boolean staging) throws IOException {
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(12);
        }
        this.putMetaData(object, staging, staging ? DbSrcStorageDsMetadata.MetaData.EMPTY : (DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)this.getMetaData(object), (Object)DbSrcStorageDsMetadata.MetaData.EMPTY));
    }

    public void putMetaData(@NotNull DbSrcPath object, boolean staging, @NotNull DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        DbSrcBackendZipData data;
        DbSrcStorageDsMetadata.MetaData existing;
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(13);
        }
        if (metaData == null) {
            DbSrcBackend.$$$reportNull$$$0(14);
        }
        DbSrcStorageDsMetadata.MetaData metaData2 = existing = staging ? this.myFiles.getStagingMetaData(object) : this.getMetaData(object);
        if (Comparing.equal((Object)existing, (Object)metaData)) {
            return;
        }
        DbSrcPath parent = object.getParent();
        if (parent != null) {
            this.cascadeObjectCreation(parent, staging);
        }
        if ((data = this.getZipData(object, staging, false)) != null) {
            data.putMetaData(object, metaData);
        } else {
            this.myFiles.putMetaData(object, staging, metaData);
        }
        if (!staging) {
            this.myFiles.putMetaDataToCache(object, metaData);
        }
    }

    @Nullable
    public DbSrcStorageDsMetadata.MetaData getMetaData(@NotNull DbSrcPath object) {
        DbSrcStorageDsMetadata.MetaData res;
        if (object == null) {
            DbSrcBackend.$$$reportNull$$$0(15);
        }
        if ((res = this.myFiles.getCachedMetaData(object)) != null) {
            return res;
        }
        DbSrcBackendZipData data = this.getZipData(object, false, false);
        res = data != null ? data.readMetaData(object) : this.myFiles.readMetaData(object);
        if (res != null) {
            this.myFiles.putMetaDataToCache(object, res);
        }
        return res;
    }

    @Nullable
    private DbSrcBackendZipData getZipData(@Nullable DbSrcPath object, boolean staging, boolean acceptRoot) {
        DbSrcPath zipRoot = staging ? null : DbSrcBackend.getZipRoot(object);
        return zipRoot != null && (object != zipRoot || acceptRoot) ? this.myFiles.getZipData(zipRoot) : null;
    }

    @NotNull
    public DbSrcBackendFiles.Locker writeLock() {
        DbSrcBackendFiles.Locker locker = this.myFiles.writeLock();
        if (locker == null) {
            DbSrcBackend.$$$reportNull$$$0(16);
        }
        return locker;
    }

    @Nullable
    private static DbSrcPath getZipRoot(@Nullable DbSrcPath object) {
        if (object == null) {
            return null;
        }
        int size = object.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!DbSrcBackendFiles.isZipRoot(object.kind(i2))) continue;
            return object.getPath(i2);
        }
        return null;
    }

    public void resetCaches() {
        this.myFiles.resetCaches();
    }

    public void finish() {
        this.myFiles.finish();
    }

    public void drop() {
        this.myFiles.drop();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackend";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackend";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "listGroups";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "writeLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasGroup";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContentInputStream";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSrcAttributes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putContent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cascadeObjectCreation";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "putMetaData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMetaData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface Listener {
        public void fileChanged(@NotNull DbSrcPath var1, boolean var2);

        public void dirChanged(@Nullable DbSrcPath var1, boolean var2, boolean var3);
    }
}

