/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcFileSystem
extends NewVirtualFileSystem {
    public static final String PROTOCOL = "dbSrc";
    public static final FileAttributes DEFAULT_FOLDER_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, 0L, false);
    public static final String APP_PROJECT_ID = "app";
    private static final String EMPTY = "&empty;";
    private static final List<List<String>> ESCAPES = Arrays.asList(Arrays.asList("/", "\\", "&", "@"), Arrays.asList("&eslash;", "&slash;", "&amp;", "&at;"));

    public static DbSrcFileSystem getInstance() {
        return (DbSrcFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public DbSrcFileSystem() {
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect();
        appConnection.subscribe(DataSourceStorage.TOPIC, (Object)new MyDataSourceUpdater(null));
        appConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){
            private volatile boolean appRegistered;

            public void projectOpened(Project project) {
                if (!this.appRegistered) {
                    this.appRegistered = true;
                    DbSrcFileSystem.this.refreshProjectStorage(null);
                }
                DbSrcFileSystem.this.refreshProjectStorage(project);
                project.getMessageBus().connect((Disposable)project).subscribe(DataSourceStorage.TOPIC, (Object)new MyDataSourceUpdater(project));
            }

            public void projectClosed(Project project) {
                DbSrcFileSystem.this.refreshProjectStorage(project);
            }
        });
    }

    private static Project getProject(String projectId) {
        return ((ProjectManagerImpl)ProjectManager.getInstance()).findOpenProjectByHash(projectId);
    }

    void refreshProjectStorage(@Nullable Project project) {
        Pair cached = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)this, (String)DbSrcFileSystem.getPath(project, null, null, ItemType.FOLDER));
        NewVirtualFile vfile = (NewVirtualFile)ObjectUtils.chooseNotNull((Object)cached.first, (Object)cached.second);
        if (vfile != null) {
            VfsUtil.markDirty((cached.first != null ? 1 : 0) != 0, (boolean)false, (VirtualFile[])new VirtualFile[]{vfile});
        }
    }

    @NotNull
    public static String getPath(@Nullable Project project, @Nullable String dsId, @Nullable DbSrcPath object, @Nullable ItemType type) {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(DbSrcUtils.getProjectId(project));
        if (dsId != null) {
            builder.append("/").append(dsId);
            if (object != null) {
                int end = object.size() - 1;
                for (int i2 = 0; i2 < end; ++i2) {
                    builder.append("/").append(DbSrcFileSystem.escapeGroup(object.kind(i2))).append("/").append(DbSrcFileSystem.escapeName(object.name(i2)));
                }
                builder.append("/").append(DbSrcFileSystem.escapeGroup(object.getKind())).append("/");
                DbSrcFileSystem.appendName(builder, object, (ItemType)((Object)ObjectUtils.chooseNotNull((Object)((Object)type), (Object)((Object)ItemType.FOLDER))));
            }
        }
        String string = builder.toString();
        if (string == null) {
            DbSrcFileSystem.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static StringBuilder appendName(@NotNull StringBuilder builder, @NotNull DbSrcPath object, @NotNull ItemType type) {
        if (builder == null) {
            DbSrcFileSystem.$$$reportNull$$$0(1);
        }
        if (object == null) {
            DbSrcFileSystem.$$$reportNull$$$0(2);
        }
        if (type == null) {
            DbSrcFileSystem.$$$reportNull$$$0(3);
        }
        builder.append(DbSrcFileSystem.escapeName(object.getName()));
        String d = object.getDisambiguator();
        if (d != null) {
            builder.append("@").append(DbSrcFileSystem.escapeName(d));
        }
        if (type != ItemType.FOLDER) {
            if (type == ItemType.ORIG) {
                builder.append(".orig");
            }
            builder.append(".sql");
        }
        return builder;
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            DbSrcFileSystem.$$$reportNull$$$0(4);
        }
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(5);
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        StringBuilder res;
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(6);
        }
        String string = (res = DbSrcFileSystem.processPath(path, new ItemProcessor<StringBuilder>(){

            @Override
            public StringBuilder processProject(@Nullable Project project) {
                return new StringBuilder(project == null ? "Application" : project.getName());
            }

            @Override
            public StringBuilder processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(0);
                }
                LocalDataSource source = DbSrcUtils.findDataSource(project, dataSourceId);
                return this.processProject(project).append(File.separator).append(source == null ? dataSourceId : source.getName());
            }

            @Override
            public StringBuilder processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String group2) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(1);
                }
                StringBuilder res = this.processPath(project, dataSourceId, path);
                if (group2 != null) {
                    res.append(File.separator).append(group2);
                }
                return res;
            }

            @Override
            public StringBuilder processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path, boolean original) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    2.$$$reportNull$$$0(3);
                }
                StringBuilder res = this.processPath(project, dataSourceId, path);
                if (path.getDisambiguator() != null) {
                    res.append(path.getDisambiguator());
                }
                if (original) {
                    res.append("[orig]");
                }
                return res;
            }

            public StringBuilder processPath(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(4);
                }
                StringBuilder res = this.processDataSource(project, dataSourceId);
                if (path != null) {
                    for (int i2 = 0; i2 < path.size(); ++i2) {
                        res.append(File.separator).append(path.kind(i2)).append(File.separator).append(path.name(i2));
                    }
                }
                return res;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processPath";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })) == null || res.length() == 0 ? path : res.toString();
        if (string == null) {
            DbSrcFileSystem.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void refresh(boolean asynchronous) {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            for (DbSrcStorage storage : DbSrcStorageManager.getInstance(project).getActiveStorages()) {
                storage.flushToFs(asynchronous);
            }
        }
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(8);
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(9);
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(10);
        }
        String string = path.startsWith("/") ? "/" : "";
        if (string == null) {
            DbSrcFileSystem.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    protected String normalize(@NotNull String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(12);
        }
        String string = path.startsWith("/") ? path : "/" + path;
        if (string == null) {
            DbSrcFileSystem.$$$reportNull$$$0(13);
        }
        return string;
    }

    public int getRank() {
        return 1;
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(14);
        }
        if (newParent == null) {
            DbSrcFileSystem.$$$reportNull$$$0(15);
        }
        if (copyName == null) {
            DbSrcFileSystem.$$$reportNull$$$0(16);
        }
        throw DbSrcFileSystem.unsupported("copy", file);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            DbSrcFileSystem.$$$reportNull$$$0(17);
        }
        if (dir == null) {
            DbSrcFileSystem.$$$reportNull$$$0(18);
        }
        throw DbSrcFileSystem.unsupported("create directory", parent);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file) throws IOException {
        if (parent == null) {
            DbSrcFileSystem.$$$reportNull$$$0(19);
        }
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(20);
        }
        throw DbSrcFileSystem.unsupported("create file", parent);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(21);
        }
        throw DbSrcFileSystem.unsupported("delete", file);
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(22);
        }
        if (newParent == null) {
            DbSrcFileSystem.$$$reportNull$$$0(23);
        }
        throw DbSrcFileSystem.unsupported("move", file);
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file, @NotNull String newName) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(24);
        }
        if (newName == null) {
            DbSrcFileSystem.$$$reportNull$$$0(25);
        }
        throw DbSrcFileSystem.unsupported("rename", file);
    }

    @NotNull
    private static IOException unsupported(@NotNull String op, @NotNull VirtualFile file) {
        if (op == null) {
            DbSrcFileSystem.$$$reportNull$$$0(26);
        }
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(27);
        }
        IOException iOException = new IOException(StringUtil.capitalize((String)op) + " is unsupported for DbSrcFS: " + file.getUrl());
        if (iOException == null) {
            DbSrcFileSystem.$$$reportNull$$$0(28);
        }
        return iOException;
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(29);
        }
        return DbSrcFileSystem.processPath(file, new ItemProcessor<FileAttributes>(){

            @Override
            public FileAttributes processRoot() {
                return DEFAULT_FOLDER_ATTRIBUTES;
            }

            @Override
            public FileAttributes processProject(@Nullable Project project) {
                return DEFAULT_FOLDER_ATTRIBUTES;
            }

            @Override
            public FileAttributes processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                DbSrcStorageManager instance;
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(0);
                }
                return (instance = DbSrcStorageManager.getInstance(project)).isStored(dataSourceId) ? DEFAULT_FOLDER_ATTRIBUTES : null;
            }

            @Override
            public FileAttributes processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String group2) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null) {
                    return null;
                }
                boolean exists = group2 != null ? storage.hasGroup(path, group2) : storage.hasChildren(path);
                return exists ? DEFAULT_FOLDER_ATTRIBUTES : null;
            }

            @Override
            public FileAttributes processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path, boolean original) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    3.$$$reportNull$$$0(3);
                }
                return (storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null ? null : storage.getSrcAttributes(path, original);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public boolean exists(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(30);
        }
        return this.getAttributes(file) != null;
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(31);
        }
        Object[] listing = ArrayUtil.toStringArray(DbSrcFileSystem.processPath(file, new ItemProcessor<Collection<String>>(){

            @Override
            public Collection<String> processRoot() {
                ArrayList res = ContainerUtil.newArrayList((Object[])new String[]{DbSrcFileSystem.APP_PROJECT_ID});
                for (Project p : ProjectManager.getInstance().getOpenProjects()) {
                    res.add(p.getLocationHash());
                }
                return res;
            }

            @Override
            public Collection<String> processOutOfDate() {
                return Collections.emptyList();
            }

            @Override
            public Collection<String> processProject(@Nullable Project project) {
                DbSrcStorageManager instance = DbSrcStorageManager.getInstance(project);
                return instance.getStoredDataSources();
            }

            @Override
            public Collection<String> processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(0);
                }
                return this.listGroups(project, dataSourceId, null);
            }

            @NotNull
            public Collection<String> listGroups(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null) {
                    List<String> list = Collections.emptyList();
                    if (list == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                List list = JBIterable.from(storage.listGroups(path)).transform(g -> DbSrcFileSystem.escapeGroup(g)).toList();
                if (list == null) {
                    4.$$$reportNull$$$0(3);
                }
                return list;
            }

            @Override
            public Collection<String> processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String group2) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(4);
                }
                if (group2 == null) {
                    return this.listGroups(project, dataSourceId, path);
                }
                DbSrcStorageManager instance = DbSrcStorageManager.getInstance(project);
                DbSrcStorage storage = instance.getStorage(dataSourceId, false);
                if (storage == null) {
                    return Collections.emptyList();
                }
                HashSet res = ContainerUtil.newHashSet();
                Trinity<Collection<DbSrcPath>, List<DbSrcPath>, List<DbSrcPath>> list = storage.list(path, group2);
                if (list == null) {
                    return Collections.emptyList();
                }
                StringBuilder nameBuilder = new StringBuilder();
                for (DbSrcPath dir : (Collection)list.first) {
                    if (!storage.hasChildren(dir)) continue;
                    res.add(this.getName(nameBuilder, dir, ItemType.FOLDER));
                }
                for (DbSrcPath dir : (List)list.second) {
                    res.add(this.getName(nameBuilder, dir, ItemType.SRC));
                }
                for (DbSrcPath dir : (List)list.third) {
                    if (res.add(this.getName(nameBuilder, dir, ItemType.SRC))) continue;
                    res.add(this.getName(nameBuilder, dir, ItemType.ORIG));
                }
                return res;
            }

            @NotNull
            public String getName(StringBuilder nameBuilder, DbSrcPath dir, ItemType t) {
                String name = DbSrcFileSystem.appendName(nameBuilder, dir, t).toString();
                nameBuilder.setLength(0);
                String string = name;
                if (string == null) {
                    4.$$$reportNull$$$0(5);
                }
                return string;
            }

            @Override
            public Collection<String> processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path, boolean original) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(6);
                }
                if (path == null) {
                    4.$$$reportNull$$$0(7);
                }
                return Collections.emptyList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$4";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$4";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listGroups";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "listGroups";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "processFolder";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "processFile";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }));
        Arrays.sort(listing);
        if (listing == null) {
            DbSrcFileSystem.$$$reportNull$$$0(32);
        }
        return listing;
    }

    public boolean isDirectory(@NotNull VirtualFile file) {
        FileAttributes attributes;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(33);
        }
        return (attributes = this.getAttributes(file)) != null && attributes.isDirectory();
    }

    public boolean isWritable(@NotNull VirtualFile file) {
        FileAttributes attributes;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(34);
        }
        return (attributes = this.getAttributes(file)) != null && attributes.isWritable();
    }

    public boolean isSymLink(@NotNull VirtualFile file) {
        FileAttributes attributes;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(35);
        }
        return (attributes = this.getAttributes(file)) != null && attributes.isSymLink();
    }

    public long getTimeStamp(@NotNull VirtualFile file) {
        FileAttributes attributes;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(36);
        }
        return (attributes = this.getAttributes(file)) != null ? attributes.lastModified : 0L;
    }

    public long getLength(@NotNull VirtualFile file) {
        FileAttributes attributes;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(37);
        }
        return (attributes = this.getAttributes(file)) != null ? attributes.length : 0L;
    }

    public void setTimeStamp(@NotNull VirtualFile file, final long timeStamp) throws IOException {
        Object res;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(38);
        }
        if ((res = DbSrcFileSystem.processPath(file, new ItemProcessor<Object>(){

            @Override
            public Object processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path, boolean original) {
                if (dataSourceId == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    5.$$$reportNull$$$0(1);
                }
                DbSrcStorage storage = DbSrcStorageManager.getInstance(project).getStorage(dataSourceId, true);
                try {
                    storage.setTimestamp(path, !original, timeStamp);
                }
                catch (Throwable th) {
                    return th;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$5";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })) instanceof IOException) {
            throw (IOException)res;
        }
        ExceptionUtil.rethrowUnchecked((Throwable)((Throwable)ObjectUtils.tryCast((Object)res, Throwable.class)));
        if (res == null) {
            throw DbSrcFileSystem.unsupported("set timestamp", file);
        }
    }

    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(39);
        }
        throw DbSrcFileSystem.unsupported("set writable", file);
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(40);
        }
        final Ref exc = Ref.create();
        byte[] res = DbSrcFileSystem.processPath(file, new ItemProcessor<byte[]>(){

            @Override
            public byte[] processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path, boolean original) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    6.$$$reportNull$$$0(1);
                }
                if ((storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null) {
                    return null;
                }
                try {
                    return storage.getContent(path, original);
                }
                catch (IOException e) {
                    exc.set((Object)e);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$6";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!exc.isNull()) {
            throw (IOException)exc.get();
        }
        byte[] byArray = (byte[])ObjectUtils.chooseNotNull((Object)res, (Object)ArrayUtil.EMPTY_BYTE_ARRAY);
        if (byArray == null) {
            DbSrcFileSystem.$$$reportNull$$$0(41);
        }
        return byArray;
    }

    public boolean isOrphaned(@NotNull VirtualFile file) {
        VirtualFile base;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(42);
        }
        if (!file.equals(base = this.getBaseFile(file, false))) {
            return false;
        }
        return DbSrcFileSystem.processPath(file, new ItemProcessor<Boolean>(){

            @Override
            public Boolean processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path, boolean original) {
                if (dataSourceId == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (original) {
                    return Boolean.FALSE;
                }
                DbSrcStorage storage = DbSrcStorageManager.getInstance(project).getStorage(dataSourceId, false);
                if (storage == null) {
                    return false;
                }
                return storage.getSrcAttributes(path, true) == null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$7";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }) == Boolean.TRUE;
    }

    @Nullable
    public VirtualFile getBaseFile(@NotNull VirtualFile file, boolean staging) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(43);
        }
        return this.getBaseFile(file, staging, false);
    }

    @Nullable
    public VirtualFile getBaseFile(@NotNull VirtualFile file, boolean staging, boolean refresh) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(44);
        }
        if (!file.isValid()) {
            return null;
        }
        String name = file.getName();
        if (name.endsWith(".orig.sql")) {
            if (!staging) {
                return file;
            }
            name = StringUtil.trimEnd((String)name, (String)".orig.sql") + ".sql";
            return (VirtualFile)ObjectUtils.chooseNotNull((Object)DbSrcFileSystem.findChild(file.getParent(), name, refresh), (Object)file);
        }
        if (name.endsWith(".sql")) {
            if (staging) {
                return file;
            }
            name = StringUtil.trimEnd((String)name, (String)".sql") + ".orig.sql";
            return (VirtualFile)ObjectUtils.chooseNotNull((Object)DbSrcFileSystem.findChild(file.getParent(), name, refresh), (Object)file);
        }
        return null;
    }

    private static VirtualFile findChild(VirtualFile parent, String name, boolean refresh) {
        return refresh ? ((NewVirtualFile)parent).refreshAndFindChild(name) : parent.findChild(name);
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(45);
        }
        final Ref exc = Ref.create();
        InputStream res = DbSrcFileSystem.processPath(file, new ItemProcessor<InputStream>(){

            @Override
            public InputStream processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path, boolean original) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    8.$$$reportNull$$$0(1);
                }
                if ((storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null) {
                    return null;
                }
                try {
                    return storage.getContentInputStream(path, original);
                }
                catch (IOException e) {
                    exc.set((Object)e);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$8";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!exc.isNull()) {
            throw (IOException)exc.get();
        }
        if (res == null) {
            throw new FileNotFoundException(file.getUrl());
        }
        InputStream inputStream = res;
        if (inputStream == null) {
            DbSrcFileSystem.$$$reportNull$$$0(46);
        }
        return inputStream;
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file, Object requestor, long modStamp, long l) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(47);
        }
        final Ref exc = Ref.create();
        OutputStream res = DbSrcFileSystem.processPath(file, new ItemProcessor<OutputStream>(){

            @Override
            public OutputStream processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path, boolean original) {
                if (dataSourceId == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    9.$$$reportNull$$$0(1);
                }
                if (original) {
                    return null;
                }
                DbSrcStorageManager instance = DbSrcStorageManager.getInstance(project);
                DbSrcStorage storage = instance.getStorage(dataSourceId, true);
                try {
                    return storage.getContentOutputStream(path);
                }
                catch (IOException e) {
                    exc.set((Object)e);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$9";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!exc.isNull()) {
            throw (IOException)exc.get();
        }
        if (res == null) {
            throw new FileNotFoundException(file.getUrl());
        }
        OutputStream outputStream = res;
        if (outputStream == null) {
            DbSrcFileSystem.$$$reportNull$$$0(48);
        }
        return outputStream;
    }

    public static <R> R processPath(@NotNull VirtualFile file, @NotNull ItemProcessor<R> processor) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(49);
        }
        if (processor == null) {
            DbSrcFileSystem.$$$reportNull$$$0(50);
        }
        return DbSrcFileSystem.processPath(file.getPath(), processor);
    }

    public static Iterable<String> splitPath(@NotNull String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(51);
        }
        return StringUtil.tokenize((String)path, (String)String.valueOf('/'));
    }

    public static <R> R processPath(@NotNull String path, @NotNull ItemProcessor<R> processor) {
        Project project;
        ArrayList items;
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(52);
        }
        if (processor == null) {
            DbSrcFileSystem.$$$reportNull$$$0(53);
        }
        if ((items = ContainerUtil.newArrayList(DbSrcFileSystem.splitPath(path))).isEmpty()) {
            return processor.processRoot();
        }
        boolean app = ((String)items.get(0)).equals(APP_PROJECT_ID);
        Project project2 = project = app ? null : DbSrcFileSystem.getProject((String)items.get(0));
        if (project == null && !app) {
            return processor.processOutOfDate();
        }
        if (items.size() <= 1) {
            return processor.processProject(project);
        }
        if (items.size() <= 2) {
            return processor.processDataSource(project, (String)items.get(1));
        }
        boolean group2 = (items.size() - 2) % 2 == 1;
        String last = (String)items.get(items.size() - 1);
        if (!group2) {
            if (last.endsWith(".sql")) {
                last = StringUtil.trimEnd((String)last, (String)".sql");
                boolean original = last.endsWith(".orig");
                last = StringUtil.trimEnd((String)last, (String)".orig");
                items.set(items.size() - 1, last);
                String disambiguator = null;
                int pt = last.indexOf(64);
                if (pt != -1) {
                    disambiguator = last.substring(pt + 1);
                    items.set(items.size() - 1, last.substring(0, pt));
                }
                return processor.processFile(project, (String)items.get(1), DbSrcFileSystem.buildObject(DbSrcFileSystem.unescapePath(items.subList(2, items.size())), DbSrcFileSystem.unescapeName(disambiguator)), original);
            }
            return processor.processFolder(project, (String)items.get(1), DbSrcFileSystem.buildObject(DbSrcFileSystem.unescapePath(items.subList(2, items.size())), null), null);
        }
        return processor.processFolder(project, (String)items.get(1), DbSrcFileSystem.buildObject(DbSrcFileSystem.unescapePath(items.subList(2, items.size() - 1)), null), DbSrcFileSystem.unescapeName(last));
    }

    @NotNull
    private static DbSrcPath buildObject(final @NotNull List<String> path, @Nullable String disambiguator) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(54);
        }
        assert (path.size() % 2 == 0);
        final int size = path.size() / 2;
        DbSrcPath dbSrcPath = new DbSrcPath((List<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return (String)path.get(index * 2 + 1);
            }

            @Override
            public int size() {
                return size;
            }
        }, (List<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return (String)path.get(index * 2);
            }

            @Override
            public int size() {
                return size;
            }
        }, size, disambiguator);
        if (dbSrcPath == null) {
            DbSrcFileSystem.$$$reportNull$$$0(55);
        }
        return dbSrcPath;
    }

    private static String escapeName(String s) {
        if (s == null) {
            return null;
        }
        if ((s = DbSrcFileSystem.escapeChars(s)).endsWith(".sql") || s.endsWith(".orig")) {
            s = s + "&";
        }
        return s;
    }

    private static String escapeGroup(String s) {
        return DbSrcFileSystem.escapeChars(s);
    }

    private static String escapeChars(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return EMPTY;
        }
        return StringUtil.replace((String)s, ESCAPES.get(0), ESCAPES.get(1));
    }

    private static String unescapeName(String s) {
        if (s == null) {
            return null;
        }
        return DbSrcFileSystem.unescapeChars(StringUtil.trimEnd((String)s, (String)"&"));
    }

    private static String unescapeGroup(String s) {
        return DbSrcFileSystem.unescapeChars(s);
    }

    private static String unescapeChars(String s) {
        if (s == null) {
            return null;
        }
        if (s.equals(EMPTY)) {
            return "";
        }
        return StringUtil.replace((String)s, ESCAPES.get(1), ESCAPES.get(0));
    }

    private static List<String> unescapePath(List<String> list) {
        int i2 = 0;
        while (i2 + 1 < list.size()) {
            list.set(i2, DbSrcFileSystem.unescapeGroup(list.get(i2)));
            list.set(i2 + 1, DbSrcFileSystem.unescapeName(list.get(i2 + 1)));
            i2 += 2;
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 51: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRootPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "unsupported";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "buildObject";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "unsupported";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isOrphaned";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getBaseFile";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processPath";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "buildObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDataSourceUpdater
    implements DataSourceStorage.Listener {
        private final Project myProject;

        MyDataSourceUpdater(Project project) {
            this.myProject = project;
        }

        @Override
        public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                MyDataSourceUpdater.$$$reportNull$$$0(0);
            }
            this.refresh(dataSource);
        }

        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                MyDataSourceUpdater.$$$reportNull$$$0(1);
            }
            this.refresh(dataSource);
        }

        void refresh(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                MyDataSourceUpdater.$$$reportNull$$$0(2);
            }
            if (this.myProject != null && dataSource.isGlobal()) {
                return;
            }
            String dataSourceId = (String)ObjectUtils.notNull((Object)dataSource.getUniqueId());
            Pair cached = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)DbSrcFileSystem.this, (String)DbSrcFileSystem.getPath(this.myProject, dataSourceId, null, ItemType.FOLDER));
            VirtualFile vfile = (VirtualFile)ObjectUtils.chooseNotNull((Object)cached.first, (Object)cached.second);
            if (vfile != null) {
                VfsUtil.markDirty((cached.first != null ? 1 : 0) != 0, (boolean)false, (VirtualFile[])new VirtualFile[]{vfile});
                RefreshQueue.getInstance().refresh(true, true, null, new VirtualFile[]{vfile});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataSource";
            objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$MyDataSourceUpdater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refresh";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ItemProcessor<R> {
        public R processRoot() {
            return null;
        }

        public R processOutOfDate() {
            return null;
        }

        public R processProject(@Nullable Project project) {
            return null;
        }

        public R processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
            if (dataSourceId == null) {
                ItemProcessor.$$$reportNull$$$0(0);
            }
            return null;
        }

        public R processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String group2) {
            if (dataSourceId == null) {
                ItemProcessor.$$$reportNull$$$0(1);
            }
            return null;
        }

        public R processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path, boolean original) {
            if (dataSourceId == null) {
                ItemProcessor.$$$reportNull$$$0(2);
            }
            if (path == null) {
                ItemProcessor.$$$reportNull$$$0(3);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSourceId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$ItemProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDataSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFolder";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ItemType {
        FOLDER,
        SRC,
        ORIG;

    }
}

