/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.database.introspection.IntrospectionScopes;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.BaseSession;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSession;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.OracleExceptionRecognizer;
import org.jetbrains.dekaf.sql.SqlQuery;

public class DefaultsInstaller {
    private final LocalDataSource myDataSource;
    private IntrospectionScope myIntrospectionScope;
    private IntrospectionScope myDefaultSchemas;

    DefaultsInstaller(@NotNull LocalDataSource ds) {
        if (ds == null) {
            DefaultsInstaller.$$$reportNull$$$0(0);
        }
        this.myDataSource = ds;
        this.myDefaultSchemas = ds.myResolveScope;
        this.myIntrospectionScope = ds.getIntrospectionScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getOracleCurrentUserAndSchema(@NotNull DatabaseConnection connection) {
        if (connection == null) {
            DefaultsInstaller.$$$reportNull$$$0(1);
        }
        SqlQuery currentUserAndSchema = new SqlQuery("select sys_context('userenv','current_schema'), user from dual", Layouts.rowOf((RowLayout)Layouts.arrayOf((int)2, String.class)));
        try (JdbcIntermediateSession intermediateSession = new JdbcIntermediateSession(null, (DBExceptionRecognizer)OracleExceptionRecognizer.INSTANCE, connection.getJdbcConnection(), false){};){
            BaseSession session = new BaseSession((IntegralIntermediateSession)intermediateSession){};
            String[] stringArray = (String[])session.query(currentUserAndSchema).run();
            return stringArray;
        }
    }

    @NotNull
    public DefaultsInstaller saveSchemas() {
        DefaultsInstaller defaultsInstaller = this;
        if (defaultsInstaller == null) {
            DefaultsInstaller.$$$reportNull$$$0(2);
        }
        return defaultsInstaller;
    }

    @NotNull
    public DefaultsInstaller setupIntrospectionScopeByDefault(@NotNull DatabaseConnection connection, @Nullable String userName) throws SQLException {
        if (connection == null) {
            DefaultsInstaller.$$$reportNull$$$0(3);
        }
        if (this.myIntrospectionScope.asList().isEmpty() && this.myDefaultSchemas.asList().isEmpty()) {
            if (this.myDataSource.getFamilyId() == DatabaseFamilyId.ORACLE) {
                List<Couple<String>> userAndSchema = DefaultsInstaller.prefixWithAsterisks(DefaultsInstaller.getOracleCurrentUserAndSchema(connection));
                this.myIntrospectionScope = IntrospectionScopes.scopeOf(ContainerUtil.concat(userAndSchema, DefaultsInstaller.prefixWithAsterisks("PUBLIC", "SYS", "SYSTEM")));
                this.myDefaultSchemas = IntrospectionScopes.scopeOf(ContainerUtil.concat(userAndSchema, DefaultsInstaller.prefixWithAsterisks("PUBLIC")));
            } else {
                String currentDatabase = connection.getJdbcConnection().getCatalog();
                Set<Couple<String>> toIntrospect = this.getDefaultSchemasToIntrospect(currentDatabase, userName);
                Set<Couple<String>> toResolve = this.getDefaultSchemasToResolve(currentDatabase, userName);
                for (Couple<String> c : toResolve) {
                    if (!toResolve.contains(c)) continue;
                    toIntrospect.add(c);
                }
                this.myIntrospectionScope = IntrospectionScopes.scopeOf(toIntrospect);
                this.myDefaultSchemas = IntrospectionScopes.scopeOf(toResolve);
            }
        }
        DefaultsInstaller defaultsInstaller = this;
        if (defaultsInstaller == null) {
            DefaultsInstaller.$$$reportNull$$$0(4);
        }
        return defaultsInstaller;
    }

    @NotNull
    private static List<Couple<String>> prefixWithAsterisks(String ... schemaNames) {
        if (schemaNames == null) {
            DefaultsInstaller.$$$reportNull$$$0(5);
        }
        List list = ContainerUtil.map((Object[])schemaNames, s -> Couple.of((Object)"*", (Object)s));
        if (list == null) {
            DefaultsInstaller.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private Set<Couple<String>> getDefaultSchemasToIntrospect(@Nullable String currentDb, @Nullable String userId) {
        DatabaseFamilyId familyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource);
        OrderedSet result2 = new OrderedSet();
        String currentDatabase = StringUtil.notNullize((String)currentDb);
        if (familyId.isDb2()) {
            result2.add(Couple.of((Object)currentDatabase, (Object)userId));
        } else if (familyId.isDerby()) {
            result2.add(Couple.of((Object)currentDatabase, (Object)userId));
            result2.add(Couple.of((Object)currentDatabase, (Object)"APP"));
        } else if (familyId.isTransactSql()) {
            result2.add(Couple.of((Object)currentDatabase, (Object)"*"));
            result2.add(Couple.of((Object)"*", (Object)"dbo"));
        } else if (familyId.isMysql()) {
            result2.add(Couple.of((Object)"*", (Object)currentDatabase));
        } else if (familyId.isPostgres()) {
            result2.add(Couple.of((Object)currentDatabase, (Object)"public"));
            result2.add(Couple.of((Object)currentDatabase, (Object)"pg_catalog"));
            result2.add(Couple.of((Object)currentDatabase, (Object)userId));
        } else if (familyId.isHsqldb() || familyId.isH2()) {
            result2.add(Couple.of((Object)currentDatabase, (Object)"public"));
        }
        OrderedSet orderedSet = result2;
        if (orderedSet == null) {
            DefaultsInstaller.$$$reportNull$$$0(7);
        }
        return orderedSet;
    }

    @NotNull
    private Set<Couple<String>> getDefaultSchemasToResolve(@Nullable String currentDb, @Nullable String userId) {
        DatabaseFamilyId familyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource);
        OrderedSet result2 = new OrderedSet();
        String currentDatabase = StringUtil.notNullize((String)currentDb);
        if (familyId.isDb2()) {
            result2.add(Couple.of((Object)currentDatabase, (Object)userId));
        } else if (familyId.isDerby()) {
            result2.add(Couple.of((Object)currentDatabase, (Object)userId));
            result2.add(Couple.of((Object)currentDatabase, (Object)"APP"));
        } else if (familyId.isTransactSql()) {
            result2.add(Couple.of((Object)currentDatabase, (Object)"*"));
        } else if (familyId.isMysql()) {
            result2.add(Couple.of((Object)"*", (Object)currentDatabase));
        } else if (familyId.isPostgres()) {
            result2.add(Couple.of((Object)currentDatabase, (Object)"public"));
            result2.add(Couple.of((Object)currentDatabase, (Object)userId));
        } else if (familyId.isHsqldb() || familyId.isH2()) {
            result2.add(Couple.of((Object)currentDatabase, (Object)"public"));
        }
        OrderedSet orderedSet = result2;
        if (orderedSet == null) {
            DefaultsInstaller.$$$reportNull$$$0(8);
        }
        return orderedSet;
    }

    @NotNull
    IntrospectionScope getIntrospectionScope() {
        IntrospectionScope introspectionScope = this.myIntrospectionScope;
        if (introspectionScope == null) {
            DefaultsInstaller.$$$reportNull$$$0(9);
        }
        return introspectionScope;
    }

    void setIntrospectionScope(@NotNull IntrospectionScope introspectionScope) {
        if (introspectionScope == null) {
            DefaultsInstaller.$$$reportNull$$$0(10);
        }
        this.myIntrospectionScope = introspectionScope;
    }

    @NotNull
    IntrospectionScope getDefaultSchemas() {
        IntrospectionScope introspectionScope = this.myDefaultSchemas;
        if (introspectionScope == null) {
            DefaultsInstaller.$$$reportNull$$$0(11);
        }
        return introspectionScope;
    }

    void setDefaultSchemas(@NotNull IntrospectionScope defaultSchemas) {
        if (defaultSchemas == null) {
            DefaultsInstaller.$$$reportNull$$$0(12);
        }
        this.myDefaultSchemas = defaultSchemas;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DefaultsInstaller";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaNames";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introspectionScope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultSchemas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DefaultsInstaller";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "saveSchemas";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setupIntrospectionScopeByDefault";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prefixWithAsterisks";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSchemasToIntrospect";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSchemasToResolve";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntrospectionScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSchemas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOracleCurrentUserAndSchema";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupIntrospectionScopeByDefault";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prefixWithAsterisks";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setIntrospectionScope";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultSchemas";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

