/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceExplainPlanConfiguration;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceOptionsEditor {
    private final DataSourceConfigurable myConfigurable;
    private ExplainPlanProvider myExplainPlanProvider;
    private JPanel myPanel;
    @Nullable
    private ComboBox myExplainPlanCombo;
    private ConfigurableUi<LocalDataSource> myExplainPlanUi;

    public DataSourceOptionsEditor(@NotNull DataSourceConfigurable configurable) {
        if (configurable == null) {
            DataSourceOptionsEditor.$$$reportNull$$$0(0);
        }
        this.myExplainPlanProvider = ExplainPlanProvider.NULL_PROVIDER;
        this.myConfigurable = configurable;
        List<ExplainPlanProvider> planProviders = ExplainPlanProvider.getProvidersFor((LocalDataSource)configurable.getDataSource());
        int rows = planProviders.size() > 1 ? 2 : 1;
        this.myPanel = new JPanel((LayoutManager)new GridLayoutManager(rows, 2));
        if (rows == 1) {
            return;
        }
        this.myExplainPlanCombo = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(planProviders));
        this.myExplainPlanCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<ExplainPlanProvider>(){

            public void customize(JList list, ExplainPlanProvider provider, int index, boolean selected, boolean hasFocus) {
                this.setText(provider.getName());
            }
        });
        JBLabel explain = new JBLabel("Explain plan:");
        GridConstraints gc = new GridConstraints();
        gc.setAnchor(8);
        gc.setUseParentLayout(true);
        this.myPanel.add((Component)explain, gc);
        gc.setColumn(1);
        this.myPanel.add((Component)this.myExplainPlanCombo, gc);
        this.myExplainPlanCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataSourceOptionsEditor.this.setProvider((ExplainPlanProvider)DataSourceOptionsEditor.this.myExplainPlanCombo.getSelectedItem()) && DataSourceOptionsEditor.this.myExplainPlanUi != null) {
                    DataSourceOptionsEditor.this.myExplainPlanUi.reset((Object)DataSourceOptionsEditor.this.myConfigurable.getTempDataSource());
                }
            }
        });
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    public void saveData(@NotNull LocalDataSource source) {
        if (source == null) {
            DataSourceOptionsEditor.$$$reportNull$$$0(1);
        }
        source.getExplainPlanConfiguration().setProviderClass(this.myExplainPlanProvider.getClass().getCanonicalName());
        if (this.myExplainPlanUi == null) {
            source.getExplainPlanConfiguration().setProviderConfig(ContainerUtil.newHashMap());
        } else {
            try {
                this.myExplainPlanUi.apply((Object)source);
            }
            catch (ConfigurationException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public void reset(@NotNull LocalDataSource source) {
        String providerClass;
        if (source == null) {
            DataSourceOptionsEditor.$$$reportNull$$$0(2);
        }
        if ((providerClass = source.getExplainPlanConfiguration().getProviderClass()) == null) {
            providerClass = DataSourceExplainPlanConfiguration.getDefaultProviderClass(source);
        }
        ExplainPlanProvider provider = ExplainPlanProvider.getProviderByClassName(providerClass);
        this.setProvider(provider);
        if (this.myExplainPlanUi != null) {
            this.myExplainPlanUi.reset((Object)source);
        }
        if (this.myExplainPlanCombo != null) {
            this.myExplainPlanCombo.setSelectedItem((Object)this.myExplainPlanProvider);
        }
    }

    private boolean setProvider(@NotNull ExplainPlanProvider provider) {
        if (provider == null) {
            DataSourceOptionsEditor.$$$reportNull$$$0(3);
        }
        this.myPanel.setVisible(false);
        if (provider == this.myExplainPlanProvider) {
            return false;
        }
        this.myExplainPlanProvider = provider;
        if (this.myExplainPlanUi != null) {
            this.myPanel.remove(this.myExplainPlanUi.getComponent());
        }
        this.myExplainPlanUi = this.myExplainPlanProvider.createOptionsComponent();
        if (this.myExplainPlanUi != null) {
            GridConstraints gc = new GridConstraints();
            gc.setUseParentLayout(true);
            gc.setFill(1);
            gc.setRow(this.myExplainPlanCombo == null ? 0 : 1);
            gc.setColumn(0);
            gc.setColSpan(2);
            this.myPanel.add((Component)this.myExplainPlanUi.getComponent(), gc);
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
        this.myPanel.setVisible(this.myPanel.getComponentCount() > 0);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/DataSourceOptionsEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "saveData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

