/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceExplainPlanConfiguration {
    public static final String ELEMENT_NAME = "explain-plan-config";
    @Nullable
    private String myProviderClass;
    @NotNull
    private Map<String, String> myProviderConfig = ContainerUtil.newHashMap();

    @Nullable
    public String getProviderClass() {
        return this.myProviderClass;
    }

    public void setProviderClass(@Nullable String providerClass) {
        this.myProviderClass = providerClass;
    }

    @NotNull
    public Map<String, String> getProviderConfig() {
        Map<String, String> map2 = this.myProviderConfig;
        if (map2 == null) {
            DataSourceExplainPlanConfiguration.$$$reportNull$$$0(0);
        }
        return map2;
    }

    public void setProviderConfig(@NotNull Map<String, String> providerConfig) {
        if (providerConfig == null) {
            DataSourceExplainPlanConfiguration.$$$reportNull$$$0(1);
        }
        this.myProviderConfig = providerConfig;
    }

    public boolean equalConfiguration(@NotNull DataSourceExplainPlanConfiguration cfg) {
        if (cfg == null) {
            DataSourceExplainPlanConfiguration.$$$reportNull$$$0(2);
        }
        if (!Comparing.equal((String)this.myProviderClass, (String)cfg.myProviderClass)) {
            return false;
        }
        return ContainerUtil.diff(this.myProviderConfig, cfg.myProviderConfig).isEmpty();
    }

    public void serialize(@NotNull HierarchicalStreamWriter serializer) {
        if (serializer == null) {
            DataSourceExplainPlanConfiguration.$$$reportNull$$$0(3);
        }
        if (!this.isEmpty()) {
            LocalDataSource.writeTag(serializer, "provider", this.myProviderClass);
            if (!this.myProviderConfig.isEmpty()) {
                serializer.startNode("parameters");
                for (Map.Entry<String, String> entry : this.myProviderConfig.entrySet()) {
                    serializer.startNode("parameter");
                    serializer.addAttribute("name", entry.getKey());
                    serializer.addAttribute("value", entry.getValue());
                    serializer.endNode();
                }
                serializer.endNode();
            }
        }
    }

    public void deserialize(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            DataSourceExplainPlanConfiguration.$$$reportNull$$$0(4);
        }
        String providerClass = null;
        HashMap config = ContainerUtil.newHashMap();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String name = reader.getNodeName();
            if ("provider".equals(name)) {
                providerClass = reader.getValue();
            } else if ("parameters".equals(name)) {
                while (reader.hasMoreChildren()) {
                    String param;
                    reader.moveDown();
                    if ("parameter".equals(reader.getNodeName()) && (param = reader.getAttribute("name")) != null) {
                        config.put(param, reader.getAttribute("value"));
                    }
                    reader.moveUp();
                }
            }
            reader.moveUp();
        }
        this.setProviderClass(providerClass);
        this.setProviderConfig(config);
    }

    public boolean isEmpty() {
        return StringUtil.isEmpty((String)this.myProviderClass);
    }

    @NotNull
    public static String resetToDefaultIfInvalid(@Nullable String providerClass, @Nullable LocalDataSource dataSource) {
        String className = ExplainPlanProvider.getProviderByClassName(providerClass).getClass().getCanonicalName();
        if (className.equals(providerClass)) {
            String string = providerClass;
            if (string == null) {
                DataSourceExplainPlanConfiguration.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = DataSourceExplainPlanConfiguration.getDefaultProviderClass(dataSource);
        if (string == null) {
            DataSourceExplainPlanConfiguration.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getDefaultProviderClass(@Nullable LocalDataSource dataSource) {
        String string = ExplainPlanProvider.getDefaultProvider(dataSource).getClass().getCanonicalName();
        if (string == null) {
            DataSourceExplainPlanConfiguration.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceExplainPlanConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfg";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderConfig";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceExplainPlanConfiguration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resetToDefaultIfInvalid";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProviderClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setProviderConfig";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "equalConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

