/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDataSourceConfigurable<M extends DbPsiManagerSpi, T extends DatabaseSystem>
extends AbstractDatabaseConfigurable<T> {
    protected final M myManager;
    protected final T myDataSource;

    public AbstractDataSourceConfigurable(@NotNull M manager, @NotNull T dataSource, @NotNull Project project) {
        if (manager == null) {
            AbstractDataSourceConfigurable.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            AbstractDataSourceConfigurable.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AbstractDataSourceConfigurable.$$$reportNull$$$0(2);
        }
        super(project, dataSource);
        this.myManager = manager;
        this.myDataSource = dataSource;
    }

    @NotNull
    public T getDataSource() {
        T t = this.myDataSource;
        if (t == null) {
            AbstractDataSourceConfigurable.$$$reportNull$$$0(3);
        }
        return t;
    }

    @Override
    @NotNull
    public T getTempTarget() {
        T t = this.getTempDataSource();
        if (t == null) {
            AbstractDataSourceConfigurable.$$$reportNull$$$0(4);
        }
        return t;
    }

    public DatabaseCredentials getSecretService() {
        return this.myController.getSecretService();
    }

    @NotNull
    public abstract T getTempDataSource();

    @NotNull
    protected String createUniqueName(String baseName) {
        String string = this.myController != null ? this.myController.generateObjectName(this.getDataSource(), baseName) : DbUtil.createNewDataSourceName((Project)this.myProject, (String)baseName);
        if (string == null) {
            AbstractDataSourceConfigurable.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        return this.isNewDataSource();
    }

    protected boolean isNewDataSource() {
        for (DbDataSource ds : this.myManager.getDataSources()) {
            if (ds.getDelegate() != this.myDataSource) continue;
            return false;
        }
        return true;
    }

    public void beforeShowNotify() {
    }

    public void onUserActivity() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/AbstractDataSourceConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/AbstractDataSourceConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempTarget";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createUniqueName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

