/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.data.types.ConversionGraph;
import com.intellij.database.data.types.ConverterSupport;
import com.intellij.database.data.types.PointSet;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataConverter<V, T> {
    private static final List<DataConverter<?, ?>> ourValues = ContainerUtil.newArrayList();
    private final PointSet<V> myStart;
    private final PointSet<T> myEnd;

    protected DataConverter(@NotNull PointSet<V> start, @NotNull PointSet<T> end) {
        if (start == null) {
            DataConverter.$$$reportNull$$$0(0);
        }
        if (end == null) {
            DataConverter.$$$reportNull$$$0(1);
        }
        this.myStart = start;
        this.myEnd = end;
        ConversionGraph.register(this);
    }

    @Nullable
    public final T convert(@Nullable V value) {
        return value == null ? null : (T)this.notNull(value);
    }

    @Nullable
    public final V convertReverse(@Nullable T value) {
        return value == null ? null : (V)this.reverseNotNull(value);
    }

    @Nullable
    protected abstract V reverseNotNull(@NotNull T var1);

    @Nullable
    protected abstract T notNull(@NotNull V var1);

    @NotNull
    public PointSet<V> getStart() {
        PointSet<V> pointSet = this.myStart;
        if (pointSet == null) {
            DataConverter.$$$reportNull$$$0(2);
        }
        return pointSet;
    }

    @NotNull
    public PointSet<T> getEnd() {
        PointSet<T> pointSet = this.myEnd;
        if (pointSet == null) {
            DataConverter.$$$reportNull$$$0(3);
        }
        return pointSet;
    }

    public static void init() {
        if (!ourValues.isEmpty()) {
            return;
        }
        ourValues.addAll(ContainerUtil.list((Object[])new DataConverter[]{new TimestampToTemporal(), new TimeToTemporal(), new TimeZonedTimeToTemporal(), new TimeZonedTimestampToTemporal(), new BinaryTextToText(), new BinaryToText(), new BooleanToBinary(), new BooleanToNumber(), new BooleanToText(), new DateToNumber(), new DateToText(), new DateToTimestamp(), new NumberToText(), new NumberToTimestamp(), new TimestampToText(), new TimeToNumber(), new TimeToText(), new TemporalTimeToTemporalTimestamp(), new UuidToText(), new ObjectToText(), new NumberRangeToText(), new DateRangeToText(), new TimestampRangeToText(), new MoneyToText()}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/DataConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/DataConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStart";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DateRangeToText
    extends DataConverter<String, String> {
        public DateRangeToText() {
            super(PointSet.DATE_RANGE, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String reverseNotNull(@NotNull String value) {
            if (value == null) {
                DateRangeToText.$$$reportNull$$$0(0);
            }
            try {
                return (String)ConverterSupport.getDateRangeFormatter().parse(value);
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        @Nullable
        protected String notNull(@NotNull String value) {
            if (value == null) {
                DateRangeToText.$$$reportNull$$$0(1);
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$DateRangeToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimestampRangeToText
    extends DataConverter<String, String> {
        public TimestampRangeToText() {
            super(PointSet.TIMESTAMP_RANGE, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String reverseNotNull(@NotNull String value) {
            if (value == null) {
                TimestampRangeToText.$$$reportNull$$$0(0);
            }
            try {
                return (String)ConverterSupport.getTimestampRangeFormatter().parse(value);
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        @Nullable
        protected String notNull(@NotNull String value) {
            if (value == null) {
                TimestampRangeToText.$$$reportNull$$$0(1);
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TimestampRangeToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NumberRangeToText
    extends DataConverter<String, String> {
        public NumberRangeToText() {
            super(PointSet.NUMBER_RANGE, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String reverseNotNull(@NotNull String value) {
            if (value == null) {
                NumberRangeToText.$$$reportNull$$$0(0);
            }
            try {
                return (String)ConverterSupport.getNumberRangeFormatter().parse(value);
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        @Nullable
        protected String notNull(@NotNull String value) {
            if (value == null) {
                NumberRangeToText.$$$reportNull$$$0(1);
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$NumberRangeToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UuidToText
    extends DataConverter<String, String> {
        protected UuidToText() {
            super(PointSet.UUID, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String reverseNotNull(@NotNull String value) {
            if (value == null) {
                UuidToText.$$$reportNull$$$0(0);
            }
            try {
                return UUID.fromString(value).toString();
            }
            catch (Exception exception) {
                return UUID.randomUUID().toString();
            }
        }

        @Override
        @Nullable
        protected String notNull(@NotNull String value) {
            if (value == null) {
                UuidToText.$$$reportNull$$$0(1);
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$UuidToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ObjectToText
    extends DataConverter<Object, String> {
        protected ObjectToText() {
            super(PointSet.UNKNOWN, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected Object reverseNotNull(@NotNull String value) {
            if (value == null) {
                ObjectToText.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        @Nullable
        protected String notNull(@NotNull Object value) {
            if (value == null) {
                ObjectToText.$$$reportNull$$$0(1);
            }
            return value instanceof ContextDescriptor ? ObjectToText.convertToString((ContextDescriptor)value) : null;
        }

        @Nullable
        private static String convertToString(@NotNull ContextDescriptor cd) {
            if (cd == null) {
                ObjectToText.$$$reportNull$$$0(2);
            }
            if (!(cd.myDescriptor instanceof DataConsumer.Column)) {
                return null;
            }
            ObjectFormatter formatter = new ObjectFormatter();
            return formatter.objectToString(cd.myValue, (DataConsumer.Column)cd.myDescriptor, cd.myDialect, false);
        }

        @NotNull
        public static Function<Object, Object> tweak(@NotNull Function<Object, Object> function, @NotNull ColumnDescriptor descriptor, @NotNull DatabaseDialect dialect) {
            if (function == null) {
                ObjectToText.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                ObjectToText.$$$reportNull$$$0(4);
            }
            if (dialect == null) {
                ObjectToText.$$$reportNull$$$0(5);
            }
            Function function2 = o -> {
                if (function == null) {
                    ObjectToText.$$$reportNull$$$0(7);
                }
                if (descriptor == null) {
                    ObjectToText.$$$reportNull$$$0(8);
                }
                if (dialect == null) {
                    ObjectToText.$$$reportNull$$$0(9);
                }
                return function.fun((Object)new ContextDescriptor(descriptor, dialect, o));
            };
            if (function2 == null) {
                ObjectToText.$$$reportNull$$$0(6);
            }
            return function2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cd";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/DataConverter$ObjectToText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/DataConverter$ObjectToText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tweak";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "notNull";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToString";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "tweak";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$tweak$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class ContextDescriptor {
            private final ColumnDescriptor myDescriptor;
            private final DatabaseDialect myDialect;
            private final Object myValue;

            private ContextDescriptor(@NotNull ColumnDescriptor descriptor, @NotNull DatabaseDialect dialect, Object value) {
                if (descriptor == null) {
                    ContextDescriptor.$$$reportNull$$$0(0);
                }
                if (dialect == null) {
                    ContextDescriptor.$$$reportNull$$$0(1);
                }
                this.myDescriptor = descriptor;
                this.myDialect = dialect;
                this.myValue = value;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "descriptor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dialect";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/data/types/DataConverter$ObjectToText$ContextDescriptor";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class TimeZonedTimestampToTemporal
    extends DataConverter<TimeZonedTimestamp, TemporalAccessor> {
        public TimeZonedTimestampToTemporal() {
            super(PointSet.TIMESTAMP_WITH_TIMEZONE, PointSet.TEMPORAL_TIMESTAMP);
        }

        @Override
        @Nullable
        protected TimeZonedTimestamp reverseNotNull(@NotNull TemporalAccessor value) {
            if (value == null) {
                TimeZonedTimestampToTemporal.$$$reportNull$$$0(0);
            }
            return new TimeZonedTimestamp(value instanceof OffsetDateTime ? (OffsetDateTime)value : ((LocalDateTime)value).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(DataGridFormattersUtil.getDefaultOffset()));
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull TimeZonedTimestamp value) {
            if (value == null) {
                TimeZonedTimestampToTemporal.$$$reportNull$$$0(1);
            }
            return value.getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TimeZonedTimestampToTemporal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimeZonedTimeToTemporal
    extends DataConverter<TimeZonedTime, TemporalAccessor> {
        public TimeZonedTimeToTemporal() {
            super(PointSet.TIME_WITH_TIMEZONE, PointSet.TEMPORAL_TIME);
        }

        @Override
        @Nullable
        protected TimeZonedTime reverseNotNull(@NotNull TemporalAccessor value) {
            if (value == null) {
                TimeZonedTimeToTemporal.$$$reportNull$$$0(0);
            }
            return new TimeZonedTime(value instanceof OffsetTime ? (OffsetTime)value : ((LocalTime)value).atOffset(DataGridFormattersUtil.getLocalTimeOffset()).withOffsetSameInstant(DataGridFormattersUtil.getDefaultOffset()));
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull TimeZonedTime value) {
            if (value == null) {
                TimeZonedTimeToTemporal.$$$reportNull$$$0(1);
            }
            return value.getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TimeZonedTimeToTemporal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TemporalTimeToTemporalTimestamp
    extends DataConverter<TemporalAccessor, TemporalAccessor> {
        public TemporalTimeToTemporalTimestamp() {
            super(PointSet.TEMPORAL_TIME, PointSet.TEMPORAL_TIMESTAMP);
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                TemporalTimeToTemporalTimestamp.$$$reportNull$$$0(0);
            }
            return data instanceof OffsetTime ? ((OffsetTime)data).atDate(DataGridFormattersUtil.START_DATE) : ((LocalTime)data).atOffset(DataGridFormattersUtil.getLocalTimeOffset()).atDate(DataGridFormattersUtil.START_DATE).atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        }

        @Override
        @Nullable
        protected TemporalAccessor reverseNotNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                TemporalTimeToTemporalTimestamp.$$$reportNull$$$0(1);
            }
            return data instanceof OffsetDateTime ? ((OffsetDateTime)data).toOffsetTime() : ((LocalDateTime)data).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(DataGridFormattersUtil.getLocalTimeOffset()).toLocalTime();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TemporalTimeToTemporalTimestamp";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimeToText
    extends DataConverter<TemporalAccessor, String> {
        public TimeToText() {
            super(PointSet.TEMPORAL_TIME, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                TimeToText.$$$reportNull$$$0(0);
            }
            return ConverterSupport.getTimeFormatter().format(data);
        }

        @Override
        @Nullable
        protected TemporalAccessor reverseNotNull(@NotNull String data) {
            if (data == null) {
                TimeToText.$$$reportNull$$$0(1);
            }
            try {
                return (TemporalAccessor)ConverterSupport.getTimeFormatter().parse(data);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TimeToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimeToNumber
    extends DataConverter<TemporalAccessor, Number> {
        public TimeToNumber() {
            super(PointSet.TEMPORAL_TIME, PointSet.NUMBER);
        }

        @Override
        @Nullable
        protected Number notNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                TimeToNumber.$$$reportNull$$$0(0);
            }
            LocalTime from = LocalTime.from(data);
            return Time.valueOf(from).getTime();
        }

        @Override
        @Nullable
        protected TemporalAccessor reverseNotNull(@NotNull Number data) {
            if (data == null) {
                TimeToNumber.$$$reportNull$$$0(1);
            }
            return new Time(data.longValue()).toLocalTime();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TimeToNumber";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimestampToText
    extends DataConverter<TemporalAccessor, String> {
        public TimestampToText() {
            super(PointSet.TEMPORAL_TIMESTAMP, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                TimestampToText.$$$reportNull$$$0(0);
            }
            return ConverterSupport.getTimestampFormatter().format(data);
        }

        @Override
        @Nullable
        protected TemporalAccessor reverseNotNull(@NotNull String data) {
            if (data == null) {
                TimestampToText.$$$reportNull$$$0(1);
            }
            try {
                return (TemporalAccessor)ConverterSupport.getTimestampFormatter().parse(data);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TimestampToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimestampToTemporal
    extends DataConverter<Timestamp, TemporalAccessor> {
        public TimestampToTemporal() {
            super(PointSet.TIMESTAMP, PointSet.TEMPORAL_TIMESTAMP);
        }

        @Override
        @Nullable
        protected Timestamp reverseNotNull(@NotNull TemporalAccessor value) {
            if (value == null) {
                TimestampToTemporal.$$$reportNull$$$0(0);
            }
            return value instanceof OffsetDateTime ? DataGridFormattersUtil.fromOffsetDateTime((OffsetDateTime)value) : Timestamp.valueOf((LocalDateTime)value);
        }

        @Override
        @Nullable
        public TemporalAccessor notNull(@NotNull Timestamp value) {
            if (value == null) {
                TimestampToTemporal.$$$reportNull$$$0(1);
            }
            return value.toLocalDateTime();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TimestampToTemporal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimeToTemporal
    extends DataConverter<Time, TemporalAccessor> {
        public TimeToTemporal() {
            super(PointSet.TIME, PointSet.TEMPORAL_TIME);
        }

        @Override
        @Nullable
        protected Time reverseNotNull(@NotNull TemporalAccessor value) {
            if (value == null) {
                TimeToTemporal.$$$reportNull$$$0(0);
            }
            return Time.valueOf(value instanceof OffsetTime ? ((OffsetTime)value).withOffsetSameInstant(DataGridFormattersUtil.getLocalTimeOffset()).toLocalTime() : (LocalTime)value);
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull Time value) {
            if (value == null) {
                TimeToTemporal.$$$reportNull$$$0(1);
            }
            return value.toLocalTime();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$TimeToTemporal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NumberToTimestamp
    extends DataConverter<Number, TemporalAccessor> {
        public NumberToTimestamp() {
            super(PointSet.NUMBER, PointSet.TEMPORAL_TIMESTAMP);
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull Number data) {
            if (data == null) {
                NumberToTimestamp.$$$reportNull$$$0(0);
            }
            long l = data.longValue();
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(l), ZoneId.systemDefault());
        }

        @Override
        @Nullable
        protected Number reverseNotNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                NumberToTimestamp.$$$reportNull$$$0(1);
            }
            return data instanceof LocalDateTime ? Timestamp.valueOf((LocalDateTime)data).getTime() : Timestamp.valueOf(((OffsetDateTime)data).toLocalDateTime()).getTime();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$NumberToTimestamp";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MoneyToText
    extends DataConverter<Number, String> {
        private static final NumberFormat FORMAT = NumberFormat.getNumberInstance(Locale.US);

        public MoneyToText() {
            super(PointSet.MONEY, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected Number reverseNotNull(@NotNull String value) {
            if (value == null) {
                MoneyToText.$$$reportNull$$$0(0);
            }
            if (value.length() == 0) {
                return null;
            }
            try {
                return FORMAT.parse(value);
            }
            catch (Exception exception) {
                return MoneyToText.parseCurrency(value);
            }
        }

        @Override
        @Nullable
        protected String notNull(@NotNull Number value) {
            if (value == null) {
                MoneyToText.$$$reportNull$$$0(1);
            }
            return value.toString();
        }

        @Nullable
        private static Number parseCurrency(@NotNull String value) {
            if (value == null) {
                MoneyToText.$$$reportNull$$$0(2);
            }
            try {
                return FORMAT.parse(value.substring(1));
            }
            catch (Exception exception) {
                return null;
            }
        }

        static {
            if (FORMAT instanceof DecimalFormat) {
                ((DecimalFormat)FORMAT).setParseBigDecimal(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$MoneyToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseCurrency";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NumberToText
    extends DataConverter<Number, String> {
        public NumberToText() {
            super(PointSet.NUMBER, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull Number data) {
            if (data == null) {
                NumberToText.$$$reportNull$$$0(0);
            }
            return data.toString();
        }

        @Override
        @Nullable
        protected Number reverseNotNull(@NotNull String data) {
            if (data == null) {
                NumberToText.$$$reportNull$$$0(1);
            }
            try {
                return Long.parseLong(data);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.parseDouble(data);
                }
                catch (NumberFormatException numberFormatException2) {
                    return null;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$NumberToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DateToTimestamp
    extends DataConverter<java.util.Date, TemporalAccessor> {
        public DateToTimestamp() {
            super(PointSet.DATE, PointSet.TEMPORAL_TIMESTAMP);
        }

        @Override
        @Nullable
        protected java.util.Date reverseNotNull(@NotNull TemporalAccessor data) {
            if (data == null) {
                DateToTimestamp.$$$reportNull$$$0(0);
            }
            return Date.valueOf(LocalDate.from(data));
        }

        @Override
        @Nullable
        protected TemporalAccessor notNull(@NotNull java.util.Date data) {
            if (data == null) {
                DateToTimestamp.$$$reportNull$$$0(1);
            }
            return data instanceof Date ? ((Date)data).toLocalDate().atStartOfDay().atOffset(ZoneOffset.UTC).atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime() : LocalDateTime.ofInstant(Instant.ofEpochMilli(data.getTime()), ZoneId.systemDefault());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$DateToTimestamp";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DateToText
    extends DataConverter<java.util.Date, String> {
        public DateToText() {
            super(PointSet.DATE, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull java.util.Date data) {
            if (data == null) {
                DateToText.$$$reportNull$$$0(0);
            }
            return ConverterSupport.getDateFormatter().format(data);
        }

        @Override
        @Nullable
        protected java.util.Date reverseNotNull(@NotNull String data) {
            if (data == null) {
                DateToText.$$$reportNull$$$0(1);
            }
            try {
                return (java.util.Date)ConverterSupport.getDateFormatter().parse(data);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$DateToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DateToNumber
    extends DataConverter<java.util.Date, Number> {
        public DateToNumber() {
            super(PointSet.DATE, PointSet.NUMBER);
        }

        @Override
        @Nullable
        protected Number notNull(@NotNull java.util.Date data) {
            if (data == null) {
                DateToNumber.$$$reportNull$$$0(0);
            }
            return data.getTime();
        }

        @Override
        @Nullable
        protected java.util.Date reverseNotNull(@NotNull Number data) {
            if (data == null) {
                DateToNumber.$$$reportNull$$$0(1);
            }
            return new java.util.Date(data.longValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$DateToNumber";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BooleanToText
    extends DataConverter<Boolean, String> {
        public BooleanToText() {
            super(PointSet.BOOLEAN, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull Boolean data) {
            if (data == null) {
                BooleanToText.$$$reportNull$$$0(0);
            }
            return String.valueOf(data);
        }

        @Override
        @Nullable
        protected Boolean reverseNotNull(@NotNull String data) {
            if (data == null) {
                BooleanToText.$$$reportNull$$$0(1);
            }
            return StringUtil.findIgnoreCase((String)data, (String[])new String[]{"yes", "true", "1"});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$BooleanToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BooleanToNumber
    extends DataConverter<Boolean, Number> {
        public BooleanToNumber() {
            super(PointSet.BOOLEAN, PointSet.NUMBER);
        }

        @Override
        @Nullable
        protected Number notNull(@NotNull Boolean data) {
            if (data == null) {
                BooleanToNumber.$$$reportNull$$$0(0);
            }
            return data != false ? 1 : 0;
        }

        @Override
        @Nullable
        protected Boolean reverseNotNull(@NotNull Number data) {
            if (data == null) {
                BooleanToNumber.$$$reportNull$$$0(1);
            }
            return Double.compare(data.doubleValue(), 1.0) >= 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$BooleanToNumber";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BooleanToBinary
    extends DataConverter<Boolean, byte[]> {
        public BooleanToBinary() {
            super(PointSet.BOOLEAN, PointSet.BINARY);
        }

        @Override
        @Nullable
        protected byte[] notNull(@NotNull Boolean data) {
            if (data == null) {
                BooleanToBinary.$$$reportNull$$$0(0);
            }
            return new byte[]{data != false ? (byte)1 : 0};
        }

        @Override
        @Nullable
        protected Boolean reverseNotNull(@NotNull byte[] bytes) {
            if (bytes == null) {
                BooleanToBinary.$$$reportNull$$$0(1);
            }
            return bytes[0] == 0 ? Boolean.FALSE : Boolean.TRUE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bytes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$BooleanToBinary";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BinaryToText
    extends DataConverter<byte[], String> {
        public BinaryToText() {
            super(PointSet.BINARY, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String notNull(@NotNull byte[] data) {
            ObjectFormatter.TextInfo info;
            if (data == null) {
                BinaryToText.$$$reportNull$$$0(0);
            }
            return (info = ObjectFormatter.tryDetectString(data)) == null ? StringUtil.toHexString((byte[])data) : info.text;
        }

        @Override
        @Nullable
        protected byte[] reverseNotNull(@NotNull String data) {
            if (data == null) {
                BinaryToText.$$$reportNull$$$0(1);
            }
            return data.getBytes(StandardCharsets.UTF_8);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "data";
            objectArray2[1] = "com/intellij/database/data/types/DataConverter$BinaryToText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reverseNotNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BinaryTextToText
    extends DataConverter<String, String> {
        public BinaryTextToText() {
            super(PointSet.BINARY_STRING, PointSet.TEXT);
        }

        @Override
        @Nullable
        protected String reverseNotNull(@NotNull String text2) {
            byte[] bytes;
            if (text2 == null) {
                BinaryTextToText.$$$reportNull$$$0(0);
            }
            StringBuilder sb = new StringBuilder();
            byte[] byArray = bytes = text2.getBytes(StandardCharsets.UTF_8);
            int n = byArray.length;
            for (int j = 0; j < n; ++j) {
                int aByte;
                int intValue = aByte = byArray[j];
                for (int i2 = 0; i2 < 8; ++i2) {
                    sb.append((intValue & 0x80) == 0 ? 0 : 1);
                    intValue <<= 1;
                }
            }
            return sb.toString();
        }

        @Override
        @Nullable
        protected String notNull(@NotNull String value) {
            List<String> strings;
            if (value == null) {
                BinaryTextToText.$$$reportNull$$$0(1);
            }
            if ((strings = BinaryTextToText.split(value)).isEmpty()) {
                return value;
            }
            try {
                StringBuilder sb = new StringBuilder();
                for (String string : strings) {
                    sb.append((char)Integer.parseInt(string, 2));
                }
                return sb.toString();
            }
            catch (Exception exception) {
                return value;
            }
        }

        @NotNull
        private static List<String> split(@NotNull String s) {
            if (s == null) {
                BinaryTextToText.$$$reportNull$$$0(2);
            }
            ArrayList strings = ContainerUtil.newArrayList();
            for (int currentIdx = 0; currentIdx < s.length(); currentIdx += 8) {
                String substring = s.substring(currentIdx, Math.min(s.length(), currentIdx + 8));
                strings.add(substring);
            }
            ArrayList arrayList = strings;
            if (arrayList == null) {
                BinaryTextToText.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/DataConverter$BinaryTextToText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/DataConverter$BinaryTextToText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "split";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "reverseNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "notNull";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "split";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

