/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationRequest;
import com.intellij.database.console.evaluation.JdbcConsoleEvaluationSupport;
import com.intellij.database.console.evaluation.OwnerBasedEvaluationRequestor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBetweenExpression;
import com.intellij.sql.psi.SqlCaseExpression;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiRequestor
extends OwnerBasedEvaluationRequestor {
    private static final List<Class<? extends SqlExpression>> UNSUPPORTED_EXPRESSIONS = ContainerUtil.list((Object[])new Class[]{SqlTableExpression.class, SqlBetweenExpression.class, SqlCaseExpression.class, SqlReferenceExpression.class, SqlJoinExpression.class, SqlTableColumnsList.class});
    private final JdbcConsole myConsole;
    private final SqlElement myElement;

    protected PsiRequestor(@Nullable JdbcConsole console, @NotNull SqlElement expression, @NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource source) {
        if (expression == null) {
            PsiRequestor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PsiRequestor.$$$reportNull$$$0(1);
        }
        if (dialect == null) {
            PsiRequestor.$$$reportNull$$$0(2);
        }
        if (source == null) {
            PsiRequestor.$$$reportNull$$$0(3);
        }
        super(project, dialect, source);
        this.myConsole = console;
        this.myElement = expression;
    }

    @Override
    @Nullable
    public EvaluationRequest createRequest(@NotNull DataRequest.OwnerEx owner, @NotNull CompletableFuture<DatabaseExpressionEvaluator.Result> future) {
        if (owner == null) {
            PsiRequestor.$$$reportNull$$$0(4);
        }
        if (future == null) {
            PsiRequestor.$$$reportNull$$$0(5);
        }
        return new EvaluationRequest(owner, this.myProject, this.myDialect, future, this.getQuery(), this.mySource);
    }

    @Override
    @NotNull
    public String getQuery() {
        String string = PsiRequestor.getQuery(this.myConsole, this.myElement, this.mySource);
        if (string == null) {
            PsiRequestor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getQuery(@Nullable JdbcConsole console, @NotNull SqlElement element, @NotNull DbDataSource source) {
        if (element == null) {
            PsiRequestor.$$$reportNull$$$0(7);
        }
        if (source == null) {
            PsiRequestor.$$$reportNull$$$0(8);
        }
        String string = PsiRequestor.getQuery(console, element, DatabaseFamilyId.forDataSource((DatabaseSystem)source));
        if (string == null) {
            PsiRequestor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getQuery(@Nullable JdbcConsole console, @NotNull SqlElement element, @NotNull DatabaseFamilyId id) {
        if (element == null) {
            PsiRequestor.$$$reportNull$$$0(10);
        }
        if (id == null) {
            PsiRequestor.$$$reportNull$$$0(11);
        }
        String string = (String)PsiRequestor.traverse(element, e -> {
            if (id == null) {
                PsiRequestor.$$$reportNull$$$0(30);
            }
            return e instanceof SqlExpression && PsiRequestor.isSufficientExpression((SqlExpression)e) ? PsiRequestor.getText(console, e) : PsiRequestor.createSelectStatement(id, PsiRequestor.getText(console, e));
        });
        if (string == null) {
            PsiRequestor.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public static SqlExpression getExpression(@NotNull EditorEx editor, @NotNull Project project, @NotNull JdbcConsoleEvaluationSupport.PositionInfo position) {
        VirtualFile file;
        if (editor == null) {
            PsiRequestor.$$$reportNull$$$0(13);
        }
        if (project == null) {
            PsiRequestor.$$$reportNull$$$0(14);
        }
        if (position == null) {
            PsiRequestor.$$$reportNull$$$0(15);
        }
        if ((file = editor.getVirtualFile()) == null) {
            return null;
        }
        PsiFile psiFile = PsiUtilCore.getPsiFile((Project)project, (VirtualFile)file);
        int start = position.offset;
        return position.range != null ? PsiRequestor.getSelectedExpression(position.range, psiFile) : PsiRequestor.getExpressionAtCaret(psiFile, start);
    }

    @Override
    public boolean isEmpty() {
        return !(this.myElement instanceof SqlExpression);
    }

    public static boolean isUnsupportedExpression(@Nullable SqlExpression expression) {
        return expression == null || (Boolean)PsiRequestor.traverse((SqlElement)expression, e -> e == null || ContainerUtil.exists(UNSUPPORTED_EXPRESSIONS, c -> c.isInstance(e))) != false;
    }

    @Nullable
    private static SqlExpression getSelectedExpression(@NotNull TextRange range, @NotNull PsiFile psiFile) {
        int end;
        int start;
        SqlExpression expression;
        if (range == null) {
            PsiRequestor.$$$reportNull$$$0(16);
        }
        if (psiFile == null) {
            PsiRequestor.$$$reportNull$$$0(17);
        }
        return PsiRequestor.isUnsupportedExpression(expression = (SqlExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)psiFile, (int)(start = range.getStartOffset()), (int)(end = range.getEndOffset()), SqlExpression.class)) ? PsiRequestor.getAsExpression(range, psiFile) : expression;
    }

    @Nullable
    private static SqlExpression getAsExpression(@NotNull TextRange range, @NotNull PsiFile psiFile) {
        int end;
        int start;
        SqlIdentifier identifier;
        SqlAsExpression asExpression;
        if (range == null) {
            PsiRequestor.$$$reportNull$$$0(18);
        }
        if (psiFile == null) {
            PsiRequestor.$$$reportNull$$$0(19);
        }
        return PsiRequestor.isUnsupportedExpression((SqlExpression)(asExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)(identifier = (SqlIdentifier)PsiTreeUtil.findElementOfClassAtRange((PsiFile)psiFile, (int)(start = range.getStartOffset()), (int)(end = range.getEndOffset()), SqlIdentifier.class)), SqlAsExpression.class))) ? null : asExpression;
    }

    @Nullable
    private static SqlExpression getExpressionAtCaret(@NotNull PsiFile file, int offset) {
        if (file == null) {
            PsiRequestor.$$$reportNull$$$0(20);
        }
        PsiElement element = file.findElementAt(offset);
        SqlExpression expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlExpression.class, (boolean)false);
        while (expression != null && PsiRequestor.isUnsupportedExpression(expression)) {
            expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlExpression.class);
        }
        return expression;
    }

    private static boolean isParenthesized(@NotNull SqlElement element) {
        if (element == null) {
            PsiRequestor.$$$reportNull$$$0(21);
        }
        PsiElement[] children = element.getChildren();
        return element instanceof SqlParenthesizedExpression && children.length == 1 && children[0] instanceof SqlElement;
    }

    public static boolean isSufficientExpression(@Nullable SqlExpression expression) {
        return expression instanceof SqlResultSetExpression;
    }

    @NotNull
    public static String createSelectStatement(@NotNull DatabaseFamilyId id, @NotNull String expression) {
        if (id == null) {
            PsiRequestor.$$$reportNull$$$0(22);
        }
        if (expression == null) {
            PsiRequestor.$$$reportNull$$$0(23);
        }
        String string = SelectStatementBuildingRule.of(id).apply(expression);
        if (string == null) {
            PsiRequestor.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static String getText(@Nullable JdbcConsole console, @NotNull SqlElement element) {
        if (element == null) {
            PsiRequestor.$$$reportNull$$$0(25);
        }
        String string = StringUtil.convertLineSeparators((String)StringUtil.notNullize((String)(console == null ? null : JdbcConsole.getQueryText(console, element.getTextRange())), (String)element.getText()));
        if (string == null) {
            PsiRequestor.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private static <T> T traverse(@NotNull SqlElement element, @NotNull Function<SqlElement, T> function) {
        if (element == null) {
            PsiRequestor.$$$reportNull$$$0(27);
        }
        if (function == null) {
            PsiRequestor.$$$reportNull$$$0(28);
        }
        Object object = element instanceof SqlAsExpression ? PsiRequestor.traverse((SqlElement)((SqlAsExpression)element).getExpression(), function) : (PsiRequestor.isParenthesized(element) ? PsiRequestor.traverse((SqlElement)element.getChildren()[0], function) : function.fun((Object)element));
        if (object == null) {
            PsiRequestor.$$$reportNull$$$0(29);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 24: 
            case 26: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 24: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 24: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/evaluation/PsiRequestor";
                break;
            }
            case 7: 
            case 10: 
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/evaluation/PsiRequestor";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuery";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectStatement";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "traverse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 24: 
            case 26: 
            case 29: {
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQuery";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExpression";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedExpression";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAsExpression";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionAtCaret";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isParenthesized";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createSelectStatement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getQuery$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 24: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum SelectStatementBuildingRule {
        VALUES(new Processor[]{DatabaseFamilyId::isDb2, DatabaseFamilyId::isDerby, DatabaseFamilyId::isHsqldb}){

            @Override
            @NotNull
            String apply(@NotNull String expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = "VALUES " + expression;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "apply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "apply";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        ,
        SELECT_FROM_DUAL(new Processor[]{DatabaseFamilyId::isOracle}){

            @Override
            @NotNull
            String apply(@NotNull String expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(0);
                }
                String string = "SELECT " + expression + " FROM dual";
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "apply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "apply";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        ,
        SELECT(new Processor[]{id -> true}){

            @Override
            @NotNull
            String apply(@NotNull String expression) {
                if (expression == null) {
                    3.$$$reportNull$$$0(0);
                }
                String string = "SELECT " + expression;
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "apply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "apply";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        private final Processor<DatabaseFamilyId>[] myProcessors;

        private SelectStatementBuildingRule(Processor<DatabaseFamilyId> ... processors) {
            if (processors == null) {
                SelectStatementBuildingRule.$$$reportNull$$$0(0);
            }
            this.myProcessors = processors;
        }

        boolean canApply(@NotNull DatabaseFamilyId id) {
            if (id == null) {
                SelectStatementBuildingRule.$$$reportNull$$$0(1);
            }
            for (Processor<DatabaseFamilyId> processor : this.myProcessors) {
                if (!processor.process((Object)id)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        abstract String apply(@NotNull String var1);

        @NotNull
        static SelectStatementBuildingRule of(@NotNull DatabaseFamilyId id) {
            if (id == null) {
                SelectStatementBuildingRule.$$$reportNull$$$0(2);
            }
            for (SelectStatementBuildingRule rule : SelectStatementBuildingRule.values()) {
                if (!rule.canApply(id)) continue;
                SelectStatementBuildingRule selectStatementBuildingRule = rule;
                if (selectStatementBuildingRule == null) {
                    SelectStatementBuildingRule.$$$reportNull$$$0(3);
                }
                return selectStatementBuildingRule;
            }
            throw new IllegalArgumentException("Can't find rule for family: " + id.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processors";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canApply";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

