/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.DataBus;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.console.AbstractEngine;
import com.intellij.database.console.DatabaseAccessController;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.SuppressUserStackTrace;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.QueryData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.datagrid.mutating.RowUpdateData;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.jdbc.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.MeasuringDataAuditor;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.actions.TransactionAction;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.Alarm;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class JdbcEngine
extends AbstractEngine
implements DataProducer {
    public static final Key<Boolean> SUPPORTS_SAVEPOINTS_KEY = Key.create((String)"SUPPORTS_SAVEPOINTS");
    private static final Logger LOG = Logger.getInstance(JdbcEngine.class);
    private static final TObjectHashingStrategy<RowQueryData> QUERY_DATA_HASHING_STRATEGY = new TObjectHashingStrategy<RowQueryData>(){

        public int computeHashCode(RowQueryData object) {
            return Comparing.hashcode(object.getColumnsData());
        }

        public boolean equals(RowQueryData o1, RowQueryData o2) {
            return Comparing.equal(o1.getColumnsData(), o2.getColumnsData());
        }
    };
    private static final Map<JdbcEngine, Statement> ourPendingStatements = ConcurrentCollectionFactory.createMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
    private static final SingleAlarm ourPendingStatementsAlarm = new SingleAlarm(JdbcEngine::printAllWarnings, 1000, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
    private final DatabaseAccessController myDatabaseAccessController;
    private final JdbcDriverManager myDriverManager;
    private final LocalDataSource myDataSource;
    private final ThrowableComputable<GuardedRef<DatabaseConnection>, Exception> myConnectionFactory;
    private volatile GuardedRef<DatabaseConnection> myConnection;
    private DataRequest.TxMarker myTxMarker;
    private ConsoleRunConfiguration myConfiguration;
    private final AtomicReference<State> myState;
    private boolean mySupportsSavepoints;
    private volatile SearchPath mySearchPath;
    private DatabaseDialectEx myDialect;
    private DatabaseFamilyId myFamilyId;

    public JdbcEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus, @NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        if (project == null) {
            JdbcEngine.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            JdbcEngine.$$$reportNull$$$0(1);
        }
        if (dataSource == null) {
            JdbcEngine.$$$reportNull$$$0(2);
        }
        this(project, messageBus, dataSource, configuration, dataSource.isAutoCommit());
    }

    public JdbcEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus, @NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration, boolean autoCommit) {
        if (project == null) {
            JdbcEngine.$$$reportNull$$$0(3);
        }
        if (messageBus == null) {
            JdbcEngine.$$$reportNull$$$0(4);
        }
        if (dataSource == null) {
            JdbcEngine.$$$reportNull$$$0(5);
        }
        super(project, messageBus);
        this.myState = new AtomicReference<State>(State.IDLE);
        this.myDataSource = dataSource;
        this.myDriverManager = JdbcDriverManager.getDriverManager(project);
        this.myConfiguration = configuration;
        this.myConnectionFactory = configuration == null ? () -> {
            this.myConfiguration = this.myDriverManager.getDefaultRunConfiguration(this.myDataSource);
            return this.createConnection();
        } : this::createConnection;
        this.myTxMarker = DataRequest.getInitialTxMarker(autoCommit);
        this.myDatabaseAccessController = this.createAccessController();
    }

    @NotNull
    private DatabaseAccessController createAccessController() {
        DbDataSource source = DbImplUtil.getDbDataSource(this.getProject(), this.myDataSource);
        DatabaseAccessController databaseAccessController = source == null ? q -> DatabaseAccessController.Token.success() : new DatabaseAccessController.PsiBased(this.getProject(), DbSqlUtil.getSqlDialect(this.myDataSource), source, () -> this.mySearchPath);
        if (databaseAccessController == null) {
            JdbcEngine.$$$reportNull$$$0(6);
        }
        return databaseAccessController;
    }

    @Nullable
    private GuardedRef<DatabaseConnection> createConnection() throws SQLException {
        ObjectPath currentNamespace = this.getCurrentNamespace();
        GuardedRef<DatabaseConnection> connection = DatabaseConnectionManager.getInstance().build(this.getProject(), this.myDataSource).setRunConfiguration(this.myConfiguration).setDestination(currentNamespace).create();
        if (connection != null) {
            String dest = "";
            if (connection.get().getConnectionPoint() != this.myDataSource) {
                String bounded;
                DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
                DatabaseDriver.Bounds bounds = driver == null ? null : driver.getConnectionBounds();
                String string = bounded = bounds != null ? JdbcUrlParserUtil.getObjectItem(currentNamespace, bounds.boundTo) : null;
                if (StringUtil.isNotEmpty((String)bounded)) {
                    dest = " to " + bounded;
                }
            }
            this.getDataAuditor().print(this.getRequestContext(), "Connected" + dest);
        }
        return connection;
    }

    @Nullable
    public DatabaseConnection getCurrentConnection() {
        return this.myConnection == null ? null : this.myConnection.get();
    }

    @Nullable
    public DatabaseConnection getConnection() throws Exception {
        return this.getConnection(true);
    }

    @Nullable
    private SearchPath getSearchPath() {
        return this.mySearchPath;
    }

    private void requestSearchPath(@NotNull DatabaseConnection connection) {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(7);
        }
        try {
            this.setSearchPath(this.myDialect.tryToLoadSearchPath(this.myDataSource, connection));
        }
        catch (Exception e) {
            LOG.warn(JdbcEngine.getErrorMessage(e, this.myDataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource)));
        }
    }

    private void requestSearchPathTransparent(@NotNull DatabaseConnection connection) throws Exception {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(8);
        }
        new PotentiallyTransparentOperation(this.isTransactionStarted()){

            @Override
            boolean transparent(@NotNull DatabaseConnection connection) {
                if (connection == null) {
                    2.$$$reportNull$$$0(0);
                }
                JdbcEngine.this.requestSearchPath(connection);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$2", "transparent"));
            }
        }.perform(connection);
    }

    private void setSearchPath(@Nullable SearchPath searchPath) {
        this.mySearchPath = searchPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DatabaseConnection getConnection(boolean setCurrentSchema) throws Exception {
        DatabaseConnection connection = this.getCurrentConnection();
        boolean freshConnection = false;
        if (!this.isConnectionReady(connection)) {
            ThrowableComputable<GuardedRef<DatabaseConnection>, Exception> throwableComputable = this.myConnectionFactory;
            synchronized (throwableComputable) {
                GuardedRef ref;
                this.releaseConnection();
                this.myConnection = ref = (GuardedRef)this.myConnectionFactory.compute();
                connection = ref == null ? null : (DatabaseConnection)ref.get();
                freshConnection = true;
            }
            this.myFamilyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource);
            this.myDialect = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(this.myFamilyId), (Object)GenericDialect.INSTANCE);
        }
        if (!this.isConnectionReady(connection)) {
            this.releaseConnection();
            this.myConnection = null;
            connection = null;
        }
        if (connection == null) {
            this.getDataAuditor().error(this.getRequestContext(), "Connection failed", null);
        } else {
            this.prepareConnection(connection, setCurrentSchema && freshConnection);
        }
        return connection;
    }

    @Override
    public boolean cancelPendingRequests() {
        super.cancelPendingRequests();
        DataRequest.Context context = this.getRequestContextIfAny();
        if (context == null) {
            return false;
        }
        if (this.myState.compareAndSet(State.STREAMING, State.CANCELED)) {
            this.getDataAuditor().print(context, "Cancelling...");
            return true;
        }
        if (this.myState.compareAndSet(State.RUNNING, State.CANCELED)) {
            Statement statement = ourPendingStatements.get(this);
            if (statement == null) {
                return true;
            }
            AppExecutorUtil.getAppExecutorService().submit(() -> {
                if (this.getRequestContextIfAny() == context) {
                    TimeoutUtil.sleep((long)500L);
                    if (this.getRequestContextIfAny() == context) {
                        this.getDataAuditor().print(context, "Cancelling...");
                        try {
                            statement.cancel();
                        }
                        catch (Throwable ex) {
                            context.reportException(ex, null);
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }

    public LocalDataSource getDataSource() {
        return this.myDataSource;
    }

    public boolean isStarted() {
        return this.myDriverManager.getActiveConfigurations(this.myDataSource).contains((Object)this.myConfiguration);
    }

    @Override
    public void terminate() {
        super.terminate();
        GuardedRef<DatabaseConnection> connection = this.myConnection;
        ConsoleRunConfiguration configuration = this.myConfiguration;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (connection != null) {
                connection.close();
            }
            this.myDriverManager.releaseDriver(this.myDataSource, configuration);
        });
        this.myConnection = null;
    }

    @Override
    public void visitQuery(@NotNull DataRequest.QueryRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(9);
        }
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            StatementHolder<?> holder;
            if (r == null) {
                JdbcEngine.$$$reportNull$$$0(97);
            }
            if ((holder = this.createStatementHolder(r)) == null) {
                return false;
            }
            DatabaseConnection connection = this.getConnection();
            return connection != null && new QueryExecutionOperation(holder, r).perform(connection);
        }));
    }

    @Override
    public void visitUpdate(@NotNull DataRequest.UpdateRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(10);
        }
        this.executeUpdateStatement(r, ContainerUtil.list((Object[])new QueryData[]{this.buildDataForUpdate(r)}));
    }

    @Override
    public void visitInsert(@NotNull DataRequest.InsertRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(11);
        }
        this.executeUpdateStatement(r, ContainerUtil.list((Object[])new QueryData[]{this.buildDataForInsert(r)}));
    }

    @Override
    public void visitDelete(@NotNull DataRequest.DeleteRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(12);
        }
        this.executeUpdateStatement(r, ContainerUtil.list((Object[])new QueryData[]{this.buildDataForDelete(r)}));
    }

    @Override
    public void visitComposite(DataRequest.CompositeRequest r) {
        final ArrayList infos = ContainerUtil.newArrayList();
        for (DataRequest.DmlRequest request : r.requests) {
            request.accept(new DataRequest.Visitor(){

                @Override
                public void visitInsert(DataRequest.InsertRequest r) {
                    infos.add(JdbcEngine.this.buildDataForInsert(r));
                }

                @Override
                public void visitUpdate(DataRequest.UpdateRequest r) {
                    infos.add(JdbcEngine.this.buildDataForUpdate(r));
                }

                @Override
                public void visitDelete(DataRequest.DeleteRequest r) {
                    infos.add(JdbcEngine.this.buildDataForDelete(r));
                }
            });
        }
        this.executeUpdateStatement(r, infos);
    }

    @Override
    public void visitTx(DataRequest.TxRequest r) {
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            if (this.myTxMarker.getOwner() == null || this.getCurrentConnection() == null) {
                this.suppressAudit();
                return true;
            }
            DatabaseConnection connection = this.getConnection();
            if (connection == null || !this.isConnectionReady(connection)) {
                this.suppressAudit();
                return false;
            }
            boolean autoCommit = connection.getAutoCommit();
            try {
                if (!autoCommit && this.myTxMarker.getOwner() != null) {
                    if (r.command == DataRequest.TxCommand.COMMIT) {
                        connection.commit();
                    } else {
                        connection.rollback();
                    }
                    this.getDataAuditor().txCompleted(this.getRequestContext(), r.command == DataRequest.TxCommand.COMMIT);
                    this.suppressAudit();
                }
            }
            finally {
                this.myTxMarker = DataRequest.NONE;
                this.printWarnings(connection);
            }
            return true;
        }));
    }

    @Override
    public void visitSchemaSwitch(@NotNull DataRequest.SchemaSwitchRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(13);
        }
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            DatabaseConnection connection;
            if (r == null) {
                JdbcEngine.$$$reportNull$$$0(96);
            }
            DatabaseConnection prevConnection = connection = this.getCurrentConnection();
            boolean reconnect = this.willReconnect(r.pathToSwitch.getCurrent());
            if (!r.forced && reconnect && connection != null) {
                this.suppressAudit();
                return Boolean.FALSE;
            }
            if (reconnect && connection != null) {
                this.releaseConnection();
            }
            if (connection == null && !r.forced) {
                this.setSearchPath(r.pathToSwitch);
                this.suppressAudit();
                return Boolean.TRUE;
            }
            if (reconnect) {
                this.setSearchPath(r.pathToSwitch);
                connection = this.getConnection(true);
                return connection != null;
            }
            connection = this.getConnection(false);
            return connection != null && this.performSchemaSwitch(connection, r.pathToSwitch, r, prevConnection == connection);
        }));
    }

    @Override
    public void visitRaw(DataRequest.RawRequest r) {
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            DatabaseConnection connection = this.getConnection();
            if (connection == null) {
                return false;
            }
            try {
                r.processRaw(this.getRequestContext(), connection);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable ex) {
                this.getRequestContext().reportException(ex, null);
            }
            finally {
                this.printWarnings(connection);
            }
            return true;
        }));
    }

    @Override
    @NotNull
    protected DataRequest.Context createRequestContext(@NotNull DataRequest request) {
        boolean ownerFailed;
        if (request == null) {
            JdbcEngine.$$$reportNull$$$0(14);
        }
        boolean startedTransaction = false;
        if (!this.isConnectionReady(this.getCurrentConnection()) || this.myTxMarker == DataRequest.NONE) {
            this.myTxMarker = DataRequest.getInitialTxMarker(this.myTxMarker == DataRequest.AUTO_COMMIT || this.myTxMarker == DataRequest.NONE);
        }
        boolean bl = ownerFailed = this.myTxMarker.getOwner() != null && this.myTxMarker != request.txMarker;
        if (!(ownerFailed || request instanceof DataRequest.TxRequest || request.txMarker != DataRequest.START_NEW && this.myTxMarker != DataRequest.START_NEW)) {
            startedTransaction = true;
            this.myTxMarker = DataRequest.newTxMarker("@" + request.owner.getDisplayName(), request.owner);
            final DataRequest.TxMarker marker = this.myTxMarker;
            if (marker.getOwner() instanceof Disposable) {
                Disposer.register((Disposable)((Disposable)request.owner), (Disposable)new Disposable(){

                    public void dispose() {
                        if (JdbcEngine.this.isDisposed()) {
                            return;
                        }
                        JdbcEngine.this.processRequest(DataRequest.newTxRollback(marker));
                    }
                });
            }
        }
        MyContext context = new MyContext(this, request, this.mySearchPath, startedTransaction);
        if (ownerFailed) {
            JdbcEngine.reportError(context, "locked by transaction: " + this.myTxMarker);
        }
        context.putUserData(SUPPORTS_SAVEPOINTS_KEY, this.mySupportsSavepoints);
        MyContext myContext = context;
        if (myContext == null) {
            JdbcEngine.$$$reportNull$$$0(15);
        }
        return myContext;
    }

    private static void reportError(@NotNull DataRequest.Context context, @NotNull String message) {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(16);
        }
        if (message == null) {
            JdbcEngine.$$$reportNull$$$0(17);
        }
        ExecutionException th = new ExecutionException(message);
        context.reportException(th, null);
        throw new ProcessCanceledException((Throwable)th);
    }

    @Nullable
    private Object getQueryType(@NotNull String queryText, @NotNull DataRequest.QueryRequest r) {
        if (queryText == null) {
            JdbcEngine.$$$reportNull$$$0(18);
        }
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(19);
        }
        try {
            if (r instanceof ConsoleDataRequest) {
                return ((ConsoleDataRequest)r).resultType;
            }
            LocalDataSource dataSource = this.getDataSource();
            return DbSqlUtil.parseQueryType(this.getProject(), DbSqlUtil.getSqlDialect(dataSource), DbSqlUtil.getDbDataSource(this.getProject(), dataSource), this.getSearchPath(), queryText, null);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private static boolean willScrollResultSet(DataRequest.Constraints constraints) {
        return constraints.offset != 0 && constraints.offset != 1;
    }

    @Nullable
    public ObjectPath getCurrentNamespace() {
        return SearchPath.getCurrent((SearchPath)this.mySearchPath);
    }

    private void configurePreFetchSize(Statement statement, int chunkSize) {
        try {
            if (this.myFamilyId.isMysql()) {
                statement.setFetchSize(Integer.MIN_VALUE);
            } else {
                statement.setFetchSize(chunkSize);
            }
        }
        catch (SQLException e) {
            LOG.warn((Throwable)e);
        }
    }

    public static int getUpdateCountSafe(@NotNull Statement statement) {
        if (statement == null) {
            JdbcEngine.$$$reportNull$$$0(20);
        }
        try {
            return statement.getUpdateCount();
        }
        catch (Exception ignored) {
            return -1;
        }
    }

    private void printWarnings(@Nullable DatabaseConnection connection) {
        if (connection == null) {
            return;
        }
        this.printWarnings((ThrowableComputable<List<SQLWarning>, Throwable>)((ThrowableComputable)() -> ((RemoteConnection)RemoteUtil.castToRemoteNotNull((Object)connection.getJdbcConnection(), RemoteConnection.class)).getAllWarnings()));
    }

    private void printWarnings(@Nullable Statement statement) {
        if (statement == null) {
            return;
        }
        this.printWarnings((ThrowableComputable<List<SQLWarning>, Throwable>)((ThrowableComputable)() -> ((RemoteStatement)RemoteUtil.castToRemoteNotNull((Object)statement, RemoteStatement.class)).getAllWarnings()));
    }

    private void printWarnings(@Nullable ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        this.printWarnings((ThrowableComputable<List<SQLWarning>, Throwable>)((ThrowableComputable)() -> ((RemoteResultSet)RemoteUtil.castToRemoteNotNull((Object)resultSet, RemoteResultSet.class)).getAllWarnings()));
    }

    private void printWarnings(@NotNull ThrowableComputable<List<SQLWarning>, Throwable> producer) {
        if (producer == null) {
            JdbcEngine.$$$reportNull$$$0(21);
        }
        try {
            List warnings = (List)producer.compute();
            for (SQLWarning throwables : warnings) {
                this.getDataAuditor().warn(this.getRequestContext(), JdbcUtil.getLongMessage((Throwable)throwables));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void printAllWarnings() {
        for (JdbcEngine engine : ourPendingStatements.keySet()) {
            Statement statement;
            DatabaseFamilyId familyId;
            if (engine.myState.get() != State.RUNNING || (familyId = engine.myFamilyId) != DatabaseFamilyId.REDSHIFT && familyId != DatabaseFamilyId.POSTGRES && familyId != DatabaseFamilyId.MSSQL || (statement = ourPendingStatements.get(engine)) == null) continue;
            try {
                engine.printWarnings(statement);
            }
            catch (Throwable throwable) {}
        }
        if (!ourPendingStatements.isEmpty()) {
            ourPendingStatementsAlarm.cancelAndRequest();
        }
    }

    private void changeCurrentStatement(@Nullable Statement newValue) {
        if (newValue == null) {
            ourPendingStatements.remove(this);
            this.myState.set(State.IDLE);
        } else {
            ourPendingStatements.put(this, newValue);
            this.myState.set(State.RUNNING);
        }
        ourPendingStatementsAlarm.request();
    }

    private boolean isConnectionReady(@Nullable DatabaseConnection connection) {
        if (connection == null) {
            return false;
        }
        try {
            if (this.myFamilyId.isMysql()) {
                return connection.getJdbcConnection().isValid(20);
            }
            return !connection.getJdbcConnection().isClosed();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void prepareConnection(@NotNull DatabaseConnection connection, boolean setCurrentSchema) throws Exception {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(22);
        }
        boolean autoCommit = this.myTxMarker == DataRequest.AUTO_COMMIT;
        DatabaseMetaData metaData = connection.getMetaData();
        boolean bl = this.mySupportsSavepoints = metaData != null && metaData.supportsSavepoints();
        if (connection.getAutoCommit() != autoCommit) {
            connection.setAutoCommit(autoCommit);
        }
        this.setTxIsolation(connection);
        try {
            if (autoCommit && !this.myFamilyId.isSqlite()) {
                connection.setReadOnly(this.myDataSource.isReadOnly());
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        SearchPath schema = this.mySearchPath;
        if (setCurrentSchema && schema != null) {
            if (DbImplUtil.supportsDynamicSchemaSwitching(this.myDataSource)) {
                DataRequest.Context context = this.getRequestContextIfAny();
                DataRequest.SchemaSwitchRequest request = (DataRequest.SchemaSwitchRequest)ObjectUtils.tryCast((Object)(context != null ? context.request : null), DataRequest.SchemaSwitchRequest.class);
                this.performSchemaSwitch(connection, schema, request, false);
            }
        } else if (schema == null) {
            this.requestSearchPathTransparent(connection);
        }
    }

    private void setTxIsolation(@NotNull DatabaseConnection dbConnection) throws SQLException {
        if (dbConnection == null) {
            JdbcEngine.$$$reportNull$$$0(23);
        }
        DataRequest.Context context = this.getRequestContextIfAny();
        if (!TransactionAction.TxIsolation.levelsSupported(this.myFamilyId) || context == null) {
            return;
        }
        DataRequest.TxIsolationOwner owner = (DataRequest.TxIsolationOwner)ObjectUtils.tryCast((Object)context.request.owner, DataRequest.TxIsolationOwner.class);
        if (owner == null || !this.shouldChangeIsolation(dbConnection, owner, context)) {
            return;
        }
        dbConnection.getJdbcConnection().setTransactionIsolation(owner.getTxIsolation());
    }

    private void storeTxIsolation(@NotNull DataRequest.Context context, @NotNull DatabaseConnection connection) {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(24);
        }
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(25);
        }
        if (!TransactionAction.TxIsolation.levelsSupported(this.myFamilyId)) {
            return;
        }
        Connection jdbcConnection = connection.getJdbcConnection();
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            if (metaData == null || !metaData.supportsTransactions()) {
                return;
            }
            int isolation = jdbcConnection.getTransactionIsolation();
            ObjectUtils.consumeIfCast((Object)((Object)context), DataRequest.TxContext.class, ex -> ex.setIsolation(isolation));
        }
        catch (SQLException e) {
            LOG.warn((Throwable)e);
        }
    }

    private boolean shouldChangeIsolation(@NotNull DatabaseConnection connection, @NotNull DataRequest.TxIsolationOwner owner, @NotNull DataRequest.Context context) {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(26);
        }
        if (owner == null) {
            JdbcEngine.$$$reportNull$$$0(27);
        }
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(28);
        }
        try {
            DatabaseMetaData data = connection.getMetaData();
            Connection jdbcConnection = connection.getJdbcConnection();
            int ownerIsolation = owner.getTxIsolation();
            return !(data == null || !data.supportsTransactions() || context.request.txMarker != DataRequest.AUTO_COMMIT && context.request.txMarker != DataRequest.START_NEW || ownerIsolation == TransactionAction.TxIsolation.DEFAULT.getIsolation() || !this.myFamilyId.isSybase() && !data.supportsTransactionIsolationLevel(ownerIsolation) || jdbcConnection.getTransactionIsolation() == ownerIsolation);
        }
        catch (SQLException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    private boolean performSchemaSwitch(@NotNull DatabaseConnection connection, @NotNull SearchPath searchPath, @Nullable DataRequest.SchemaSwitchRequest request, boolean allowReset) throws Exception {
        String setSchemaSql;
        String sql;
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(29);
        }
        if (searchPath == null) {
            JdbcEngine.$$$reportNull$$$0(30);
        }
        if ((sql = (setSchemaSql = DbImplUtil.getSearchPath(searchPath, this.myDataSource, this.myDialect)) == null && allowReset && searchPath.getCurrent().kind == ObjectKind.DATABASE && JdbcUrlParserUtil.isDatabaseBounded(connection.getConnectionPoint()) ? this.myDialect.sqlResetSearchPath() : setSchemaSql) == null) {
            return false;
        }
        boolean requestSearchPath = sql != setSchemaSql;
        boolean explicit = request != null;
        return this.withStatement(sql, (Statement)((Object)connection), (ThrowableNotNullFunction)statement -> {
            if (connection == null) {
                JdbcEngine.$$$reportNull$$$0(94);
            }
            if (searchPath == null) {
                JdbcEngine.$$$reportNull$$$0(95);
            }
            try {
                statement.execute(sql);
                if (requestSearchPath) {
                    this.requestSearchPath(connection);
                } else {
                    this.setSearchPath(searchPath);
                }
                return true;
            }
            catch (SQLException e) {
                this.printWarnings((Statement)statement);
                if (explicit) {
                    this.getRequestContext().reportException(e, statement);
                } else {
                    String errorMessage = JdbcEngine.getErrorMessage(e, this.myDataSource.getName(), this.myDataSource.getFamilyId());
                    this.getDataAuditor().print(this.getRequestContext(), "Failed to switch schema.\n" + errorMessage);
                }
                return false;
            }
        });
    }

    private void suppressAudit() {
        MeasuringDataAuditor.SILENT_KEY.set((UserDataHolder)this.getRequestContext(), (Object)true);
    }

    @Nullable
    private RowQueryData buildDataForSelect(@NotNull DataRequest.ConditionQueryRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(31);
        }
        RowQueryData data = r.rowQueryData;
        String sql = data.getSql();
        String alias = r.table == null ? DbImplUtil.findFreeAlias(this.getProject(), this.myDialect, sql, "a") : "t";
        DdlBuilder builder = this.getConditionRequestQuery(r, alias);
        if (builder == null) {
            return null;
        }
        builder.space().keyword("WHERE").space();
        List<ColumnQueryData> newData = DbImplUtil.composeWhereConditionWithParameters(builder, data, alias, this.myDialect);
        return new RowQueryData(newData, data.getRow(), builder.getStatement());
    }

    @Nullable
    private DdlBuilder getConditionRequestQuery(@NotNull DataRequest.ConditionQueryRequest r, @NotNull String alias) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(32);
        }
        if (alias == null) {
            JdbcEngine.$$$reportNull$$$0(33);
        }
        if (r.table != null) {
            return DbImplUtil.createSelectAllQuery(r.table, this.myDialect, this.myDataSource);
        }
        String sql = r.rowQueryData.getSql();
        return DbImplUtil.wrapSelectQuery(this.getProject(), this.myDialect, sql, alias);
    }

    @NotNull
    public QueryData buildDataForDelete(@NotNull DataRequest.DeleteRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(34);
        }
        QueryData queryData = JdbcEngine.mergedQueryData(r.context.getMutations(), (Function<RowMutation, RowQueryData>)((Function)mutation -> {
            if (r == null) {
                JdbcEngine.$$$reportNull$$$0(93);
            }
            String alias = this.myFamilyId.isDb2() ? "t" : null;
            DdlBuilder builder = DbImplUtil.createBuilderForExec(this.myDialect);
            List<ColumnQueryData> filtered = DbImplUtil.getWhereClauseColumns(r.context.getTable(), mutation.getData(), this.myDialect);
            builder.keyword("DELETE").space().keyword("FROM").space().qualifiedRef((DasObject)r.context.getTable()).space();
            if (alias != null) {
                builder.alias(alias).space();
            }
            builder.keyword("WHERE").space();
            List<ColumnQueryData> whereData = DbImplUtil.composeWhereConditionWithParameters(builder, filtered, alias, this.myDialect);
            String sql = builder.getStatement();
            return new RowQueryData(whereData, mutation.getRow(), sql);
        }));
        if (queryData == null) {
            JdbcEngine.$$$reportNull$$$0(35);
        }
        return queryData;
    }

    @NotNull
    public QueryData buildDataForUpdate(@NotNull DataRequest.UpdateRequest r) {
        DatabaseFamilyId familyId;
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(36);
        }
        String alias = (familyId = this.myDataSource.getFamilyId()).isSqlite() || familyId.isPostgres() || familyId.isTransactSql() || familyId == DatabaseFamilyId.VERTICA || familyId == DatabaseFamilyId.FRONTBASE ? null : "t";
        QueryData queryData = JdbcEngine.mergedQueryData(r.context.getMutations(), (Function<RowMutation, RowQueryData>)((Function)mutation -> {
            if (r == null) {
                JdbcEngine.$$$reportNull$$$0(92);
            }
            DataConsumer.Row row = mutation.getRow();
            List keyColumns = DbImplUtil.getWhereClauseColumns(r.context.getTable(), (List)ObjectUtils.assertNotNull(r.context.getColumns()), this.myDialect);
            DdlBuilder builder = DbImplUtil.createBuilderForExec(this.myDialect);
            builder.keyword("UPDATE").space().qualifiedRef((DasObject)r.context.getTable()).space();
            if (alias != null) {
                builder.alias(alias).space();
            }
            builder.keyword("SET").space();
            boolean first = true;
            ArrayList columnsData = ContainerUtil.newArrayList();
            for (ColumnQueryData data : mutation.getData()) {
                DataConsumer.Column targetColumn = data.getColumn();
                if (!first) {
                    builder.symbol(",").space();
                } else {
                    first = false;
                }
                if (alias != null) {
                    builder.alias(alias).symbol(".");
                }
                builder.identifier(targetColumn.name).space().symbol("=").space();
                Object value = data.getObject();
                if (value == ReservedCellValue.DEFAULT) {
                    builder.keyword("DEFAULT");
                    continue;
                }
                builder.symbol("?");
                columnsData.add(data);
            }
            int escapingIndex = columnsData.size();
            builder.space().keyword("WHERE").space();
            List keyData = ContainerUtil.map(keyColumns, column -> new ColumnQueryData((DataConsumer.Column)column, column.getValue(row)));
            List<ColumnQueryData> whereData = DbImplUtil.composeWhereConditionWithParameters(builder, keyData, alias, this.myDialect);
            String sql = builder.getStatement();
            columnsData.addAll(whereData);
            return new RowQueryData(columnsData, mutation.getRow(), sql, escapingIndex);
        }));
        if (queryData == null) {
            JdbcEngine.$$$reportNull$$$0(37);
        }
        return queryData;
    }

    @NotNull
    public QueryData buildDataForInsert(@NotNull DataRequest.InsertRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(38);
        }
        DatabaseDialectEx dialect = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(this.myDataSource), (Object)GenericDialect.INSTANCE);
        ArrayList params2 = ContainerUtil.newArrayList();
        List<RowMutation> mutations = r.context.getMutations();
        DdlBuilder builder = DbImplUtil.createBuilderForExec(dialect);
        for (RowMutation mutation : mutations) {
            List<AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>> delegateDescriptors = JdbcEngine.createDescriptors(mutation);
            Condition isDefault = d -> !d.isComputed() && !d.isAutogenerated() && !d.hasDefault();
            List forInsert = ContainerUtil.filter(delegateDescriptors, (Condition)isDefault);
            List<String> placeholders = JdbcEngine.getPlaceholdersForInsert(delegateDescriptors, dialect);
            List<String> colNames = JdbcEngine.getColumnNamesForInsert(delegateDescriptors, dialect);
            dialect.sqlInsertInto(builder, r.context.getTable(), colNames, placeholders);
            String sql = builder.getStatement();
            RowQueryData qData = new RowQueryData(ContainerUtil.map((Collection)forInsert, AutoValueDescriptor.DelegateDescriptor::getDelegate), mutation.getRow(), sql, forInsert.size());
            params2.add(new RowUpdateData(qData, 1));
            builder.clear();
        }
        QueryData queryData = new QueryData(params2);
        if (queryData == null) {
            JdbcEngine.$$$reportNull$$$0(39);
        }
        return queryData;
    }

    @NotNull
    private static List<AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>> createDescriptors(@NotNull RowMutation mutation) {
        if (mutation == null) {
            JdbcEngine.$$$reportNull$$$0(40);
        }
        DataConsumer.Row row = mutation.getRow();
        List list = JBIterable.from(mutation.getData()).map(data -> {
            DataConsumer.Column column = data.getColumn();
            Object value = column.getValue(row);
            boolean autogenerated = value == ReservedCellValue.GENERATED;
            boolean isDefault = value == ReservedCellValue.DEFAULT;
            boolean isComputed = value == ReservedCellValue.COMPUTED;
            return new AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>((ColumnQueryData)data, autogenerated, isDefault, isComputed);
        }).toList();
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(41);
        }
        return list;
    }

    public void executeUpdateStatement(@NotNull DataRequest request, @NotNull List<QueryData> infos) {
        if (request == null) {
            JdbcEngine.$$$reportNull$$$0(42);
        }
        if (infos == null) {
            JdbcEngine.$$$reportNull$$$0(43);
        }
        this.submitRequest(request, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            DatabaseConnection connection;
            if (infos == null) {
                JdbcEngine.$$$reportNull$$$0(91);
            }
            if ((connection = this.getConnection()) == null) {
                return false;
            }
            try {
                Boolean bl = new UpdateOperation(infos, this.isTransactionStarted()).perform(connection);
                return bl;
            }
            finally {
                this.printWarnings(connection);
            }
        }));
    }

    @Nullable
    private StatementHolder<?> createStatementHolder(@NotNull DataRequest.QueryRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(44);
        }
        if (r instanceof DataRequest.ConditionQueryRequest) {
            RowQueryData data = this.buildDataForSelect((DataRequest.ConditionQueryRequest)r);
            return data == null ? null : new PreparedStatementHolder(data);
        }
        return new RegularStatementHolder(r.query, r, JdbcEngine.willScrollResultSet(r.constraints));
    }

    private void completeStatement(PreparedStatement statement, RowQueryData rowInfo, int escapeIdx) throws Exception {
        int idx = 0;
        for (ColumnQueryData updateData : rowInfo) {
            Object object = updateData.getObject();
            DbImplUtil.setStatementParameter(statement, updateData, object, this.myDialect, idx >= escapeIdx, ++idx);
        }
    }

    @NotNull
    public static String getErrorMessage(Throwable th, String sourceName, DatabaseFamilyId familyId) {
        StringBuilder sb = new StringBuilder();
        String string = JdbcEngine.appendErrorMessage(sb, th, sourceName, familyId).toString().trim();
        if (string == null) {
            JdbcEngine.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public static <T extends AutoValueDescriptor> List<String> getColumnNamesForInsert(@NotNull Collection<T> descriptors, @NotNull DatabaseDialectEx dialect) {
        if (descriptors == null) {
            JdbcEngine.$$$reportNull$$$0(46);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(47);
        }
        List list = JdbcEngine.shouldParticipateInInsert(descriptors, dialect).map(ColumnDescriptor::getName).toList();
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    public static <T extends AutoValueDescriptor> List<String> getPlaceholdersForInsert(@NotNull Collection<T> descriptors, @NotNull DatabaseDialectEx dialect) {
        if (descriptors == null) {
            JdbcEngine.$$$reportNull$$$0(49);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(50);
        }
        List list = JdbcEngine.shouldParticipateInInsert(descriptors, dialect).map(d -> d.isAutogenerated() || d.hasDefault() ? "DEFAULT" : "?").toList();
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(51);
        }
        return list;
    }

    @NotNull
    private static <T extends AutoValueDescriptor> JBIterable<T> shouldParticipateInInsert(@NotNull Collection<T> descriptors, @NotNull DatabaseDialectEx dialect) {
        if (descriptors == null) {
            JdbcEngine.$$$reportNull$$$0(52);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(53);
        }
        JBIterable jBIterable = JBIterable.from(descriptors).filter(d -> {
            if (dialect == null) {
                JdbcEngine.$$$reportNull$$$0(90);
            }
            return !(d.isComputed() || d.isAutogenerated() && !dialect.supportsInsertDefaultIntoAutoVal() || d.hasDefault() && dialect.getFamilyId().isSqlite());
        });
        if (jBIterable == null) {
            JdbcEngine.$$$reportNull$$$0(54);
        }
        return jBIterable;
    }

    @NotNull
    private static QueryData mergedQueryData(@NotNull List<RowMutation> mutations, @NotNull Function<RowMutation, RowQueryData> converter) {
        if (mutations == null) {
            JdbcEngine.$$$reportNull$$$0(55);
        }
        if (converter == null) {
            JdbcEngine.$$$reportNull$$$0(56);
        }
        TObjectIntHashMap map2 = new TObjectIntHashMap(QUERY_DATA_HASHING_STRATEGY);
        for (RowMutation mutation : mutations) {
            RowQueryData qData = (RowQueryData)converter.fun((Object)mutation);
            if (map2.increment((Object)qData)) continue;
            map2.put((Object)qData, 1);
        }
        QueryData queryData = new QueryData(Arrays.stream(map2.keys()).map(o -> new RowUpdateData((RowQueryData)o, map2.get((Object)((RowQueryData)o)))).collect(Collectors.toList()));
        if (queryData == null) {
            JdbcEngine.$$$reportNull$$$0(57);
        }
        return queryData;
    }

    private static StringBuilder appendErrorMessage(@NotNull StringBuilder sb, @NotNull Throwable e, @NotNull String processName, @NotNull DatabaseFamilyId familyId) {
        String message;
        Throwable t;
        if (sb == null) {
            JdbcEngine.$$$reportNull$$$0(58);
        }
        if (e == null) {
            JdbcEngine.$$$reportNull$$$0(59);
        }
        if (processName == null) {
            JdbcEngine.$$$reportNull$$$0(60);
        }
        if (familyId == null) {
            JdbcEngine.$$$reportNull$$$0(61);
        }
        if (e != (t = ExceptionUtil.getRootCause((Throwable)e)) && e instanceof SQLException && StringUtil.indexOf((CharSequence)sb, (CharSequence)(message = JdbcUtil.getMessage((Throwable)e))) == -1) {
            sb.append(JdbcUtil.getMessagePrefix((Throwable)e)).append(message).append("\n");
        }
        if (t instanceof UnsupportedOperationException) {
            sb.append(JdbcUtil.getMessage((Throwable)t));
        } else if (t instanceof SQLException) {
            SQLException next;
            message = JdbcUtil.getMessage((Throwable)t);
            if (StringUtil.indexOf((CharSequence)sb, (CharSequence)message) == -1) {
                sb.append(JdbcUtil.getMessagePrefix((Throwable)t)).append(message);
            }
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
            if (StringUtil.contains((CharSequence)sb, (CharSequence)"ORA-12705:")) {
                sb.append("\n").append(DatabaseMessages.message((String)"error.message.ora.nls", (Object[])new Object[]{processName}));
            }
            if ((next = ((SQLException)t).getNextException()) != null && next != t) {
                JdbcEngine.appendErrorMessage(sb.append("\n"), next, processName, familyId);
            }
        } else if (t instanceof RemoteException) {
            sb.append(t.toString());
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else if (t instanceof EOFException && e instanceof RemoteException) {
            sb.append(processName).append(": process exited");
        } else if (t instanceof FileNotFoundException && JdbcEngine.isRedshiftDriverFailure(t)) {
            sb.append(DatabaseMessages.message((String)"error.message.redshift.file.not.found", (Object[])new Object[0]));
        } else if (t instanceof IOException) {
            sb.append(t.toString());
        } else if (t instanceof ExecutionException) {
            sb.append(JdbcUtil.getMessage((Throwable)t));
        } else if (t instanceof SuppressUserStackTrace) {
            sb.append(JdbcUtil.getMessage((Throwable)t));
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else if (t instanceof UnsafeUpdateRolledBackException) {
            sb.append(t.getMessage());
        } else if (t instanceof OutOfMemoryError) {
            sb.append(DatabaseMessages.message((String)"error.message.remote.oomerror", (Object[])new Object[]{processName}));
            LOG.info(t);
        } else if (t instanceof RuntimeException && familyId.isDerby() && sb.length() > 0) {
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else {
            sb.append(ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG));
        }
        return sb;
    }

    private static boolean isRedshiftDriverFailure(@NotNull Throwable t) {
        if (t == null) {
            JdbcEngine.$$$reportNull$$$0(62);
        }
        return ContainerUtil.find((Object[])t.getStackTrace(), element -> StringUtil.contains((CharSequence)element.getClassName(), (CharSequence)"com.amazon.redshift.jdbc")) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printResultSet(@NotNull ResultSet resultSet, int resultSetIndex, int start, int pageSize, int chunkSize, int[] rowCount) throws Exception {
        if (resultSet == null) {
            JdbcEngine.$$$reportNull$$$0(63);
        }
        this.checkCanceled();
        DataRequest request = this.getRequestContext().request;
        DataConsumer handler = this.getDataConsumer();
        if (request instanceof DataRequest.IsolatedQueryRequest) {
            handler = (DataConsumer)((Object)request);
        }
        if (start < 0) {
            handler = new LastPageHandler(handler, start, pageSize);
            pageSize = -1;
        }
        RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemoteNotNull((Object)resultSet, RemoteResultSet.class);
        DataConsumer.Column[] columnsDescr = JdbcEngine.getColumnDescriptors(resultSet, this.myDialect);
        handler.setColumns(this.getRequestContext(), resultSetIndex, columnsDescr, Math.max(1, start));
        rowCount[0] = 0;
        int rowNum = 0;
        boolean hasNext = true;
        ArrayList<DataConsumer.Row> rows = ContainerUtil.newArrayListWithCapacity((int)chunkSize);
        try {
            rowNum = remoteResultSet.scrollToPosition(0, start - 1);
            if (request instanceof DataRequest.RawQueryRequest) {
                List<Object[]> rowObjects;
                while (!(rowObjects = JdbcEngine.getObjects(resultSet, this.myDialect, this, -1, 1, true)).isEmpty()) {
                    this.checkCanceled();
                    DataConsumer.Row row = DataConsumer.Row.create(rowNum++, (Object[])ContainerUtil.getFirstItem(rowObjects));
                    handler.addRows(this.getRequestContext(), Collections.singletonList(row));
                    rowCount[0] = rowCount[0] + 1;
                    if (DbImplUtil.isPageSizeUnlimited(pageSize) || rowCount[0] < pageSize) continue;
                    break;
                }
                hasNext = !rowObjects.isEmpty() && resultSet.next();
                this.printWarnings(resultSet);
            } else {
                int maxLobLength = DatabaseSettings.getSettings().getMaxLobLength();
                while (hasNext) {
                    int rowsToLoad;
                    this.checkCanceled();
                    int n = rowsToLoad = DbImplUtil.isPageSizeUnlimited(pageSize) ? chunkSize : Math.min(chunkSize, pageSize - rowCount[0]);
                    if (rowsToLoad == 0) break;
                    List<Object[]> data = JdbcEngine.getObjects(resultSet, this.myDialect, this, maxLobLength, rowsToLoad);
                    this.printWarnings(resultSet);
                    hasNext = data.size() == rowsToLoad;
                    rowCount[0] = rowCount[0] + data.size();
                    for (Object[] rowData : data) {
                        rows.add(DataConsumer.Row.create(rowNum++, rowData));
                        if (rows.size() != chunkSize) continue;
                        handler.addRows(this.getRequestContext(), (List<DataConsumer.Row>)rows);
                        rows = new ArrayList<DataConsumer.Row>(chunkSize);
                    }
                }
                if (hasNext) {
                    hasNext = remoteResultSet.next();
                }
            }
        }
        finally {
            if (!rows.isEmpty()) {
                handler.addRows(this.getRequestContext(), (List<DataConsumer.Row>)rows);
            }
            if (start < 0) {
                rowCount[0] = ((LastPageHandler)handler).getRowCount();
            }
            try {
                if (hasNext && rowCount[0] != 0) {
                    ++rowNum;
                }
            }
            finally {
                handler.afterLastRowAdded(this.getRequestContext(), rowNum);
            }
        }
    }

    @NotNull
    public static List<Object[]> getObjects(@NotNull ResultSet resultSet, @NotNull DatabaseDialect dialect, @NotNull Object requestor, int maxLobLength, int rowsToLoad) throws Exception {
        if (resultSet == null) {
            JdbcEngine.$$$reportNull$$$0(64);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(65);
        }
        if (requestor == null) {
            JdbcEngine.$$$reportNull$$$0(66);
        }
        List<Object[]> list = JdbcEngine.getObjects(resultSet, dialect, requestor, maxLobLength, rowsToLoad, false);
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(67);
        }
        return list;
    }

    @NotNull
    public static List<Object[]> getObjects(@NotNull ResultSet resultSet, @NotNull DatabaseDialect dialect, @NotNull Object requestor, int maxLobLength, int rowsToLoad, boolean raw) throws Exception {
        if (resultSet == null) {
            JdbcEngine.$$$reportNull$$$0(68);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(69);
        }
        if (requestor == null) {
            JdbcEngine.$$$reportNull$$$0(70);
        }
        RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemoteNotNull((Object)resultSet, RemoteResultSet.class);
        Rdbms rdbms = DbImplUtil.getRdbms(dialect);
        RemoteResultSet.DataRetrievingOptions options = new RemoteResultSet.DataRetrievingOptions(rdbms, Calendar.getInstance(), rowsToLoad, maxLobLength, raw);
        List list = (List)RemoteUtil.handleRemoteResult((Object)remoteResultSet.getObjects(options), List.class, (Object)requestor);
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(71);
        }
        return list;
    }

    public static DataConsumer.Column[] getColumnDescriptors(@NotNull ResultSet resultSet, @NotNull DatabaseDialect dialect) throws SQLException {
        if (resultSet == null) {
            JdbcEngine.$$$reportNull$$$0(72);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(73);
        }
        ResultSetMetaData metaData = resultSet.getMetaData();
        int count2 = metaData.getColumnCount();
        DataConsumer.Column[] columnsDescr = new DataConsumer.Column[count2];
        int columnNum = 0;
        for (int i2 = 1; i2 <= count2; ++i2) {
            String name = null;
            try {
                name = metaData.getColumnLabel(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String typeName = null;
            try {
                typeName = metaData.getColumnTypeName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int type = 1111;
            try {
                type = metaData.getColumnType(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String clazz = null;
            try {
                clazz = metaData.getColumnClassName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String catalog = null;
            try {
                catalog = metaData.getCatalogName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String schema = null;
            try {
                schema = metaData.getSchemaName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String table = null;
            try {
                table = metaData.getTableName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int precision = -1;
            try {
                precision = metaData.getPrecision(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int scale = -1;
            try {
                scale = metaData.getScale(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            type = JdbcNativeUtil.fixJdbcType((Rdbms)DbImplUtil.getRdbms(dialect), (String)typeName, (String)clazz, (int)type);
            if (dialect.getFamilyId().isSqlite()) {
                catalog = "";
            } else if (dialect.getFamilyId().isDb2()) {
                schema = schema == null ? null : StringUtil.trimTrailing((String)schema);
            }
            columnsDescr[i2 - 1] = new DataConsumer.Column(columnNum++, name, type, typeName, clazz, precision, scale, catalog, schema, table);
        }
        return columnsDescr;
    }

    private void checkCanceled() {
        if (this.myState.get() == State.CANCELED) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private Statement openStatement(@NotNull DatabaseConnection connection, boolean withScrollableResultSet) throws Exception {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(74);
        }
        if (ourPendingStatements.get(this) != null) {
            throw new AssertionError();
        }
        boolean scrollableSet = withScrollableResultSet && Registry.is((String)"database.scrollable.result.sets");
        Statement statement = scrollableSet ? this.openStatementWithScrollableResultSetType(connection) : null;
        Statement resultStatement = statement != null ? statement : connection.createStatement();
        this.changeCurrentStatement(resultStatement);
        Statement statement2 = resultStatement;
        if (statement2 == null) {
            JdbcEngine.$$$reportNull$$$0(75);
        }
        return statement2;
    }

    @Nullable
    private Statement openStatementWithScrollableResultSetType(@NotNull DatabaseConnection connection) {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(76);
        }
        try {
            if (this.myFamilyId.isDb2()) {
                return null;
            }
            DatabaseMetaData metaData = connection.getMetaData();
            if (metaData != null && metaData.supportsResultSetType(1004)) {
                return connection.createStatement(1004, 1007);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to create a statement with a scrollable result set type", (Throwable)e);
        }
        return null;
    }

    @NotNull
    private PreparedStatement openPreparedStatement(@NotNull DatabaseConnection connection, @NotNull String sql) throws Exception {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(77);
        }
        if (sql == null) {
            JdbcEngine.$$$reportNull$$$0(78);
        }
        if (ourPendingStatements.get(this) != null) {
            throw new AssertionError();
        }
        PreparedStatement statement = connection.prepareStatement(sql);
        this.changeCurrentStatement(statement);
        PreparedStatement preparedStatement = statement;
        if (preparedStatement == null) {
            JdbcEngine.$$$reportNull$$$0(79);
        }
        return preparedStatement;
    }

    @Override
    protected void releaseConnection() {
        if (this.myConnection == null) {
            return;
        }
        boolean inTran = this.myTxMarker.getOwner() != null;
        try (GuardedRef<DatabaseConnection> connection = this.myConnection;){
            MyContext requestContext;
            this.myConnection = null;
            if (!connection.get().getAutoCommit()) {
                connection.get().rollback();
            }
            if ((requestContext = (MyContext)((Object)ObjectUtils.tryCast((Object)((Object)this.getRequestContextIfAny()), MyContext.class))) != null) {
                if (inTran && !this.isTransactionStarted()) {
                    this.getDataAuditor().txCompleted(requestContext, false);
                    JdbcEngine.printAllWarnings();
                }
                this.getDataAuditor().print(requestContext, "Disconnected");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isTransactionStarted() {
        DataRequest.Context context = this.getRequestContextIfAny();
        return context instanceof MyContext && ((MyContext)context).startedTransaction;
    }

    @Override
    protected void onRequestStarted(@NotNull DataRequest.Context context) throws Exception {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(80);
        }
        try {
            this.changeSearchPathIfNeeded(context, true);
        }
        finally {
            super.onRequestStarted(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRequestFinished(@NotNull DataRequest.Context context) throws Exception {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(81);
        }
        try {
            try {
                this.changeSearchPathIfNeeded(context, false);
            }
            finally {
                DatabaseConnection connection = this.getCurrentConnection();
                if (connection != null) {
                    this.storeTxIsolation(context, connection);
                }
            }
        }
        finally {
            super.onRequestFinished(context);
        }
    }

    private void changeSearchPathIfNeeded(@NotNull DataRequest.Context context, boolean requestStarted) throws Exception {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(82);
        }
        DataRequest request = context.request;
        SearchPath requestPath = request.path;
        MyContext myContext = (MyContext)context;
        SearchPath persistentPath = myContext.startPath;
        if (requestPath == null || persistentPath == null && !requestStarted || Comparing.equal((Object)requestPath, (Object)persistentPath)) {
            return;
        }
        DatabaseConnection connection = this.getCurrentConnection();
        if (connection == null) {
            this.setSearchPath(requestStarted ? requestPath : persistentPath);
            return;
        }
        if (requestStarted && !this.canSwitchSchemaForRequest(myContext, requestPath)) {
            JdbcEngine.reportError(context, "Can't execute request in context of: " + requestPath);
        }
        this.performSchemaSwitch(connection, requestStarted ? requestPath : persistentPath, null, false);
    }

    private boolean withStatement(@Nullable String sql, @NotNull DatabaseConnection connection, @NotNull ThrowableNotNullFunction<Statement, Boolean, Exception> runnable) throws Exception {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(83);
        }
        if (runnable == null) {
            JdbcEngine.$$$reportNull$$$0(84);
        }
        return this.withStatement(sql, this.openStatement(connection, false), runnable);
    }

    /*
     * Loose catch block
     */
    private <T extends Statement> boolean withStatement(@Nullable String sql, @NotNull T statement, @NotNull ThrowableNotNullFunction<T, Boolean, Exception> runnable) throws Exception {
        if (statement == null) {
            JdbcEngine.$$$reportNull$$$0(85);
        }
        if (runnable == null) {
            JdbcEngine.$$$reportNull$$$0(86);
        }
        DataRequest.Context context = this.getRequestContext();
        if (sql != null) {
            context.statementContext.set(new DataRequest.StatementContext(sql));
        }
        this.getDataAuditor().beforeStatement(context);
        try {
            try (StatementRef statementRef = new StatementRef(this, statement);){
                boolean bl = (Boolean)runnable.fun(statementRef.get());
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.getDataAuditor().afterStatement(context);
            context.statementContext.set(null);
        }
    }

    private boolean canSwitchSchemaForRequest(@NotNull MyContext context, @NotNull SearchPath path) {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(87);
        }
        if (path == null) {
            JdbcEngine.$$$reportNull$$$0(88);
        }
        return !this.willReconnect(path.getCurrent()) || context.startedTransaction || this.myTxMarker.getOwner() == null;
    }

    private boolean willReconnect(@NotNull ObjectPath needed) {
        if (needed == null) {
            JdbcEngine.$$$reportNull$$$0(89);
        }
        ObjectPath current = this.getCurrentNamespace();
        DatabaseConnection connection = this.getCurrentConnection();
        return current == null ? JdbcUrlParserUtil.outOfBounds(connection == null ? this.myDataSource : connection.getConnectionPoint(), needed) : JdbcUrlParserUtil.outOfBounds(this.myDataSource, current, needed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 15: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 67: 
            case 71: 
            case 75: 
            case 79: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 15: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 67: 
            case 71: 
            case 75: 
            case 79: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 6: 
            case 15: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 67: 
            case 71: 
            case 75: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcEngine";
                break;
            }
            case 7: 
            case 8: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 74: 
            case 76: 
            case 77: 
            case 83: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 44: 
            case 92: 
            case 93: 
            case 96: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 14: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 16: 
            case 24: 
            case 28: 
            case 80: 
            case 81: 
            case 82: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 20: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbConnection";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 30: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPath";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutation";
                break;
            }
            case 43: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 46: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 47: 
            case 50: 
            case 53: 
            case 65: 
            case 69: 
            case 73: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processName";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyId";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 63: 
            case 64: 
            case 68: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 66: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sql";
                break;
            }
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "needed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcEngine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAccessController";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequestContext";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDataForDelete";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDataForUpdate";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDataForInsert";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptors";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnNamesForInsert";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholdersForInsert";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldParticipateInInsert";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "mergedQueryData";
                break;
            }
            case 67: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjects";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "openStatement";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "openPreparedStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 15: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 67: 
            case 71: 
            case 75: 
            case 79: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "requestSearchPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "requestSearchPathTransparent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitQuery";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitUpdate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitInsert";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitDelete";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitSchemaSwitch";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createRequestContext";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getQueryType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateCountSafe";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "printWarnings";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "prepareConnection";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setTxIsolation";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "storeTxIsolation";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shouldChangeIsolation";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "performSchemaSwitch";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForSelect";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getConditionRequestQuery";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForDelete";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForUpdate";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForInsert";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptors";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "executeUpdateStatement";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createStatementHolder";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNamesForInsert";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholdersForInsert";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "shouldParticipateInInsert";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "mergedQueryData";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "appendErrorMessage";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isRedshiftDriverFailure";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "printResultSet";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getObjects";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getColumnDescriptors";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "openStatement";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "openStatementWithScrollableResultSetType";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "openPreparedStatement";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "onRequestStarted";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "onRequestFinished";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "changeSearchPathIfNeeded";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "withStatement";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "canSwitchSchemaForRequest";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "willReconnect";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "lambda$shouldParticipateInInsert$21";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeUpdateStatement$19";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildDataForUpdate$16";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildDataForDelete$14";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performSchemaSwitch$13";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "lambda$visitSchemaSwitch$7";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "lambda$visitQuery$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 15: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 67: 
            case 71: 
            case 75: 
            case 79: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EngineWarningException
    extends SQLException {
        private final String myLogMessage;

        EngineWarningException(@NotNull String message, @NotNull String logMessage) {
            if (message == null) {
                EngineWarningException.$$$reportNull$$$0(0);
            }
            if (logMessage == null) {
                EngineWarningException.$$$reportNull$$$0(1);
            }
            super(message);
            this.myLogMessage = logMessage;
            this.setStackTrace(new StackTraceElement[0]);
        }

        @NotNull
        public String getLogMessage() {
            String string = this.myLogMessage;
            if (string == null) {
                EngineWarningException.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logMessage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$EngineWarningException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$EngineWarningException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StatementRef<T extends Statement>
    extends GuardedRef<T> {
        final /* synthetic */ JdbcEngine this$0;

        StatementRef(T statement) {
            if (statement == null) {
                StatementRef.$$$reportNull$$$0(0);
            }
            this.this$0 = var1_1;
            super(statement);
        }

        @Override
        protected void close(@NotNull T ref) {
            if (ref == null) {
                StatementRef.$$$reportNull$$$0(1);
            }
            this.this$0.changeCurrentStatement(null);
            try {
                if (this.this$0.myConnection != null) {
                    ref.close();
                }
            }
            catch (Exception e) {
                this.this$0.getRequestContext().reportException(e, ref);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$StatementRef";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "close";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class QueryExecutionOperation<T extends Statement>
    extends PotentiallyAtomicOperation {
        private final StatementHolder<T> myHolder;
        private final DataRequest.QueryRequest myRequest;
        private boolean mySearchPathRequested;

        public QueryExecutionOperation(@NotNull StatementHolder<T> holder, DataRequest.QueryRequest request) {
            if (holder == null) {
                QueryExecutionOperation.$$$reportNull$$$0(0);
            }
            if (request == null) {
                QueryExecutionOperation.$$$reportNull$$$0(1);
            }
            super(JdbcEngine.this.myFamilyId.isRedshift() || JdbcEngine.this.isTransactionStarted());
            this.myHolder = holder;
            this.myRequest = request;
        }

        @Override
        @NotNull
        protected PotentiallyAtomicOperation.AtomicHelper createHelper(@NotNull DatabaseConnection connection) throws SQLException {
            if (connection == null) {
                QueryExecutionOperation.$$$reportNull$$$0(2);
            }
            SilentHelper silentHelper = new SilentHelper(super.createHelper(connection));
            if (silentHelper == null) {
                QueryExecutionOperation.$$$reportNull$$$0(3);
            }
            return silentHelper;
        }

        @Override
        boolean atomic(@NotNull DatabaseConnection connection, boolean isAtomic) throws Exception {
            if (connection == null) {
                QueryExecutionOperation.$$$reportNull$$$0(4);
            }
            return JdbcEngine.this.withStatement(this.myHolder.getSql(), this.myHolder.create(connection), statement -> {
                if (connection == null) {
                    QueryExecutionOperation.$$$reportNull$$$0(8);
                }
                try {
                    Boolean bl = this.execute(connection, statement);
                    return bl;
                }
                catch (Throwable e) {
                    JdbcEngine.this.getRequestContext().reportException(e, this.myHolder.getSql());
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    if (!this.mySearchPathRequested && this.myRequest instanceof ConsoleDataRequest && ((ConsoleDataRequest)this.myRequest).isExecutionStopper()) {
                        JdbcEngine.this.requestSearchPath(connection);
                    }
                    JdbcEngine.this.printWarnings(connection);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean execute(@NotNull DatabaseConnection connection, @NotNull T statement) throws Exception {
            if (connection == null) {
                QueryExecutionOperation.$$$reportNull$$$0(5);
            }
            if (statement == null) {
                QueryExecutionOperation.$$$reportNull$$$0(6);
            }
            String queryText = this.myHolder.getSql();
            this.requestWriteAccess(queryText);
            DataRequest.Constraints constraints = this.myRequest.constraints;
            int maxRows = -1;
            Object type = JdbcEngine.this.getQueryType(queryText, this.myRequest);
            if (type instanceof SqlTableType) {
                if (constraints.offset >= 0 && !DbImplUtil.isPageSizeUnlimited(constraints.limit)) {
                    maxRows = constraints.offset + constraints.limit + 1;
                    statement.setMaxRows(maxRows);
                }
                JdbcEngine.this.requestSearchPath(connection);
                this.mySearchPathRequested = true;
            }
            int maxAllowedChunkSize = maxRows < 0 ? Integer.MAX_VALUE : maxRows;
            int defaultPrefetchSize = DatabaseSettings.getSettings().getPrefetchSize();
            int chunkSize = Math.min(maxAllowedChunkSize, Math.max(constraints.limit / 10, defaultPrefetchSize <= 0 ? 100 : defaultPrefetchSize));
            JdbcEngine.this.configurePreFetchSize(statement, chunkSize);
            try {
                boolean resultSetHere = this.myHolder.execute(statement);
                ResultSet resultSet = this.myHolder.getResultSet();
                int updateCount = JdbcEngine.getUpdateCountSafe(statement);
                int resultSetIndex = 0;
                int maxResultSetIndex = Registry.intValue((String)"database.result.set.limit");
                do {
                    JdbcEngine.this.checkCanceled();
                    if ((updateCount == -1 || resultSetHere) && resultSet == null) {
                        resultSet = statement.getResultSet();
                    }
                    if (resultSet != null) {
                        if (this.myRequest.constraints.resultSetNumber <= 0 || this.myRequest.constraints.resultSetNumber == ++resultSetIndex) {
                            if (resultSetIndex > maxResultSetIndex) {
                                if (resultSetIndex == maxResultSetIndex + 1) {
                                    JdbcEngine.this.getDataAuditor().error(JdbcEngine.this.getRequestContext(), "The maximum number of result sets per query is reached (" + maxResultSetIndex + ").", null);
                                }
                            } else {
                                JdbcEngine.this.checkCanceled();
                                int[] rowCount = new int[]{0};
                                try {
                                    JdbcEngine.this.getDataAuditor().fetchStarted(JdbcEngine.this.getRequestContext(), resultSetIndex);
                                    JdbcEngine.this.printResultSet(resultSet, resultSetIndex, constraints.offset, constraints.limit, chunkSize, rowCount);
                                }
                                finally {
                                    JdbcEngine.this.getDataAuditor().fetchFinished(JdbcEngine.this.getRequestContext(), resultSetIndex, rowCount[0]);
                                    JdbcEngine.this.printWarnings(resultSet);
                                }
                            }
                        }
                    } else {
                        JdbcEngine.this.getDataAuditor().updateCountReceived(JdbcEngine.this.getRequestContext(), updateCount);
                    }
                    resultSet = null;
                    resultSetHere = statement.getMoreResults();
                    updateCount = JdbcEngine.getUpdateCountSafe(statement);
                } while (resultSetHere || updateCount != -1);
                JdbcEngine.this.printWarnings(statement);
                if (resultSetIndex > maxResultSetIndex) {
                    JdbcEngine.this.getDataAuditor().warn(JdbcEngine.this.getRequestContext(), "The query yielded " + resultSetIndex + " result sets, only " + maxResultSetIndex + " were retrieved.");
                }
            }
            catch (Exception e) {
                JdbcEngine.this.printWarnings(statement);
                throw e;
            }
            return true;
        }

        private void requestWriteAccess(@NotNull String sql) throws EngineWarningException {
            if (sql == null) {
                QueryExecutionOperation.$$$reportNull$$$0(7);
            }
            if (this.myRequest instanceof ConsoleDataRequest && ((ConsoleDataRequest)this.myRequest).force) {
                return;
            }
            DatabaseAccessController.Token token = JdbcEngine.this.myDatabaseAccessController.requestAccess(sql);
            if (!token.success) {
                throw new EngineWarningException(token.message, token.logMessage);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$QueryExecutionOperation";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sql";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$QueryExecutionOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createHelper";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "atomic";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "requestWriteAccess";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$atomic$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class SilentHelper
        implements PotentiallyAtomicOperation.AtomicHelper {
            private final PotentiallyAtomicOperation.AtomicHelper myDelegate;

            SilentHelper(PotentiallyAtomicOperation.AtomicHelper delegate) {
                if (QueryExecutionOperation.this == null) {
                    SilentHelper.$$$reportNull$$$0(0);
                }
                if (delegate == null) {
                    SilentHelper.$$$reportNull$$$0(1);
                }
                this.myDelegate = delegate;
            }

            @Override
            public void free(boolean success) {
                JdbcNativeUtil.performSafe(() -> this.myDelegate.free(success));
            }

            @Override
            public boolean isAvailable() {
                return this.myDelegate.isAvailable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                String string;
                switch (n) {
                    default: {
                        string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "0";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "delegate";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/console/JdbcEngine$QueryExecutionOperation$SilentHelper";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format(string, objectArray));
            }
        }
    }

    private class UpdateOperation
    extends TransactionOperation {
        private final List<QueryData> myQueryData;
        private final UnexpectedUpdatesGuard myGuard;

        UpdateOperation(List<QueryData> queryData, boolean transactionStarted) {
            if (queryData == null) {
                UpdateOperation.$$$reportNull$$$0(0);
            }
            super(transactionStarted);
            this.myQueryData = queryData;
            StringBuilder sb = new StringBuilder();
            for (QueryData info : queryData) {
                sb.append(info.getFullSql());
            }
            this.myGuard = new UnexpectedUpdatesGuard(sb.toString(), this.getExpectedUpdateCounts(queryData));
        }

        @Override
        boolean atomic(@NotNull DatabaseConnection connection, boolean isAtomic) {
            if (connection == null) {
                UpdateOperation.$$$reportNull$$$0(1);
            }
            IntArrayList updateCounts = new IntArrayList();
            for (QueryData data : this.myQueryData) {
                IntArrayList counts = this.executeUpdateStatementAndGetUpdateCounts(connection, data);
                if (counts == null) {
                    return this.myGuard.updateComplete(null, isAtomic);
                }
                updateCounts.add(counts.toArray());
            }
            return this.myGuard.updateComplete(updateCounts, isAtomic);
        }

        @Nullable
        private IntArrayList executeUpdateStatementAndGetUpdateCounts(@NotNull DatabaseConnection connection, @NotNull QueryData data) {
            if (connection == null) {
                UpdateOperation.$$$reportNull$$$0(2);
            }
            if (data == null) {
                UpdateOperation.$$$reportNull$$$0(3);
            }
            IntArrayList updateCounts = new IntArrayList(data.size());
            try {
                for (RowUpdateData rowInfo : data) {
                    RowQueryData qData = rowInfo.getQueryData();
                    String sql = qData.getSql();
                    int escapeIdx = qData.getEscapingIndex();
                    JdbcEngine.this.withStatement(sql, JdbcEngine.this.openPreparedStatement(connection, sql), statement -> {
                        JdbcEngine.this.completeStatement(statement, qData, escapeIdx);
                        int count2 = statement.executeUpdate();
                        JdbcEngine.this.getDataAuditor().updateCountReceived(JdbcEngine.this.getRequestContext(), count2);
                        updateCounts.add(count2);
                        return true;
                    });
                }
            }
            catch (Exception e) {
                JdbcEngine.this.getRequestContext().reportException(e, null);
                return null;
            }
            return updateCounts;
        }

        @NotNull
        private IntArrayList getExpectedUpdateCounts(@NotNull List<QueryData> queryData) {
            if (queryData == null) {
                UpdateOperation.$$$reportNull$$$0(4);
            }
            IntArrayList list = new IntArrayList();
            queryData.stream().flatMap(qData -> qData.getUpdateData().stream()).mapToInt(uData -> uData.getUpdateCount()).forEach(i2 -> list.add(i2));
            IntArrayList intArrayList = list;
            if (intArrayList == null) {
                UpdateOperation.$$$reportNull$$$0(5);
            }
            return intArrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queryData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$UpdateOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$UpdateOperation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpectedUpdateCounts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "atomic";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "executeUpdateStatementAndGetUpdateCounts";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpectedUpdateCounts";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class UnexpectedUpdatesGuard {
            protected final String myStatement;
            private final int myExpectedUpdateCount;
            private final IntArrayList myExpectedUpdateCounts;

            public UnexpectedUpdatesGuard(@NotNull String statement, IntArrayList expectedUpdateCounts) {
                if (UpdateOperation.this == null) {
                    UnexpectedUpdatesGuard.$$$reportNull$$$0(0);
                }
                if (statement == null) {
                    UnexpectedUpdatesGuard.$$$reportNull$$$0(1);
                }
                if (expectedUpdateCounts == null) {
                    UnexpectedUpdatesGuard.$$$reportNull$$$0(2);
                }
                this.myStatement = statement;
                this.myExpectedUpdateCount = IntStream.of(expectedUpdateCounts.toArray()).sum();
                this.myExpectedUpdateCounts = expectedUpdateCounts;
            }

            public boolean updateComplete(@Nullable IntArrayList updateCounts, boolean atomic) {
                boolean rollback;
                Trinity<Integer, Integer, Integer> counts = updateCounts != null ? this.getActualExpectedAndStatementNumber(updateCounts) : null;
                boolean unexpectedUpdateCount = updateCounts != null && this.hasUnexpectedUpdateCount(counts);
                boolean bl = rollback = updateCounts == null || unexpectedUpdateCount;
                if (unexpectedUpdateCount) {
                    if (atomic) {
                        this.reportChangesWillBeRolledBack(counts);
                    } else {
                        this.reportUnexpectedUpdateCount(counts);
                    }
                }
                return !rollback;
            }

            private void reportUnexpectedUpdateCount(@NotNull Trinity<Integer, Integer, Integer> trinity) {
                if (trinity == null) {
                    UnexpectedUpdatesGuard.$$$reportNull$$$0(3);
                }
                String message = DatabaseMessages.message((String)"message.text.error.unexpected.update.count", (Object[])new Object[0]) + this.getDiffString(trinity) + ". Rollback the current transaction to undo changes made by: \n" + this.myStatement;
                JdbcEngine.this.getDataAuditor().print(JdbcEngine.this.getRequestContext(), message);
            }

            protected final boolean hasUnexpectedUpdateCount(@Nullable Trinity<Integer, Integer, Integer> trinity) {
                return trinity != null && !Comparing.equal((Object)trinity.getFirst(), (Object)trinity.getSecond());
            }

            @NotNull
            protected final Trinity<Integer, Integer, Integer> getActualExpectedAndStatementNumber(@NotNull IntArrayList updateCounts) {
                if (updateCounts == null) {
                    UnexpectedUpdatesGuard.$$$reportNull$$$0(4);
                }
                int sum = 0;
                int size = updateCounts.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    int count2 = updateCounts.get(i2);
                    if (this.myExpectedUpdateCounts.size() > i2 && this.myExpectedUpdateCounts.get(i2) != count2) {
                        Trinity trinity = Trinity.create((Object)count2, (Object)1, (Object)(i2 + 1));
                        if (trinity == null) {
                            UnexpectedUpdatesGuard.$$$reportNull$$$0(5);
                        }
                        return trinity;
                    }
                    sum += count2;
                }
                Trinity trinity = Trinity.create((Object)sum, (Object)this.myExpectedUpdateCount, null);
                if (trinity == null) {
                    UnexpectedUpdatesGuard.$$$reportNull$$$0(6);
                }
                return trinity;
            }

            protected final void reportChangesWillBeRolledBack(@NotNull Trinity<Integer, Integer, Integer> trinity) {
                if (trinity == null) {
                    UnexpectedUpdatesGuard.$$$reportNull$$$0(7);
                }
                String message = DatabaseMessages.message((String)"message.text.error.unexpected.update.count", (Object[])new Object[0]) + this.getDiffString(trinity) + "Changes will be rolled back. SQL: \n" + this.myStatement;
                JdbcEngine.this.getRequestContext().reportException(new UnsafeUpdateRolledBackException(message), null);
            }

            @NotNull
            protected final String getDiffString(@NotNull Trinity<Integer, Integer, Integer> trinity) {
                if (trinity == null) {
                    UnexpectedUpdatesGuard.$$$reportNull$$$0(8);
                }
                int actual = (Integer)trinity.getFirst();
                int expected = (Integer)trinity.getSecond();
                Integer statementNumber = (Integer)trinity.getThird();
                String diffString = (statementNumber == null ? "" : " in statement %s") + " (Actual: %s, Expected: %s). ";
                String string = statementNumber == null ? String.format(diffString, actual, expected) : String.format(diffString, statementNumber, actual, expected);
                if (string == null) {
                    UnexpectedUpdatesGuard.$$$reportNull$$$0(9);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 9: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 9: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "0";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expectedUpdateCounts";
                        break;
                    }
                    case 3: 
                    case 7: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "trinity";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updateCounts";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/JdbcEngine$UpdateOperation$UnexpectedUpdatesGuard";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/JdbcEngine$UpdateOperation$UnexpectedUpdatesGuard";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActualExpectedAndStatementNumber";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDiffString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "reportUnexpectedUpdateCount";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getActualExpectedAndStatementNumber";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 9: {
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "reportChangesWillBeRolledBack";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "getDiffString";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 9: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static abstract class PotentiallyTransparentOperation
    extends PotentiallyAtomicOperation {
        PotentiallyTransparentOperation(boolean transactionStarted) {
            super(transactionStarted);
        }

        @Override
        final boolean atomic(@NotNull DatabaseConnection connection, boolean isAtomic) throws Exception {
            if (connection == null) {
                PotentiallyTransparentOperation.$$$reportNull$$$0(0);
            }
            return this.transparent(connection) && !isAtomic;
        }

        abstract boolean transparent(@NotNull DatabaseConnection var1) throws Exception;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$PotentiallyTransparentOperation", "atomic"));
        }
    }

    private static abstract class TransactionOperation
    extends PotentiallyAtomicOperation {
        private boolean myAuto;

        TransactionOperation(boolean transactionStarted) {
            super(transactionStarted);
        }

        @Override
        public boolean perform(@NotNull DatabaseConnection connection) throws Exception {
            if (connection == null) {
                TransactionOperation.$$$reportNull$$$0(0);
            }
            this.myAuto = connection.getAutoCommit();
            if (this.myAuto) {
                connection.setAutoCommit(false);
            }
            try {
                boolean bl = super.perform(connection);
                return bl;
            }
            finally {
                if (this.myAuto) {
                    connection.setAutoCommit(true);
                }
            }
        }

        @Override
        @NotNull
        protected PotentiallyAtomicOperation.AtomicHelper createHelper(@NotNull DatabaseConnection connection) {
            if (connection == null) {
                TransactionOperation.$$$reportNull$$$0(1);
            }
            PotentiallyAtomicOperation.AtomicHelper atomicHelper = this.myAuto ? new PotentiallyAtomicOperation.CommitOrRollback(connection) : new PotentiallyAtomicOperation.RollbackToSavepoint(connection);
            if (atomicHelper == null) {
                TransactionOperation.$$$reportNull$$$0(2);
            }
            return atomicHelper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$TransactionOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$TransactionOperation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createHelper";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class PotentiallyAtomicOperation
    implements Operation {
        private final boolean myTransactionStarted;

        PotentiallyAtomicOperation(boolean transactionStarted) {
            this.myTransactionStarted = transactionStarted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean perform(@NotNull DatabaseConnection connection) throws Exception {
            if (connection == null) {
                PotentiallyAtomicOperation.$$$reportNull$$$0(0);
            }
            AtomicHelper helper = this.createHelper(connection);
            boolean result2 = false;
            try {
                result2 = this.atomic(connection, helper.isAvailable());
            }
            finally {
                helper.free(result2);
            }
            return result2;
        }

        abstract boolean atomic(@NotNull DatabaseConnection var1, boolean var2) throws Exception;

        @NotNull
        protected AtomicHelper createHelper(@NotNull DatabaseConnection connection) throws SQLException {
            if (connection == null) {
                PotentiallyAtomicOperation.$$$reportNull$$$0(1);
            }
            AtomicHelper atomicHelper = connection.getAutoCommit() ? new Inactive() : (this.myTransactionStarted ? new Rollback(connection) : new RollbackToSavepoint(connection));
            if (atomicHelper == null) {
                PotentiallyAtomicOperation.$$$reportNull$$$0(2);
            }
            return atomicHelper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$PotentiallyAtomicOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$PotentiallyAtomicOperation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createHelper";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static class RollbackToSavepoint
        implements AtomicHelper {
            private final Savepoint mySavepoint;
            private final DatabaseConnection myGuardedConnection;

            RollbackToSavepoint(@NotNull DatabaseConnection connection) {
                if (connection == null) {
                    RollbackToSavepoint.$$$reportNull$$$0(0);
                }
                this.myGuardedConnection = connection;
                this.mySavepoint = this.createSavepoint();
            }

            @Override
            public boolean isAvailable() {
                return this.mySavepoint != null;
            }

            @Override
            public void free(boolean success) throws SQLException {
                if (this.mySavepoint == null) {
                    return;
                }
                try {
                    if (!success) {
                        this.myGuardedConnection.rollback(this.mySavepoint);
                    }
                }
                catch (SQLException e) {
                    throw new SQLException(DatabaseMessages.message((String)"message.text.error.failed.to.rollback.to.a.savepoint", (Object[])new Object[0]), e);
                }
                finally {
                    JdbcNativeUtil.performSafe(() -> this.myGuardedConnection.releaseSavepoint(this.mySavepoint));
                }
            }

            @Nullable
            private Savepoint createSavepoint() {
                try {
                    DatabaseMetaData metaData = this.myGuardedConnection.getMetaData();
                    return metaData != null && metaData.supportsSavepoints() ? this.myGuardedConnection.setSavepoint() : null;
                }
                catch (Exception e) {
                    LOG.info("Exception while setting an unnamed savepoint", (Throwable)e);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$PotentiallyAtomicOperation$RollbackToSavepoint", "<init>"));
            }
        }

        static class CommitOrRollback
        implements AtomicHelper {
            private final DatabaseConnection myConnection;

            CommitOrRollback(@NotNull DatabaseConnection connection) {
                if (connection == null) {
                    CommitOrRollback.$$$reportNull$$$0(0);
                }
                this.myConnection = connection;
            }

            @Override
            public void free(boolean success) throws SQLException {
                if (success) {
                    this.myConnection.commit();
                } else {
                    this.myConnection.rollback();
                }
            }

            @Override
            public boolean isAvailable() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$PotentiallyAtomicOperation$CommitOrRollback", "<init>"));
            }
        }

        static class Rollback
        implements AtomicHelper {
            private final DatabaseConnection myConnection;

            Rollback(@NotNull DatabaseConnection connection) {
                if (connection == null) {
                    Rollback.$$$reportNull$$$0(0);
                }
                this.myConnection = connection;
            }

            @Override
            public void free(boolean success) throws SQLException {
                if (!success) {
                    this.myConnection.rollback();
                }
            }

            @Override
            public boolean isAvailable() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$PotentiallyAtomicOperation$Rollback", "<init>"));
            }
        }

        static class Inactive
        implements AtomicHelper {
            Inactive() {
            }

            @Override
            public void free(boolean success) {
            }

            @Override
            public boolean isAvailable() {
                return true;
            }
        }

        static interface AtomicHelper {
            public void free(boolean var1) throws SQLException;

            public boolean isAvailable();
        }
    }

    private static interface Operation {
        public boolean perform(@NotNull DatabaseConnection var1) throws Exception;
    }

    private class PreparedStatementHolder
    implements StatementHolder<PreparedStatement> {
        private final RowQueryData myData;
        private ResultSet myResultSet;

        PreparedStatementHolder(RowQueryData data) {
            if (JdbcEngine.this == null) {
                PreparedStatementHolder.$$$reportNull$$$0(0);
            }
            if (data == null) {
                PreparedStatementHolder.$$$reportNull$$$0(1);
            }
            this.myData = data;
        }

        @Override
        @NotNull
        public PreparedStatement create(@NotNull DatabaseConnection connection) throws Exception {
            if (connection == null) {
                PreparedStatementHolder.$$$reportNull$$$0(2);
            }
            String sql = this.myData.getSql();
            PreparedStatement statement = JdbcEngine.this.openPreparedStatement(connection, sql);
            JdbcEngine.this.completeStatement(statement, this.myData, this.myData.getEscapingIndex());
            PreparedStatement preparedStatement = statement;
            if (preparedStatement == null) {
                PreparedStatementHolder.$$$reportNull$$$0(3);
            }
            return preparedStatement;
        }

        @Override
        public boolean execute(@NotNull PreparedStatement statement) throws Exception {
            if (statement == null) {
                PreparedStatementHolder.$$$reportNull$$$0(4);
            }
            this.myResultSet = statement.executeQuery();
            return this.myResultSet != null;
        }

        @Override
        @Nullable
        public ResultSet getResultSet() {
            return this.myResultSet;
        }

        @Override
        @NotNull
        public String getSql() {
            String string = this.myData.getSql();
            if (string == null) {
                PreparedStatementHolder.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "0";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$PreparedStatementHolder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$PreparedStatementHolder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSql";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class RegularStatementHolder
    implements StatementHolder<Statement> {
        private final String mySql;
        private final boolean myScroll;
        private final DataRequest myRequest;
        private ResultSet myResultSet;

        RegularStatementHolder(@NotNull String sql, DataRequest request, boolean scroll) {
            if (JdbcEngine.this == null) {
                RegularStatementHolder.$$$reportNull$$$0(0);
            }
            if (sql == null) {
                RegularStatementHolder.$$$reportNull$$$0(1);
            }
            if (request == null) {
                RegularStatementHolder.$$$reportNull$$$0(2);
            }
            this.mySql = sql;
            this.myScroll = scroll;
            this.myRequest = request;
        }

        @Override
        @NotNull
        public Statement create(@NotNull DatabaseConnection connection) throws Exception {
            if (connection == null) {
                RegularStatementHolder.$$$reportNull$$$0(3);
            }
            Statement statement = JdbcEngine.this.openStatement(connection, this.myScroll);
            if (statement == null) {
                RegularStatementHolder.$$$reportNull$$$0(4);
            }
            return statement;
        }

        @Override
        public boolean execute(@NotNull Statement statement) throws Exception {
            if (statement == null) {
                RegularStatementHolder.$$$reportNull$$$0(5);
            }
            if (this.myRequest instanceof ConsoleDataRequest && ((ConsoleDataRequest)this.myRequest).resultType instanceof SqlTableType) {
                this.myResultSet = statement.executeQuery(this.mySql);
                return this.myResultSet != null;
            }
            return statement.execute(this.mySql);
        }

        @Override
        @Nullable
        public ResultSet getResultSet() {
            return this.myResultSet;
        }

        @Override
        @NotNull
        public String getSql() {
            String string = this.mySql;
            if (string == null) {
                RegularStatementHolder.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "0";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sql";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$RegularStatementHolder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$RegularStatementHolder";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSql";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface StatementHolder<T extends Statement> {
        @NotNull
        public T create(@NotNull DatabaseConnection var1) throws Exception;

        public boolean execute(@NotNull T var1) throws Exception;

        @Nullable
        public ResultSet getResultSet();

        @NotNull
        public String getSql();
    }

    private static class MyContext
    extends DataRequest.TxContext {
        private final JdbcEngine myEngine;
        final SearchPath startPath;
        final boolean startedTransaction;

        MyContext(@NotNull JdbcEngine engine, @NotNull DataRequest request, SearchPath startPath, boolean startedTransaction) {
            if (engine == null) {
                MyContext.$$$reportNull$$$0(0);
            }
            if (request == null) {
                MyContext.$$$reportNull$$$0(1);
            }
            super(engine, request, engine.myTxMarker);
            this.myEngine = engine;
            this.startPath = startPath;
            this.startedTransaction = startedTransaction;
        }

        @Override
        public void reportException(@NotNull Throwable th, Object parameter) {
            if (th == null) {
                MyContext.$$$reportNull$$$0(2);
            }
            LocalDataSource dataSource = this.myEngine.getDataSource();
            if (th instanceof ProcessCanceledException) {
                return;
            }
            String message = JdbcEngine.getErrorMessage(th, dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource));
            this.myEngine.getDataAuditor().error(this, message, th instanceof EngineWarningException ? th : null);
        }

        @Override
        @Nullable
        public SearchPath getSearchPath() {
            return this.myEngine.getSearchPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "engine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "th";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$MyContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reportException";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnsafeUpdateRolledBackException
    extends Exception {
        public UnsafeUpdateRolledBackException(String message) {
            super(message);
        }
    }

    private static class LastPageHandler
    implements DataConsumer {
        private final DataConsumer delegate;
        private int resultSetIndex;
        private DataConsumer.Column[] columnInfos;
        private RowsCyclicBuffer myBuffer;

        public LastPageHandler(DataConsumer handler, int start, int size) {
            this.delegate = handler;
            this.myBuffer = new RowsCyclicBuffer(Math.max(size, -start));
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] infos, int firstRowNum) {
            if (context == null) {
                LastPageHandler.$$$reportNull$$$0(0);
            }
            this.resultSetIndex = resultSetIndex;
            this.columnInfos = infos;
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                LastPageHandler.$$$reportNull$$$0(1);
            }
            this.myBuffer.addRows(rows);
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            List<DataConsumer.Row> rows;
            if (context == null) {
                LastPageHandler.$$$reportNull$$$0(2);
            }
            if ((rows = this.myBuffer.getRows()).isEmpty()) {
                this.delegate.setColumns(context, this.resultSetIndex, this.columnInfos, 0);
                this.delegate.afterLastRowAdded(context, 0);
                return;
            }
            this.delegate.setColumns(context, this.resultSetIndex, this.columnInfos, rows.get((int)0).rowNum);
            this.delegate.addRows(context, rows);
            this.delegate.afterLastRowAdded(context, total);
        }

        public int getRowCount() {
            return this.myBuffer.getRows().size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "context";
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$LastPageHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class RowsCyclicBuffer {
            private final DataConsumer.Row[] myBuffer;
            private int myFirstIdx = 0;
            private int myLastIdx = -1;

            public RowsCyclicBuffer(int bufferSize) {
                this.myBuffer = new DataConsumer.Row[bufferSize];
            }

            public void addRows(@NotNull Iterable<DataConsumer.Row> rows) {
                if (rows == null) {
                    RowsCyclicBuffer.$$$reportNull$$$0(0);
                }
                for (DataConsumer.Row row : rows) {
                    if (this.myLastIdx != -1 && this.nextIdx(this.myLastIdx) == this.myFirstIdx) {
                        this.myFirstIdx = this.nextIdx(this.myFirstIdx);
                    }
                    this.myLastIdx = this.nextIdx(this.myLastIdx);
                    this.myBuffer[this.myLastIdx] = row;
                }
            }

            @NotNull
            public List<DataConsumer.Row> getRows() {
                if (this.myLastIdx == -1) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        RowsCyclicBuffer.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                if (this.myFirstIdx == 0) {
                    List list = ContainerUtil.newArrayList((Object[])this.myBuffer, (int)0, (int)(this.myLastIdx + 1));
                    if (list == null) {
                        RowsCyclicBuffer.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                ArrayList rows = ContainerUtil.newArrayListWithCapacity((int)this.myBuffer.length);
                ImmutableList bufferAsList = ContainerUtil.immutableList((Object[])this.myBuffer);
                rows.addAll(bufferAsList.subList(this.myFirstIdx, this.myBuffer.length));
                rows.addAll(bufferAsList.subList(0, this.myLastIdx + 1));
                ArrayList arrayList = rows;
                if (arrayList == null) {
                    RowsCyclicBuffer.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            private int nextIdx(int idx) {
                return (idx + 1) % this.myBuffer.length;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rows";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRows";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "addRows";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static enum State {
        IDLE,
        RUNNING,
        STREAMING,
        CANCELED;

    }
}

