/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.restore.pg;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationBase;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.PostgresConfigurationBase;
import com.intellij.database.cli.argument.CommonPgArguments;
import com.intellij.database.cli.restore.pg.PgRestoreArguments;
import com.intellij.database.cli.restore.pg.PgRestoreArgumentsGroup;
import com.intellij.database.cli.restore.pg.PgRestoreDialogValidator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgRestoreConfiguration
extends PostgresConfigurationBase {
    public static final PgRestoreConfiguration INSTANCE = new PgRestoreConfiguration();
    private static final MyFileSearcher FILE_SEARCHER = new MyFileSearcher();

    private PgRestoreConfiguration() {
        super(PgRestoreArgumentsGroup.values(), (String[])ContainerUtil.ar((Object[])new String[]{""}), "PG_RESTORE_PROPERTIES", "pg_restore");
    }

    @Override
    @NotNull
    public Map<String, String> getInfoMap() {
        Map<String, String> map2 = super.getInfoMap();
        PgRestoreConfiguration.put(map2, "Restore definition of named index only", PgRestoreArguments.INDEX);
        PgRestoreConfiguration.put(map2, "Deprecated (ignored)", PgRestoreArguments.IGNORE_VERSION);
        PgRestoreConfiguration.put(map2, "List archive content", PgRestoreArguments.LIST);
        PgRestoreConfiguration.put(map2, "Restore matched triggers", PgRestoreArguments.TRIGGER);
        PgRestoreConfiguration.put(map2, "Restore only listed elements", PgRestoreArguments.USE_LIST);
        PgRestoreConfiguration.put(map2, "Restore the named function only", PgRestoreArguments.FUNCTION);
        PgRestoreConfiguration.put(map2, "Disable triggers", PgRestoreArguments.DISABLE_TRIGGERS);
        PgRestoreConfiguration.put(map2, "Disable triggers", "--no-data-for-failed-tables");
        PgRestoreConfiguration.put(map2, "Exit on error", PgRestoreArguments.EXIT_ON_ERROR);
        PgRestoreConfiguration.put(map2, "Use conditional commands", "--if-exists");
        PgRestoreConfiguration.put(map2, "Restore only the data", CommonPgArguments.DATA_ONLY);
        PgRestoreConfiguration.put(map2, "Clean database before restore", CommonPgArguments.CLEAN_DATABASE);
        PgRestoreConfiguration.put(map2, "Create database before restore", CommonPgArguments.CREATE_DATABASE);
        PgRestoreConfiguration.put(map2, "Input format", CommonPgArguments.FORMAT);
        PgRestoreConfiguration.put(map2, "Restore only matched schemas", CommonPgArguments.SCHEMA);
        PgRestoreConfiguration.put(map2, "Restore only data definition", CommonPgArguments.SCHEMA_ONLY);
        PgRestoreConfiguration.put(map2, "Restore matched tables", CommonPgArguments.TABLE);
        PgRestoreConfiguration.put(map2, "Don't restore security labels", "--no-security-labels");
        PgRestoreConfiguration.put(map2, "Restore only matched section", CommonPgArguments.SECTION);
        Map<String, String> map3 = map2;
        if (map3 == null) {
            PgRestoreConfiguration.$$$reportNull$$$0(0);
        }
        return map3;
    }

    @Override
    @NotNull
    public String getPartOfValidationOut() {
        if ("pg_restore" == null) {
            PgRestoreConfiguration.$$$reportNull$$$0(1);
        }
        return "pg_restore";
    }

    @Override
    @Nullable
    public String getDefaultSearchPath() {
        String path = super.getDefaultSearchPath();
        return path == null ? null : path + "/pg_restore";
    }

    @Override
    @NotNull
    public CliConfiguration.CliParameterSearcher getFileParameterSearcher() {
        MyFileSearcher myFileSearcher = FILE_SEARCHER;
        if (myFileSearcher == null) {
            PgRestoreConfiguration.$$$reportNull$$$0(2);
        }
        return myFileSearcher;
    }

    @Override
    @NotNull
    public CliDialogValidator getValidator() {
        PgRestoreDialogValidator pgRestoreDialogValidator = new PgRestoreDialogValidator();
        if (pgRestoreDialogValidator == null) {
            PgRestoreConfiguration.$$$reportNull$$$0(3);
        }
        return pgRestoreDialogValidator;
    }

    @Override
    @NotNull
    public List<String> getParameterizableArguments() {
        List list = ContainerUtil.concat((List)ContainerUtil.list((Object[])new String[]{"-I", "-L"}), super.getParameterizableArguments());
        if (list == null) {
            PgRestoreConfiguration.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public CliConfiguration.Operation getOperation() {
        CliConfiguration.Operation operation = CliConfiguration.Operation.RESTORE;
        if (operation == null) {
            PgRestoreConfiguration.$$$reportNull$$$0(5);
        }
        return operation;
    }

    @Override
    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer() {
        DatabaseObjectsPreparer databaseObjectsPreparer = super.getObjectsPreparer().mapAppend((Function<DbElement, DbElement>)((Function)e -> (DbElement)DasUtil.getParentOfKind((DasObject)e, (ObjectKind)ObjectKind.DATABASE, (boolean)false))).onlyIfSingleElement((Condition<DbElement>)((Condition)e -> e instanceof DbDataSource)).filter((Condition<DbElement>)Conditions.alwaysFalse()).requireNotEmpty().finish().endIf().onlyIfMoreThanOnce((Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).filter((Condition<DbElement>)Conditions.alwaysFalse()).finish().endIf().onlyIfMoreThanOnce((Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA)).filter((Condition<DbElement>)Conditions.or((Condition)DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA), (Condition)DasUtil.byKind((ObjectKind)ObjectKind.DATABASE))).finish().endIf().mapAppend((Function<DbElement, DbElement>)((Function)e -> (DbElement)DasUtil.getParentOfKind((DasObject)e, (ObjectKind)ObjectKind.SCHEMA, (boolean)false))).onlyIfMoreThanOnce((Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA)).filter((Condition<DbElement>)Conditions.not((Condition)DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA))).endIf().finish();
        if (databaseObjectsPreparer == null) {
            PgRestoreConfiguration.$$$reportNull$$$0(6);
        }
        return databaseObjectsPreparer;
    }

    @Override
    @NotNull
    public CliConfiguration.CliBuilder getCliBuilder(@NotNull Project project) {
        if (project == null) {
            PgRestoreConfiguration.$$$reportNull$$$0(7);
        }
        MyBuilder myBuilder = new MyBuilder(this.getParameterProcessor(), project, this.getOperation(), this.getName(), this.getEnvironmentVarName());
        if (myBuilder == null) {
            PgRestoreConfiguration.$$$reportNull$$$0(8);
        }
        return myBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/restore/pg/PgRestoreConfiguration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartOfValidationOut";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileParameterSearcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterizableArguments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsPreparer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/restore/pg/PgRestoreConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCliBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCliBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyBuilder
    extends CliConfigurationBase.CliBuilderBase {
        MyBuilder(@NotNull CliConfiguration.CliParameterProcessor processor, @NotNull Project project, @NotNull CliConfiguration.Operation operation, @NotNull String name, @NotNull String envName) {
            if (processor == null) {
                MyBuilder.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyBuilder.$$$reportNull$$$0(1);
            }
            if (operation == null) {
                MyBuilder.$$$reportNull$$$0(2);
            }
            if (name == null) {
                MyBuilder.$$$reportNull$$$0(3);
            }
            if (envName == null) {
                MyBuilder.$$$reportNull$$$0(4);
            }
            super(processor, project, operation, name, envName);
        }

        @Override
        @NotNull
        protected List<String> getArguments(@NotNull List<String> parameterizable, @NotNull String command) {
            String file;
            if (parameterizable == null) {
                MyBuilder.$$$reportNull$$$0(5);
            }
            if (command == null) {
                MyBuilder.$$$reportNull$$$0(6);
            }
            if ((file = FILE_SEARCHER.search(command, parameterizable)) == null) {
                List<String> list = super.getArguments(parameterizable, command);
                if (list == null) {
                    MyBuilder.$$$reportNull$$$0(7);
                }
                return list;
            }
            String withoutFile = command.replace(file, "");
            List<String> list = super.getArguments(parameterizable, withoutFile + " " + file);
            if (list == null) {
                MyBuilder.$$$reportNull$$$0(8);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterizable";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/restore/pg/PgRestoreConfiguration$MyBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/restore/pg/PgRestoreConfiguration$MyBuilder";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getArguments";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyFileSearcher
    implements CliConfiguration.CliParameterSearcher {
        private MyFileSearcher() {
        }

        @Override
        @Nullable
        public String search(@NotNull String command, @NotNull List<String> parameterizable) {
            if (command == null) {
                MyFileSearcher.$$$reportNull$$$0(0);
            }
            if (parameterizable == null) {
                MyFileSearcher.$$$reportNull$$$0(1);
            }
            List lexemes = ContainerUtil.subList(DbCliUtil.filteredLexemes(command, parameterizable), (int)1);
            return Optional.ofNullable(ContainerUtil.find((Iterable)lexemes, l -> l.isParameter())).map(l -> l.getText()).orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameterizable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/cli/restore/pg/PgRestoreConfiguration$MyFileSearcher";
            objectArray[2] = "search";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

