/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DataSourceConfigUtil {
    private DataSourceConfigUtil() {
    }

    public static void configureDetectedDataSources(@NotNull Project project, @NotNull DataSourceRegistry registry, boolean silentUpdate, boolean silentCreate) {
        if (project == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(0);
        }
        if (registry == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(1);
        }
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(project);
        Map map2 = JBIterable.from(storage.getDataSources()).toReverseMap(AbstractDataSource::getName);
        WriteAction.run(() -> {
            if (registry == null) {
                DataSourceConfigUtil.$$$reportNull$$$0(6);
            }
            for (LocalDataSource dataSource : registry.getDataSources()) {
                AbstractDataSource existing = (AbstractDataSource)((Object)((Object)map2.get(dataSource.getName())));
                boolean toUpdate = existing instanceof LocalDataSource;
                if (toUpdate && silentUpdate) {
                    DataSourceConfigUtil.copy(dataSource, (LocalDataSource)existing, false);
                    continue;
                }
                if (toUpdate || !silentCreate) continue;
                DataSourceConfigUtil.copy(dataSource, dataSource, true);
                storage.addDataSource(dataSource);
            }
        });
        DataSourceConfigUtil.runRegistryCallbacks(project, registry);
    }

    public static void runRegistryCallbacks(@NotNull Project project, @NotNull DataSourceRegistry registry) {
        if (project == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(2);
        }
        if (registry == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(3);
        }
        LinkedHashSet toUpdate = ContainerUtil.newLinkedHashSet();
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(project);
        Map map2 = JBIterable.from(storage.getDataSources()).toReverseMap(AbstractDataSource::getName);
        for (LocalDataSource dataSource : registry.getDataSources()) {
            DataSourceDetector.Callback callback = registry.getCallback(dataSource);
            AbstractDataSource existing = (AbstractDataSource)((Object)map2.get(dataSource.getName()));
            if (Comparing.equal((Object)((Object)existing), (Object)dataSource)) {
                if (callback != null) {
                    callback.onCreated((DatabaseSystem)dataSource);
                }
                toUpdate.add(dataSource);
                continue;
            }
            if (!(existing instanceof LocalDataSource)) continue;
            if (callback != null) {
                callback.onUpdated((DatabaseSystem)existing);
            }
            toUpdate.add((LocalDataSource)existing);
        }
        DataSourceConfigUtil.refreshTablesInBackground(project, toUpdate);
    }

    private static void copy(@NotNull LocalDataSource from, @NotNull LocalDataSource to, boolean justCreated) {
        if (from == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(4);
        }
        if (to == null) {
            DataSourceConfigUtil.$$$reportNull$$$0(5);
        }
        to.setUrl(from.getUrl());
        to.setClasspathElements(ContainerUtil.newArrayList(from.getClasspathElements()));
        if (to.getDatabaseDriver() == null || !to.getOwnClasspath().isEmpty()) {
            to.ensureDriverConfigured();
        }
        if (justCreated && StringUtil.isNotEmpty((String)from.getUsername()) && StringUtil.isNotEmpty((String)from.getPassword())) {
            Credentials credentials = new Credentials(from.getUsername(), from.getPassword());
            DatabaseCredentials.getInstance().setCredentials(to, credentials);
        }
    }

    public static void refreshTablesInBackground(Project project, Collection<? extends LocalDataSource> dataSources2) {
        for (LocalDataSource localDataSource : dataSources2) {
            DataSourceUiUtil.performAutoSyncTask(project, localDataSource);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/autoconfig/DataSourceConfigUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureDetectedDataSources";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runRegistryCallbacks";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "copy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$configureDetectedDataSources$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

