/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public class SelectRowAction
extends DumbAwareAction
implements GridAction {
    private static final String TEXT = "Select Row";

    public SelectRowAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(AnActionEvent e) {
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        int selectedRows = SelectRowAction.getSelectedRowsCount(grid);
        boolean enabled = selectedRows > 0 && ((DataGrid)ObjectUtils.assertNotNull((Object)grid)).getVisibleColumns().size() > 0;
        e.getPresentation().setText(selectedRows > 1 ? StringUtil.pluralize((String)TEXT) : TEXT);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        if (SelectRowAction.getSelectedRowsCount(grid) == 0 || ((DataGrid)ObjectUtils.assertNotNull((Object)grid)).getVisibleColumns().size() == 0) {
            return;
        }
        ((DataGrid)ObjectUtils.assertNotNull((Object)grid)).getSelectionModel().selectWholeRow();
    }

    private static int getSelectedRowsCount(@Nullable DataGrid grid) {
        if (grid == null) {
            return 0;
        }
        SelectionModel model = grid.getSelectionModel();
        return grid.isTransposed() ? model.getSelectedColumnCount() : model.getSelectedRowCount();
    }
}

