/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DefinitionProvider;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.scripting.CustomScriptingOptions;
import com.intellij.database.scripting.DefaultScriptingOptions;
import com.intellij.database.scripting.ScriptGeneratorTool;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingOption;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.vendors.DefinitionProviderImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateSqlActions {
    private static final ScriptingOptions SCRIPTING_OPTIONS_FOR_CLIPBOARD = DefaultScriptingOptions.INSTANCE;
    private static final ScriptingOptions SCRIPTING_OPTIONS_FOR_CONSOLE = new CustomScriptingOptions((Map<ScriptingOption<?>, ? extends Object>)ImmutableMap.of(ScriptingOptionStatic.CREATE_OR_REPLACE, (Object)true, ScriptingOptionStatic.CREATE_IF_NOT_EXISTS, (Object)true));

    @NotNull
    private static JBIterable<DbElement> getElements(AnActionEvent e, boolean scriptableOnly) {
        JBIterable result2 = DatabaseView.getSelectedElements(e.getDataContext(), (Condition<DatabaseStructure.Group>)((Condition)o -> o instanceof DatabaseStructure.FamilyGroup && ((DatabaseStructure.FamilyGroup)o).dasParent instanceof DasNamespace));
        JBIterable jBIterable = scriptableOnly ? result2.filter(GenerateSqlActions::isScriptable) : result2;
        if (jBIterable == null) {
            GenerateSqlActions.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    public static CompletionStage<Void> generateDbDdl(@NotNull DefinitionProvider provider, @NotNull List<DbElement> objects, @NotNull ErrorHandler handler, @NotNull StringBuilder builder, boolean markDb) {
        List<Object> current;
        DbElement first;
        LocalDataSource dataSource;
        if (provider == null) {
            GenerateSqlActions.$$$reportNull$$$0(1);
        }
        if (objects == null) {
            GenerateSqlActions.$$$reportNull$$$0(2);
        }
        if (handler == null) {
            GenerateSqlActions.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            GenerateSqlActions.$$$reportNull$$$0(4);
        }
        LocalDataSource localDataSource = dataSource = (first = (DbElement)ContainerUtil.getFirstItem(objects)) == null ? null : DbImplUtil.getMaybeLocalDataSource((DatabaseSystem)first.getDataSource());
        if (dataSource == null) {
            return CompletableFuture.completedFuture(null);
        }
        ObjectPath path = ObjectPath.of((DasObject)DasUtil.getNamespace((DasObject)first));
        ArrayList rest = ContainerUtil.newArrayList();
        if (JdbcUrlParserUtil.isDatabaseBounded(dataSource)) {
            current = ContainerUtil.newArrayList();
            for (DbElement object : objects) {
                (JdbcUrlParserUtil.outOfBounds(dataSource, path, ObjectPath.of((DasObject)object)) ? rest : current).add(object);
            }
        } else {
            current = objects;
        }
        return DatabaseConnectionManager.getInstance().build(first.getProject(), dataSource).setDestination(path).async(connection -> {
            if (builder == null) {
                GenerateSqlActions.$$$reportNull$$$0(20);
            }
            if (provider == null) {
                GenerateSqlActions.$$$reportNull$$$0(21);
            }
            if (!rest.isEmpty() || markDb) {
                builder.append("-- Database ").append(DasUtil.getCatalog((DasObject)first)).append("\n");
            }
            provider.load(current, connection, builder);
            return null;
        }, handler).thenComposeAsync(r -> {
            if (provider == null) {
                GenerateSqlActions.$$$reportNull$$$0(17);
            }
            if (handler == null) {
                GenerateSqlActions.$$$reportNull$$$0(18);
            }
            if (builder == null) {
                GenerateSqlActions.$$$reportNull$$$0(19);
            }
            return rest.isEmpty() ? CompletableFuture.completedFuture(null) : GenerateSqlActions.generateDbDdl(provider, rest, handler, builder, true);
        });
    }

    private static boolean isScriptable(@Nullable DbElement element) {
        BasicElement e;
        if (element == null) {
            return false;
        }
        if (element instanceof DasSchemaChild) {
            return true;
        }
        Object delegate = element.getDelegate();
        return delegate != null && delegate instanceof BasicElement && (e = (BasicElement)delegate) instanceof BasicScriptable;
    }

    @NotNull
    private static String doGenerateDDL(@NotNull Collection<DbElement> selectedElements, boolean forConsole) {
        String script2;
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(5);
        }
        ArrayList<BasicElement> list1 = new ArrayList<BasicElement>(selectedElements.size());
        ArrayList<DbElement> list2 = new ArrayList<DbElement>(selectedElements.size());
        for (DbElement e : selectedElements) {
            Object d = e.getDelegate();
            if (d != null && d instanceof BasicScriptable) {
                list1.add((BasicScriptable)d);
                continue;
            }
            if (d instanceof LocalDataSource) {
                LocalDataSource lds = (LocalDataSource)d;
                DasModel m = lds.getModel();
                if (!(m instanceof BasicModel)) continue;
                list1.add(((BasicModel)m).getRoot());
                continue;
            }
            list2.add(e);
        }
        String script1 = list1.isEmpty() ? null : GenerateSqlActions.doGenerateDDLUsingScriptingService(list1, forConsole);
        String string = script2 = list2.isEmpty() ? null : GenerateSqlActions.doGenerateDDLUsingDDLBuilder(list2);
        if (script1 != null && script2 == null) {
            String string2 = script1;
            if (string2 == null) {
                GenerateSqlActions.$$$reportNull$$$0(6);
            }
            return string2;
        }
        if (script2 != null && script1 == null) {
            String string3 = script2;
            if (string3 == null) {
                GenerateSqlActions.$$$reportNull$$$0(7);
            }
            return string3;
        }
        if (script1 != null && script2 != null) {
            String string4 = script1 + "\n\n" + script2;
            if (string4 == null) {
                GenerateSqlActions.$$$reportNull$$$0(8);
            }
            return string4;
        }
        if ("" == null) {
            GenerateSqlActions.$$$reportNull$$$0(9);
        }
        return "";
    }

    @NotNull
    private static String doGenerateDDLUsingScriptingService(@NotNull Collection<BasicElement> selectedElements, boolean forConsole) {
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(10);
        }
        Map<BasicModel, List<BasicElement>> groupedByModels = ModelFun.groupByModel(selectedElements);
        StringBuilder b = new StringBuilder();
        for (Map.Entry<BasicModel, List<BasicElement>> entry : groupedByModels.entrySet()) {
            List elements;
            BasicModel m = entry.getKey();
            String text2 = GenerateSqlActions.doGenerateDDLUsingScriptingService(m, elements = JBIterable.from((Iterable)entry.getValue()).toList(), forConsole);
            if (text2.length() <= 0) continue;
            if (b.length() > 0) {
                b.append("\n\n");
            }
            b.append(text2);
        }
        String string = b.toString();
        if (string == null) {
            GenerateSqlActions.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String doGenerateDDLUsingScriptingService(@NotNull BasicModel model, @NotNull Iterable<? extends BasicElement> selectedElements, boolean forConsole) {
        if (model == null) {
            GenerateSqlActions.$$$reportNull$$$0(12);
        }
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(13);
        }
        ScriptingFactory scriptingFactory = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
        ScriptingService scriptingService = scriptingFactory.createScriptingService(model, null);
        scriptingService.setOptions(forConsole ? SCRIPTING_OPTIONS_FOR_CONSOLE : SCRIPTING_OPTIONS_FOR_CLIPBOARD);
        JBIterable selection = JBIterable.from(selectedElements);
        JBIterable visibleDatabasesOfRoot = selection.filter(BasicMultiDatabaseRoot.class).flatten(r -> r.getDatabases()).filter(BasicDatabase.class).filter(BasicNamespace::isVisible);
        JBIterable databasesSchemata = visibleDatabasesOfRoot.append((Iterable)selection.filter(BasicDatabase.class).filter(db -> !visibleDatabasesOfRoot.contains(db))).flatten(db -> db.getSchemas()).filter(BasicSchema.class).filter(s -> !s.isNameSurrogate()).filter(BasicMateNamespace::isVisible);
        JBIterable explicitSchemata = selection.filter(BasicSchema.class).filter(s -> !databasesSchemata.contains(s));
        List schemata = databasesSchemata.append((Iterable)explicitSchemata).toList();
        scriptingService.makeScript(ScriptingTask.CREATE_COMPLETE, schemata);
        List otherObjects = selection.filter(BasicScriptable.class).filter(o -> !(o instanceof BasicSchemaObject) || !schemata.contains(o.getSchema())).toList();
        scriptingService.makeScript(ScriptingTask.CREATE_COMPLETE, otherObjects, true);
        String string = scriptingService.getScriptText();
        if (string == null) {
            GenerateSqlActions.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String doGenerateDDLUsingDDLBuilder(@NotNull Collection<DbElement> selectedElements) {
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(15);
        }
        final THashSet visited = ContainerUtil.newTroveSet();
        DdlBuilder builder = new DdlBuilder(){

            @Override
            @NotNull
            public DdlBuilder element(@NotNull DasObject element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!visited.add((Object)element)) {
                    1 v0 = this;
                    if (v0 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return v0;
                }
                if (element.getKind() == ObjectKind.SCHEMA) {
                    JBIterable tables = element.getDasChildren(null).filter(DbTable.class);
                    tables.addAllTo((Collection)visited);
                    this.tables((Iterable<? extends DasTable>)tables);
                }
                DdlBuilder ddlBuilder = super.element(element);
                if (ddlBuilder == null) {
                    1.$$$reportNull$$$0(2);
                }
                return ddlBuilder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        DbElement item = (DbElement)ContainerUtil.getFirstItem(selectedElements);
        if (item != null) {
            builder.configureFor(item);
        }
        for (DbElement e : selectedElements) {
            int length = builder.length();
            String s = DbImplUtil.loadDefinitionFromStorage(e);
            if (s != null) {
                builder.plain(StringUtil.trimEnd((String)StringUtil.trimTrailing((String)s), (char)';'));
            } else {
                builder.element((DasObject)e);
            }
            if (builder.length() <= length) continue;
            builder.newStatement();
        }
        String string = builder.getStatement();
        if (string == null) {
            GenerateSqlActions.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions";
                break;
            }
            case 1: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedElements";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateDDL";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateDDLUsingScriptingService";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateDDLUsingDDLBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateDbDdl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDDL";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDDLUsingScriptingService";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDDLUsingDDLBuilder";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateDbDdl$2";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateDbDdl$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ShowSqlGeneratorAction
    extends DumbAwareAction {
        ShowSqlGeneratorAction() {
        }

        public void update(AnActionEvent e) {
            DbElement single = (DbElement)GenerateSqlActions.getElements(e, true).single();
            boolean enabled = single != null && single.getDelegate() instanceof BasicScriptable;
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || e.isFromActionToolbar());
        }

        public void actionPerformed(AnActionEvent e) {
            BasicScriptable delegate;
            DbElement element = (DbElement)GenerateSqlActions.getElements(e, true).single();
            BasicScriptable basicScriptable = delegate = element == null ? null : (BasicScriptable)ObjectUtils.tryCast((Object)element.getDelegate(), BasicScriptable.class);
            if (delegate == null) {
                return;
            }
            BasicModel model = (BasicModel)ObjectUtils.notNull((Object)delegate.getModel());
            ScriptGeneratorTool.INSTANCE.show(element.getProject(), model, Collections.singleton(delegate));
        }
    }

    static class OpenDdlInConsoleAction
    extends DumbAwareAction {
        OpenDdlInConsoleAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(!GenerateSqlActions.getElements(e, true).isEmpty());
        }

        public void actionPerformed(AnActionEvent e) {
            List elements = GenerateSqlActions.getElements(e, true).unique().toList();
            String ddl = GenerateSqlActions.doGenerateDDL(elements, true);
            if (StringUtil.isEmpty((String)ddl)) {
                return;
            }
            DbUIUtil.openInConsole((DbElement)elements.get(0), ddl);
        }
    }

    static class CopyDdlAction
    extends DumbAwareAction {
        CopyDdlAction() {
        }

        public void update(AnActionEvent e) {
            boolean enabled = !GenerateSqlActions.getElements(e, false).isEmpty();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || e.isFromActionToolbar());
        }

        public void actionPerformed(AnActionEvent e) {
            List objects = GenerateSqlActions.getElements(e, false).unique().toList();
            if (objects.isEmpty()) {
                return;
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(GenerateSqlActions.doGenerateDDL(objects, false)));
        }
    }

    static class CopyDdlFromDbAction
    extends DumbAwareAction {
        CopyDdlFromDbAction() {
        }

        public void update(AnActionEvent e) {
            JBIterable<DbElement> objects = this.getObjects(e.getDataContext());
            JBIterable<DbElement> supported = this.filterSupported(objects);
            boolean visible = !objects.isEmpty();
            boolean enabled = visible && !supported.isEmpty();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(visible);
        }

        public void actionPerformed(AnActionEvent e) {
            JBIterable<DbElement> objects = this.getObjects(e.getDataContext());
            DbElement first = (DbElement)objects.first();
            DefinitionProvider provider = this.getProvider(first);
            if (provider == null || first == null) {
                return;
            }
            ErrorHandler handler = new ErrorHandler();
            StringBuilder builder = new StringBuilder();
            ProgressIndicatorEx indicator = AsyncUtil.createBackgroundIndicator(first.getProject(), "Loading Sources");
            AsyncUtil.runTask(() -> GenerateSqlActions.generateDbDdl(provider, objects.filter(provider::isSupported).toList(), handler, builder, false).whenCompleteAsync((s, throwable) -> {
                if (throwable != null) {
                    DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)first.getDataSource());
                    AsyncUtil.addUnhandledError(handler, throwable, StringUtil.notNullize((String)e.getPresentation().getText()), dialect.getFamilyId());
                    DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(handler.getSummary(), MessageType.ERROR).notify(e.getProject());
                } else {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(builder.toString()));
                }
            }, AsyncUtil.EDT_EXECUTOR), indicator);
        }

        @NotNull
        JBIterable<DbElement> getObjects(DataContext context) {
            JBIterable objects = JBIterable.from(DatabaseView.getSelectedElements(context, DbElement.class));
            DbElement first = (DbElement)objects.first();
            if (first == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    CopyDdlFromDbAction.$$$reportNull$$$0(0);
                }
                return jBIterable;
            }
            DbDataSource dataSource = first.getDataSource();
            JBIterable jBIterable = objects.filter(o -> o != dataSource && o.getDataSource() == dataSource);
            if (jBIterable == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        @NotNull
        JBIterable<DbElement> filterSupported(@NotNull JBIterable<DbElement> objects) {
            DefinitionProvider provider;
            if (objects == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(2);
            }
            JBIterable jBIterable = (provider = this.getProvider((DbElement)objects.first())) == null ? JBIterable.empty() : objects.filter(provider::isSupported);
            if (jBIterable == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        @Nullable
        DefinitionProvider getProvider(@Nullable DbElement first) {
            if (first == null) {
                return null;
            }
            LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DatabaseSystem)first.getDataSource());
            if (localDataSource == null) {
                return null;
            }
            return DefinitionProviderImpl.find(localDataSource);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlFromDbAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjects";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlFromDbAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterSupported";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "filterSupported";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

