/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.DatabaseTopics;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class DataBus {
    public static final ExtensionPointName<DataConsumer> CONSUMER_EP = ExtensionPointName.create((String)"com.intellij.database.dataConsumer");
    public static final ExtensionPointName<DataProducer> PRODUCER_EP = ExtensionPointName.create((String)"com.intellij.database.dataProducer");
    public static final ExtensionPointName<DataAuditor> AUDITOR_EP = ExtensionPointName.create((String)"com.intellij.database.dataAuditor");
    private static final NotNullLazyKey<DataBus, Project> INSTANCE_KEY = ServiceManager.createLazyKey(DataBus.class);
    private final MessageBus myMessageBus;
    private final AtomicInteger myUseCount;

    DataBus(@NotNull Project project) {
        if (project == null) {
            DataBus.$$$reportNull$$$0(0);
        }
        this.myUseCount = new AtomicInteger();
        this.myMessageBus = MessageBusFactory.newMessageBus((Object)this);
        Disposer.register((Disposable)project, (Disposable)this.newUseCountDisposable());
        for (DataConsumer dataConsumer : (DataConsumer[])Extensions.getExtensions(CONSUMER_EP)) {
            this.myMessageBus.connect().subscribe(DatabaseTopics.RESPONSE_TOPIC, (Object)dataConsumer);
        }
        for (DataProducer dataProducer : (DataProducer[])Extensions.getExtensions(PRODUCER_EP)) {
            this.myMessageBus.connect().subscribe(DatabaseTopics.REQUEST_TOPIC, (Object)dataProducer);
        }
        for (DataAuditor dataAuditor : (DataAuditor[])Extensions.getExtensions(AUDITOR_EP)) {
            this.myMessageBus.connect().subscribe(DatabaseTopics.AUDIT_TOPIC, (Object)dataAuditor);
        }
    }

    private static MessageBus getDataBusInner(@NotNull Project project) {
        if (project == null) {
            DataBus.$$$reportNull$$$0(1);
        }
        return ((DataBus)DataBus.INSTANCE_KEY.getValue((UserDataHolder)project)).myMessageBus;
    }

    @NotNull
    public static MessageBus newDataBusChild(@NotNull Project project, @NotNull String title, @NotNull Disposable parentDisposable) {
        if (project == null) {
            DataBus.$$$reportNull$$$0(2);
        }
        if (title == null) {
            DataBus.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            DataBus.$$$reportNull$$$0(4);
        }
        MessageBus messageBus = MessageBusFactory.newMessageBus((Object)title, (MessageBus)DataBus.getDataBusInner(project));
        Disposable useCountDisposer = ((DataBus)INSTANCE_KEY.getValue((UserDataHolder)project)).newUseCountDisposable();
        Disposer.register((Disposable)parentDisposable, (Disposable)useCountDisposer);
        Disposer.register((Disposable)parentDisposable, (Disposable)messageBus);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)parentDisposable);
        MessageBus messageBus2 = messageBus;
        if (messageBus2 == null) {
            DataBus.$$$reportNull$$$0(5);
        }
        return messageBus2;
    }

    @NotNull
    private Disposable newUseCountDisposable() {
        this.myUseCount.incrementAndGet();
        Disposable disposable = new Disposable(){

            public void dispose() {
                if (DataBus.this.myUseCount.decrementAndGet() == 0) {
                    Disposer.dispose((Disposable)DataBus.this.myMessageBus);
                }
            }
        };
        if (disposable == null) {
            DataBus.$$$reportNull$$$0(6);
        }
        return disposable;
    }

    @NotNull
    public static Producing shortCircuit(@NotNull Consuming messageBus) {
        if (messageBus == null) {
            DataBus.$$$reportNull$$$0(7);
        }
        Producing producing = (Producing)((Object)messageBus);
        if (producing == null) {
            DataBus.$$$reportNull$$$0(8);
        }
        return producing;
    }

    public static void addRootAuditor(@NotNull Project project, DataAuditor auditor, Disposable disposable) {
        if (project == null) {
            DataBus.$$$reportNull$$$0(9);
        }
        DataBus.getDataBusInner(project).connect(disposable).subscribe(DatabaseTopics.AUDIT_TOPIC, (Object)auditor);
    }

    @NotNull
    public static DataAuditor getRootAuditor(@NotNull Project project) {
        if (project == null) {
            DataBus.$$$reportNull$$$0(10);
        }
        DataAuditor dataAuditor = (DataAuditor)DataBus.getDataBusInner(project).syncPublisher(DatabaseTopics.AUDIT_TOPIC);
        if (dataAuditor == null) {
            DataBus.$$$reportNull$$$0(11);
        }
        return dataAuditor;
    }

    @NotNull
    public static MessageBus getDataBus(@NotNull Project project) {
        if (project == null) {
            DataBus.$$$reportNull$$$0(12);
        }
        MessageBus messageBus = DataBus.getDataBusInner(project);
        if (messageBus == null) {
            DataBus.$$$reportNull$$$0(13);
        }
        return messageBus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/DataBus";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/DataBus";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newDataBusChild";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newUseCountDisposable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "shortCircuit";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootAuditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataBus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDataBusInner";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newDataBusChild";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shortCircuit";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRootAuditor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRootAuditor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDataBus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Producing {
        public DataConsumer getDataConsumer();

        public DataAuditor getDataAuditor();

        public void addProducer(@NotNull DataProducer var1);

        public void beforeProducerRemove(@NotNull DataProducer var1);

        public void afterProducerRemove(@NotNull DataProducer var1);
    }

    public static interface Consuming {
        public Consuming filterFor(@NotNull DataRequest.OwnerEx var1);

        public DataProducer getDataProducer();

        public void addConsumer(@NotNull DataConsumer var1);

        public void addAuditor(@NotNull DataAuditor var1);
    }
}

