/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.codeInsight;

import com.intellij.javascript.testFramework.codeInsight.GenerateActionContext;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJsGenerateAction
extends AnAction {
    @NotNull
    public abstract String getHumanReadableDescription();

    public abstract boolean isEnabled(@NotNull GenerateActionContext var1);

    public abstract void actionPerformed(@NotNull GenerateActionContext var1);

    public final void actionPerformed(AnActionEvent e) {
        GenerateActionContext generateContext = AbstractJsGenerateAction.fetchContext(e.getDataContext());
        if (generateContext != null) {
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)generateContext.getJsFile())) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> generateContext.getEditor().getSelectionModel().removeSelection());
            this.actionPerformed(generateContext);
        }
    }

    public final void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        GenerateActionContext generateContext = AbstractJsGenerateAction.fetchContext(e.getDataContext());
        boolean enabled = generateContext != null && this.isEnabled(generateContext);
        presentation.setEnabledAndVisible(enabled);
        if (enabled) {
            presentation.setText(this.getHumanReadableDescription(), true);
        }
    }

    @Nullable
    private static GenerateActionContext fetchContext(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        JSFile jsFile = (JSFile)ObjectUtils.tryCast((Object)CommonDataKeys.PSI_FILE.getData(dataContext), JSFile.class);
        if (jsFile == null) {
            return null;
        }
        return new GenerateActionContext(jsFile, editor);
    }
}

