/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.integrate.IntegratedSelectedOptionsDialog;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.SvnIntegrateChangesTask;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class SvnIntegrateChangesActionPerformer
implements SelectBranchPopup.BranchSelectedCallback {
    private final SvnVcs myVcs;
    @NotNull
    private final MergerFactory myMergerFactory;
    private final SVNURL myCurrentBranch;

    public SvnIntegrateChangesActionPerformer(Project project, SVNURL currentBranchUrl, @NotNull MergerFactory mergerFactory) {
        if (mergerFactory == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(0);
        }
        this.myVcs = SvnVcs.getInstance(project);
        this.myCurrentBranch = currentBranchUrl;
        this.myMergerFactory = mergerFactory;
    }

    @Override
    public void branchSelected(Project project, SvnBranchConfigurationNew configuration, String url, long revision) {
        this.onBranchSelected(url, null, null);
    }

    public void onBranchSelected(String url, @Nullable String selectedLocalBranchPath, @Nullable String dialogTitle) {
        if (this.myCurrentBranch.toString().equals(url)) {
            SvnIntegrateChangesActionPerformer.showSameSourceAndTargetMessage();
        } else {
            Pair<WorkingCopyInfo, SVNURL> pair = this.selectWorkingCopy(url, selectedLocalBranchPath, dialogTitle);
            if (pair != null) {
                this.runIntegrate(url, (WorkingCopyInfo)pair.first, (SVNURL)pair.second);
            }
        }
    }

    @Nullable
    private Pair<WorkingCopyInfo, SVNURL> selectWorkingCopy(String url, @Nullable String selectedLocalBranchPath, @Nullable String dialogTitle) {
        return IntegratedSelectedOptionsDialog.selectWorkingCopy(this.myVcs.getProject(), this.myCurrentBranch, url, true, selectedLocalBranchPath, dialogTitle);
    }

    private void runIntegrate(@NotNull String url, @NotNull WorkingCopyInfo workingCopy, @NotNull SVNURL workingCopyUrl) {
        SVNURL sourceUrl;
        if (url == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(1);
        }
        if (workingCopy == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(2);
        }
        if (workingCopyUrl == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(3);
        }
        if ((sourceUrl = this.correctSourceUrl(url, workingCopyUrl.toString())) != null) {
            SvnIntegrateChangesTask integrateTask = new SvnIntegrateChangesTask(this.myVcs, workingCopy, this.myMergerFactory, sourceUrl, SvnBundle.message("action.Subversion.integrate.changes.messages.title", new Object[0]), this.myVcs.getSvnConfiguration().isMergeDryRun(), SVNPathUtil.tail((String)this.myCurrentBranch.toString()));
            integrateTask.queue();
        }
    }

    @Nullable
    private SVNURL correctSourceUrl(@NotNull String targetUrl, @NotNull String realTargetUrl) {
        if (targetUrl == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(4);
        }
        if (realTargetUrl == null) {
            SvnIntegrateChangesActionPerformer.$$$reportNull$$$0(5);
        }
        try {
            if (realTargetUrl.length() > targetUrl.length()) {
                if (realTargetUrl.startsWith(targetUrl)) {
                    return this.myCurrentBranch.appendPath(realTargetUrl.substring(targetUrl.length()), true);
                }
            } else if (realTargetUrl.equals(targetUrl)) {
                return this.myCurrentBranch;
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return null;
    }

    private static void showSameSourceAndTargetMessage() {
        Messages.showErrorDialog((String)SvnBundle.message("action.Subversion.integrate.changes.error.source.and.target.same.text", new Object[0]), (String)SvnBundle.message("action.Subversion.integrate.changes.messages.title", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergerFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingCopy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingCopyUrl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetUrl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realTargetUrl";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/integrate/SvnIntegrateChangesActionPerformer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runIntegrate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "correctSourceUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

