/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.info;

import java.io.File;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.lock.Lock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class Info
extends BaseNodeDescription {
    public static final String SCHEDULE_ADD = "add";
    private final File myFile;
    private final String myPath;
    private final SVNURL myURL;
    @NotNull
    private final SVNRevision myRevision;
    private final SVNURL myRepositoryRootURL;
    private final String myRepositoryUUID;
    private final SVNRevision myCommittedRevision;
    private final Date myCommittedDate;
    private final String myAuthor;
    @Nullable
    private final Lock myLock;
    private final boolean myIsRemote;
    private final String mySchedule;
    private final SVNURL myCopyFromURL;
    private final SVNRevision myCopyFromRevision;
    @Nullable
    private final File myConflictOldFile;
    @Nullable
    private final File myConflictNewFile;
    @Nullable
    private final File myConflictWrkFile;
    @Nullable
    private final File myPropConflictFile;
    private final Depth myDepth;
    @Nullable
    private final TreeConflictDescription myTreeConflict;

    @NotNull
    public static Info create(@NotNull SVNInfo info) {
        if (info == null) {
            Info.$$$reportNull$$$0(0);
        }
        Info result = info.isRemote() ? new Info(info.getPath(), info.getURL(), info.getRevision(), NodeKind.from(info.getKind()), info.getRepositoryUUID(), info.getRepositoryRootURL(), info.getCommittedRevision().getNumber(), info.getCommittedDate(), info.getAuthor(), Lock.create(info.getLock()), Depth.from(info.getDepth())) : new Info(info.getFile(), info.getURL(), info.getRepositoryRootURL(), info.getRevision().getNumber(), NodeKind.from(info.getKind()), info.getRepositoryUUID(), info.getCommittedRevision().getNumber(), Info.toString(info.getCommittedDate()), info.getAuthor(), info.getSchedule(), info.getCopyFromURL(), info.getCopyFromRevision().getNumber(), Info.getName(info.getConflictOldFile()), Info.getName(info.getConflictNewFile()), Info.getName(info.getConflictWrkFile()), Info.getName(info.getPropConflictFile()), Lock.create(info.getLock()), Depth.from(info.getDepth()), TreeConflictDescription.create(info.getTreeConflict()));
        Info info2 = result;
        if (info2 == null) {
            Info.$$$reportNull$$$0(1);
        }
        return info2;
    }

    /*
     * WARNING - void declaration
     */
    public Info(File file, SVNURL url, SVNURL rootURL, long revision, @NotNull NodeKind kind, String uuid, long committedRevision, String committedDate, String author, String schedule, SVNURL copyFromURL, long copyFromRevision, @Nullable String conflictOldFileName, @Nullable String conflictNewFileName, @Nullable String conflictWorkingFileName, @Nullable String propRejectFileName, @Nullable Lock lock, Depth depth, @Nullable TreeConflictDescription treeConflictDescription) {
        void depth2;
        void treeConflict;
        void lock2;
        if (kind == null) {
            Info.$$$reportNull$$$0(2);
        }
        super(kind);
        this.myFile = file;
        this.myURL = url;
        this.myRevision = SVNRevision.create((long)revision);
        this.myRepositoryUUID = uuid;
        this.myRepositoryRootURL = rootURL;
        this.myCommittedRevision = SVNRevision.create((long)committedRevision);
        this.myCommittedDate = committedDate != null ? SVNDate.parseDate((String)committedDate) : null;
        this.myAuthor = author;
        this.mySchedule = schedule;
        this.myCopyFromURL = copyFromURL;
        this.myCopyFromRevision = SVNRevision.create((long)copyFromRevision);
        this.myLock = lock2;
        this.myTreeConflict = treeConflict;
        this.myConflictOldFile = Info.resolveConflictFile(file, conflictOldFileName);
        this.myConflictNewFile = Info.resolveConflictFile(file, conflictNewFileName);
        this.myConflictWrkFile = Info.resolveConflictFile(file, conflictWorkingFileName);
        this.myPropConflictFile = Info.resolveConflictFile(file, propRejectFileName);
        this.myIsRemote = false;
        this.myDepth = depth2;
        this.myPath = null;
    }

    /*
     * WARNING - void declaration
     */
    public Info(String path, SVNURL url, @NotNull SVNRevision revision, @NotNull NodeKind kind, String uuid, SVNURL reposRootURL, long committedRevision, Date date, String author, @Nullable Lock lock, Depth depth) {
        void depth2;
        if (revision == null) {
            Info.$$$reportNull$$$0(3);
        }
        if (kind == null) {
            Info.$$$reportNull$$$0(4);
        }
        super(kind);
        this.myIsRemote = true;
        this.myURL = url;
        this.myRevision = revision;
        this.myRepositoryRootURL = reposRootURL;
        this.myRepositoryUUID = uuid;
        this.myCommittedDate = date;
        this.myCommittedRevision = SVNRevision.create((long)committedRevision);
        this.myAuthor = author;
        this.myLock = lock;
        this.myPath = path;
        this.myDepth = depth2;
        this.myFile = null;
        this.mySchedule = null;
        this.myCopyFromURL = null;
        this.myCopyFromRevision = null;
        this.myConflictOldFile = null;
        this.myConflictNewFile = null;
        this.myConflictWrkFile = null;
        this.myPropConflictFile = null;
        this.myTreeConflict = null;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public Date getCommittedDate() {
        return this.myCommittedDate;
    }

    public SVNRevision getCommittedRevision() {
        return this.myCommittedRevision;
    }

    @Nullable
    public File getConflictNewFile() {
        return this.myConflictNewFile;
    }

    @Nullable
    public File getConflictOldFile() {
        return this.myConflictOldFile;
    }

    @Nullable
    public File getConflictWrkFile() {
        return this.myConflictWrkFile;
    }

    @Nullable
    public TreeConflictDescription getTreeConflict() {
        return this.myTreeConflict;
    }

    public SVNRevision getCopyFromRevision() {
        return this.myCopyFromRevision;
    }

    public SVNURL getCopyFromURL() {
        return this.myCopyFromURL;
    }

    public File getFile() {
        return this.myFile;
    }

    public boolean isRemote() {
        return this.myIsRemote;
    }

    @NotNull
    public NodeKind getKind() {
        NodeKind nodeKind = this.myKind;
        if (nodeKind == null) {
            Info.$$$reportNull$$$0(5);
        }
        return nodeKind;
    }

    @Nullable
    public Lock getLock() {
        return this.myLock;
    }

    public String getPath() {
        return this.myPath;
    }

    @Nullable
    public File getPropConflictFile() {
        return this.myPropConflictFile;
    }

    public SVNURL getRepositoryRootURL() {
        return this.myRepositoryRootURL;
    }

    public String getRepositoryUUID() {
        return this.myRepositoryUUID;
    }

    @NotNull
    public SVNRevision getRevision() {
        SVNRevision sVNRevision = this.myRevision;
        if (sVNRevision == null) {
            Info.$$$reportNull$$$0(6);
        }
        return sVNRevision;
    }

    public String getSchedule() {
        return this.mySchedule;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    public Depth getDepth() {
        return this.myDepth;
    }

    @Nullable
    private static File resolveConflictFile(@Nullable File file, @Nullable String path) {
        return file != null && path != null ? new File(file.getParentFile(), path) : null;
    }

    @Nullable
    private static String getName(@Nullable File file) {
        return file != null ? file.getName() : null;
    }

    @Nullable
    private static String toString(@Nullable Date date) {
        return date != null ? date.toString() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/info/Info";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/info/Info";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

