/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class SvnCopyPathTracker {
    private static final Logger LOG = Logger.getInstance(SvnCopyPathTracker.class);
    @NotNull
    private String myCurrentPath;
    @NotNull
    private final SVNURL myRepositoryUrl;
    private boolean myHadChanged;

    public SvnCopyPathTracker(@NotNull SVNURL repositoryUrl, @NotNull String repositoryRelativeUrl) {
        if (repositoryUrl == null) {
            SvnCopyPathTracker.$$$reportNull$$$0(0);
        }
        if (repositoryRelativeUrl == null) {
            SvnCopyPathTracker.$$$reportNull$$$0(1);
        }
        this.myRepositoryUrl = repositoryUrl;
        this.myCurrentPath = repositoryRelativeUrl;
    }

    public void accept(@NotNull LogEntry entry) {
        if (entry == null) {
            SvnCopyPathTracker.$$$reportNull$$$0(2);
        }
        for (LogEntryPath entryPath : entry.getChangedPaths().values()) {
            if (entryPath == null || 'A' != entryPath.getType() || entryPath.getCopyPath() == null) continue;
            if (this.myCurrentPath.equals(entryPath.getPath())) {
                this.myHadChanged = true;
                this.myCurrentPath = entryPath.getCopyPath();
                return;
            }
            if (!SVNPathUtil.isAncestor((String)entryPath.getPath(), (String)this.myCurrentPath)) continue;
            this.myCurrentPath = SVNPathUtil.append((String)entryPath.getCopyPath(), (String)SVNPathUtil.getRelativePath((String)entryPath.getPath(), (String)this.myCurrentPath));
            this.myHadChanged = true;
            return;
        }
    }

    @Nullable
    public FilePath getFilePath(@NotNull SvnVcs vcs) throws SvnBindException {
        if (vcs == null) {
            SvnCopyPathTracker.$$$reportNull$$$0(3);
        }
        if (!this.myHadChanged) {
            return null;
        }
        SVNURL currentUrl = SvnUtil.append(this.myRepositoryUrl, this.myCurrentPath);
        File localPath = vcs.getSvnFileUrlMapping().getLocalPath(currentUrl);
        if (localPath == null) {
            LOG.info("Cannot find local path for url: " + currentUrl);
            return null;
        }
        return VcsUtil.getFilePath((File)localPath, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryUrl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryRelativeUrl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/history/SvnCopyPathTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFilePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

