/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public abstract class ElementWithBranchComparer {
    private static final Logger LOG = Logger.getInstance(ElementWithBranchComparer.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final SvnVcs myVcs;
    @NotNull
    protected final VirtualFile myVirtualFile;
    @NotNull
    protected final String myBranchUrl;
    protected final long myBranchRevision;
    protected SVNURL myElementUrl;

    ElementWithBranchComparer(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull String branchUrl, long branchRevision) {
        if (project == null) {
            ElementWithBranchComparer.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            ElementWithBranchComparer.$$$reportNull$$$0(1);
        }
        if (branchUrl == null) {
            ElementWithBranchComparer.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myVcs = SvnVcs.getInstance(this.myProject);
        this.myVirtualFile = virtualFile;
        this.myBranchUrl = branchUrl;
        this.myBranchRevision = branchRevision;
    }

    public void run() {
        new Task.Modal(this.myProject, this.getTitle(), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    ElementWithBranchComparer.this.beforeCompare();
                    ElementWithBranchComparer.this.myElementUrl = ElementWithBranchComparer.this.resolveElementUrl();
                    if (ElementWithBranchComparer.this.myElementUrl == null) {
                        ElementWithBranchComparer.this.reportNotFound();
                    } else {
                        ElementWithBranchComparer.this.compare();
                    }
                }
                catch (SVNCancelException ex) {
                    ElementWithBranchComparer.this.onCancel();
                }
                catch (SVNException ex) {
                    ElementWithBranchComparer.this.reportException(new SvnBindException(ex));
                }
                catch (SvnBindException ex) {
                    ElementWithBranchComparer.this.reportException(ex);
                }
                catch (VcsException ex) {
                    ElementWithBranchComparer.this.reportGeneralException((Exception)((Object)ex));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/svn/diff/ElementWithBranchComparer$1", "run"));
            }
        }.queue();
        this.showResult();
    }

    protected void beforeCompare() {
    }

    protected abstract void compare() throws VcsException;

    protected abstract void showResult();

    protected void onCancel() {
    }

    public abstract String getTitle();

    @Nullable
    protected SVNURL resolveElementUrl() throws SVNException {
        File file;
        SvnFileUrlMapping urlMapping = this.myVcs.getSvnFileUrlMapping();
        SVNURL fileUrl = urlMapping.getUrlForFile(file = VfsUtilCore.virtualToIoFile((VirtualFile)this.myVirtualFile));
        if (fileUrl == null) {
            return null;
        }
        RootUrlInfo rootMixed = urlMapping.getWcRootForUrl(fileUrl);
        if (rootMixed == null) {
            return null;
        }
        SVNURL thisBranchForUrl = SvnUtil.getBranchForUrl(this.myVcs, rootMixed.getVirtualFile(), fileUrl);
        if (thisBranchForUrl == null) {
            return null;
        }
        String relativePath = SVNPathUtil.getRelativePath((String)thisBranchForUrl.toString(), (String)fileUrl.toString());
        return SVNURL.parseURIEncoded((String)SVNPathUtil.append((String)this.myBranchUrl, (String)relativePath));
    }

    private void reportException(SvnBindException e) {
        if (e.contains(SVNErrorCode.RA_ILLEGAL_URL) || e.contains(SVNErrorCode.CLIENT_UNRELATED_RESOURCES) || e.contains(SVNErrorCode.RA_DAV_PATH_NOT_FOUND) || e.contains(SVNErrorCode.FS_NOT_FOUND) || e.contains(SVNErrorCode.ILLEGAL_TARGET)) {
            this.reportNotFound();
        } else {
            this.reportGeneralException((Exception)((Object)e));
        }
    }

    protected void reportGeneralException(Exception e) {
        WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showMessageDialog((Project)this.myProject, (String)e.getMessage(), (String)SvnBundle.message("compare.with.branch.error.title", new Object[0]), (Icon)Messages.getErrorIcon()), null, (Project)this.myProject);
        LOG.info((Throwable)e);
    }

    private void reportNotFound() {
        WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showMessageDialog((Project)this.myProject, (String)SvnBundle.message("compare.with.branch.location.error", this.myVirtualFile.getPresentableUrl(), this.myBranchUrl), (String)SvnBundle.message("compare.with.branch.error.title", new Object[0]), (Icon)Messages.getErrorIcon()), null, (Project)this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "branchUrl";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/svn/diff/ElementWithBranchComparer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

