/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.vcsUtil.VcsUtil;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;

public class DiffContentRevision
implements ByteBackedContentRevision {
    private String myPath;
    private SVNRepository myRepository;
    private byte[] myContents;
    private FilePath myFilePath;
    private long myRevision;

    public DiffContentRevision(String path, @NotNull SVNRepository repos, long revision) {
        if (repos == null) {
            DiffContentRevision.$$$reportNull$$$0(0);
        }
        this(path, repos, revision, VcsUtil.getFilePath((String)path));
    }

    public DiffContentRevision(String path, SVNRepository repository, long revision, FilePath filePath) {
        this.myPath = path;
        this.myRepository = repository;
        this.myFilePath = filePath;
        this.myRevision = revision;
    }

    @NotNull
    public String getContent() throws VcsException {
        byte[] bytes = this.getContentAsBytes();
        Charset charset = this.myFilePath.getCharset();
        String string = CharsetToolkit.bytesToString((byte[])bytes, (Charset)charset);
        if (string == null) {
            DiffContentRevision.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public byte[] getContentAsBytes() throws VcsException {
        if (this.myContents == null) {
            BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream(2048);
            try {
                this.myRepository.getFile(this.myPath, -1L, null, (OutputStream)bos);
                this.myRepository.closeSession();
            }
            catch (SVNException e) {
                throw new VcsException((Throwable)e);
            }
            this.myContents = bos.toByteArray();
        }
        if (this.myContents == null) {
            DiffContentRevision.$$$reportNull$$$0(2);
        }
        return this.myContents;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myFilePath;
        if (filePath == null) {
            DiffContentRevision.$$$reportNull$$$0(3);
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber.Long longVal = new VcsRevisionNumber.Long(this.myRevision);
        if (longVal == null) {
            DiffContentRevision.$$$reportNull$$$0(4);
        }
        return longVal;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repos";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/diff/DiffContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/diff/DiffContentRevision";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentAsBytes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

