/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeModel;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.tmatesoft.svn.core.SVNURL;

public class RepositoryTreeRootNode
implements TreeNode,
Disposable {
    private final List<TreeNode> myChildren = new ArrayList<TreeNode>();
    private final RepositoryTreeModel myModel;

    public RepositoryTreeRootNode(RepositoryTreeModel model, SVNURL[] urls) {
        this.myModel = model;
        for (SVNURL url : urls) {
            RepositoryTreeNode rootNode = new RepositoryTreeNode(model, this, url, url);
            Disposer.register((Disposable)this, (Disposable)rootNode);
            this.myChildren.add(rootNode);
        }
        Collections.sort(this.myChildren, (o1, o2) -> Collator.getInstance().compare(o1.toString(), o2.toString()));
    }

    public void addRoot(SVNURL url) {
        RepositoryTreeNode rootNode = new RepositoryTreeNode(this.myModel, this, url, url);
        Disposer.register((Disposable)this, (Disposable)rootNode);
        this.myChildren.add(rootNode);
        Collections.sort(this.myChildren, (o1, o2) -> Collator.getInstance().compare(o1.toString(), o2.toString()));
        this.myModel.nodesWereInserted(this, new int[]{this.myChildren.indexOf(rootNode)});
    }

    public void remove(TreeNode node) {
        int index = this.getIndex(node);
        this.myChildren.remove(node);
        this.myModel.nodesWereRemoved(this, new int[]{index}, new Object[]{node});
    }

    public Enumeration children() {
        return Collections.enumeration(this.myChildren);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.myChildren.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.myChildren.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.myChildren.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public void dispose() {
    }
}

