/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.annotate.AnnotateClient;
import org.jetbrains.idea.svn.annotate.AnnotationConsumer;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitAnnotateClient
extends BaseSvnClient
implements AnnotateClient {
    @Override
    public void annotate(@NotNull SvnTarget target, @NotNull SVNRevision startRevision, @NotNull SVNRevision endRevision, boolean includeMergedRevisions, @Nullable DiffOptions diffOptions, @Nullable AnnotationConsumer handler) throws VcsException {
        if (target == null) {
            SvnKitAnnotateClient.$$$reportNull$$$0(0);
        }
        if (startRevision == null) {
            SvnKitAnnotateClient.$$$reportNull$$$0(1);
        }
        if (endRevision == null) {
            SvnKitAnnotateClient.$$$reportNull$$$0(2);
        }
        try {
            SVNLogClient client = this.myVcs.getSvnKitManager().createLogClient();
            client.setDiffOptions(SvnKitAnnotateClient.toDiffOptions(diffOptions));
            if (target.isFile()) {
                client.doAnnotate(target.getFile(), target.getPegRevision(), startRevision, endRevision, true, includeMergedRevisions, SvnKitAnnotateClient.toAnnotateHandler(handler), null);
            } else {
                client.doAnnotate(target.getURL(), target.getPegRevision(), startRevision, endRevision, true, includeMergedRevisions, SvnKitAnnotateClient.toAnnotateHandler(handler), null);
            }
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Nullable
    private static ISVNAnnotateHandler toAnnotateHandler(final @Nullable AnnotationConsumer handler) {
        ISVNAnnotateHandler result = null;
        if (handler != null) {
            result = new ISVNAnnotateHandler(){

                public void handleLine(Date date, long revision, String author, String line) {
                }

                public void handleLine(Date date, long revision, String author, String line, Date mergedDate, long mergedRevision, String mergedAuthor, String mergedPath, int lineNumber) throws SVNException {
                    if (revision > 0L) {
                        CommitInfo info = new CommitInfo.Builder(revision, date, author).build();
                        CommitInfo mergeInfo = mergedDate != null ? new CommitInfo.Builder(mergedRevision, mergedDate, mergedAuthor).build() : null;
                        handler.consume(lineNumber, info, mergeInfo);
                    }
                }

                public boolean handleRevision(Date date, long revision, String author, File contents) {
                    return false;
                }

                public void handleEOF() {
                }
            };
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "startRevision";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "endRevision";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/svn/annotate/SvnKitAnnotateClient";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

