/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.net.URI;
import java.nio.channels.NonWritableChannelException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWCRootCrawler;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.LockDialog;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.Status;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeSchemaTable;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnUtil {
    @NonNls
    public static final String SVN_ADMIN_DIR_NAME = SVNFileUtil.getAdminDirectoryName();
    @NonNls
    public static final String ENTRIES_FILE_NAME = "entries";
    @NonNls
    public static final String WC_DB_FILE_NAME = "wc.db";
    @NonNls
    public static final String PATH_TO_LOCK_FILE = SVN_ADMIN_DIR_NAME + "/lock";
    public static final int DEFAULT_PORT_INDICATOR = -1;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnUtil");
    public static final Pattern ERROR_PATTERN = Pattern.compile("^svn: (E(\\d+)): (.*)$", 8);
    public static final Pattern WARNING_PATTERN = Pattern.compile("^svn: warning: (W(\\d+)): (.*)$", 8);
    private static final Pair<SVNURL, WorkingCopyFormat> UNKNOWN_REPOSITORY_AND_FORMAT = Pair.create(null, (Object)((Object)WorkingCopyFormat.UNKNOWN));

    private SvnUtil() {
    }

    @Nullable
    public static SVNErrorMessage parseWarning(@NotNull String text) {
        if (text == null) {
            SvnUtil.$$$reportNull$$$0(0);
        }
        Matcher matcher = WARNING_PATTERN.matcher(text);
        SVNErrorMessage error = null;
        if (matcher.find()) {
            error = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.getErrorCode((int)Integer.parseInt(matcher.group(2))), (String)matcher.group(3), (int)1);
        }
        return error;
    }

    public static boolean isSvnVersioned(@NotNull SvnVcs vcs, @NotNull File file) {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(2);
        }
        return vcs.getInfo(file) != null;
    }

    @NotNull
    public static Collection<VirtualFile> crawlWCRoots(@NotNull SvnVcs vcs, @NotNull File path, @NotNull SvnWCRootCrawler callback, @Nullable ProgressIndicator progress) {
        VirtualFile file;
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(3);
        }
        if (path == null) {
            SvnUtil.$$$reportNull$$$0(4);
        }
        if (callback == null) {
            SvnUtil.$$$reportNull$$$0(5);
        }
        Collection<VirtualFile> collection = (file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(path)) != null ? SvnUtil.crawlWCRoots(vcs, file, callback, progress) : Collections.emptyList();
        if (collection == null) {
            SvnUtil.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    private static Collection<VirtualFile> crawlWCRoots(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull SvnWCRootCrawler callback, @Nullable ProgressIndicator progress) {
        VirtualFile parent;
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(7);
        }
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            SvnUtil.$$$reportNull$$$0(9);
        }
        HashSet result = ContainerUtil.newHashSet();
        VirtualFile virtualFile = parent = !file.isDirectory() || !file.isValid() ? file.getParent() : file;
        if (SvnUtil.isSvnVersioned(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)parent))) {
            SvnUtil.checkCanceled(progress);
            callback.handleWorkingCopyRoot(VfsUtilCore.virtualToIoFile((VirtualFile)file), progress);
            SvnUtil.checkCanceled(progress);
            result.add(parent);
        } else if (file.isDirectory()) {
            SvnUtil.checkCanceled(progress);
            for (VirtualFile child : parent.getChildren()) {
                SvnUtil.checkCanceled(progress);
                if (!child.isDirectory()) continue;
                result.addAll(SvnUtil.crawlWCRoots(vcs, child, callback, progress));
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            SvnUtil.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    private static void checkCanceled(@Nullable ProgressIndicator progress) {
        if (progress != null && progress.isCanceled()) {
            throw new ProcessCanceledException();
        }
    }

    @Nullable
    public static String getExactLocation(SvnVcs vcs, File path) {
        Info info = vcs.getInfo(path);
        return info != null && info.getURL() != null ? info.getURL().toString() : null;
    }

    @NotNull
    public static File[] toIoFiles(@NotNull VirtualFile[] files) {
        if (files == null) {
            SvnUtil.$$$reportNull$$$0(11);
        }
        File[] fileArray = (File[])ContainerUtil.map2Array((Object[])files, File.class, VfsUtilCore::virtualToIoFile);
        if (fileArray == null) {
            SvnUtil.$$$reportNull$$$0(12);
        }
        return fileArray;
    }

    public static void doLockFiles(Project project, SvnVcs activeVcs, @NotNull File[] ioFiles) throws VcsException {
        boolean force;
        String lockMessage;
        if (ioFiles == null) {
            SvnUtil.$$$reportNull$$$0(13);
        }
        if (activeVcs.getCheckoutOptions().getValue()) {
            LockDialog dialog = new LockDialog(project, true, ioFiles.length > 1);
            if (!dialog.showAndGet()) {
                return;
            }
            lockMessage = dialog.getComment();
            force = dialog.isForce();
        } else {
            lockMessage = "";
            force = false;
        }
        VcsException[] exception = new VcsException[1];
        final ArrayList failedLocks = new ArrayList();
        final int[] count = new int[]{ioFiles.length};
        ProgressTracker eventHandler = new ProgressTracker(){

            public void consume(ProgressEvent event) {
                if (event.getAction() == EventAction.LOCK_FAILED) {
                    failedLocks.add(event.getErrorMessage() != null ? event.getErrorMessage().getFullMessage() : event.getFile().getAbsolutePath());
                    count[0] = count[0] - 1;
                }
            }

            @Override
            public void checkCancelled() {
            }
        };
        Runnable command = () -> {
            if (ioFiles == null) {
                SvnUtil.$$$reportNull$$$0(89);
            }
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            try {
                if (progress != null) {
                    progress.setText(SvnBundle.message("progress.text.locking.files", new Object[0]));
                }
                for (File ioFile : ioFiles) {
                    if (progress != null) {
                        progress.checkCanceled();
                    }
                    if (progress != null) {
                        progress.setText2(SvnBundle.message("progress.text2.processing.file", ioFile.getName()));
                    }
                    activeVcs.getFactory(ioFile).createLockClient().lock(ioFile, force, lockMessage, eventHandler);
                }
            }
            catch (VcsException e) {
                exception[0] = e;
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.lock.files", new Object[0]), false, project);
        if (!failedLocks.isEmpty()) {
            String[] failedFiles = ArrayUtil.toStringArray(failedLocks);
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (String file : failedFiles) {
                exceptions.add(new VcsException(SvnBundle.message("exception.text.locking.file.failed", file)));
            }
            StringBuilder sb = new StringBuilder(SvnBundle.message("message.text.files.lock.failed", failedFiles.length == 1 ? 0 : 1));
            for (VcsException vcsException : exceptions) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(vcsException.getMessage());
            }
            throw new VcsException(sb.toString());
        }
        StatusBarUtil.setStatusBarInfo((Project)project, (String)SvnBundle.message("message.text.files.locked", count[0]));
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public static void doUnlockFiles(Project project, SvnVcs activeVcs, File[] ioFiles) throws VcsException {
        boolean force = true;
        VcsException[] exception = new VcsException[1];
        final ArrayList failedUnlocks = new ArrayList();
        final int[] count = new int[]{ioFiles.length};
        ProgressTracker eventHandler = new ProgressTracker(){

            public void consume(ProgressEvent event) {
                if (event.getAction() == EventAction.UNLOCK_FAILED) {
                    failedUnlocks.add(event.getErrorMessage() != null ? event.getErrorMessage().getFullMessage() : event.getFile().getAbsolutePath());
                    count[0] = count[0] - 1;
                }
            }

            @Override
            public void checkCancelled() {
            }
        };
        Runnable command = () -> {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            try {
                if (progress != null) {
                    progress.setText(SvnBundle.message("progress.text.unlocking.files", new Object[0]));
                }
                for (File ioFile : ioFiles) {
                    if (progress != null) {
                        progress.checkCanceled();
                    }
                    if (progress != null) {
                        progress.setText2(SvnBundle.message("progress.text2.processing.file", ioFile.getName()));
                    }
                    activeVcs.getFactory(ioFile).createLockClient().unlock(ioFile, true, eventHandler);
                }
            }
            catch (VcsException e) {
                exception[0] = e;
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.unlock.files", new Object[0]), false, project);
        if (!failedUnlocks.isEmpty()) {
            String[] failedFiles = ArrayUtil.toStringArray(failedUnlocks);
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (String file : failedFiles) {
                exceptions.add(new VcsException(SvnBundle.message("exception.text.failed.to.unlock.file", file)));
            }
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, SvnBundle.message("message.title.unlock.failures", new Object[0]));
        }
        StatusBarUtil.setStatusBarInfo((Project)project, (String)SvnBundle.message("message.text.files.unlocked", count[0]));
        if (exception[0] != null) {
            throw new VcsException((Throwable)exception[0]);
        }
    }

    @NotNull
    public static MultiMap<Pair<SVNURL, WorkingCopyFormat>, Change> splitChangesIntoWc(@NotNull SvnVcs vcs, @NotNull List<Change> changes) {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(14);
        }
        if (changes == null) {
            SvnUtil.$$$reportNull$$$0(15);
        }
        MultiMap<Pair<SVNURL, WorkingCopyFormat>, Change> multiMap = SvnUtil.splitIntoRepositoriesMap(vcs, changes, change -> ChangesUtil.getFilePath((Change)change));
        if (multiMap == null) {
            SvnUtil.$$$reportNull$$$0(16);
        }
        return multiMap;
    }

    @NotNull
    public static <T> MultiMap<Pair<SVNURL, WorkingCopyFormat>, T> splitIntoRepositoriesMap(@NotNull SvnVcs vcs, @NotNull Collection<T> items, @NotNull Convertor<T, FilePath> converter) {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(17);
        }
        if (items == null) {
            SvnUtil.$$$reportNull$$$0(18);
        }
        if (converter == null) {
            SvnUtil.$$$reportNull$$$0(19);
        }
        MultiMap multiMap = ContainerUtil.groupBy(items, item -> {
            RootUrlInfo path;
            if (vcs == null) {
                SvnUtil.$$$reportNull$$$0(87);
            }
            if (converter == null) {
                SvnUtil.$$$reportNull$$$0(88);
            }
            return (path = vcs.getSvnFileUrlMapping().getWcRootForFilePath(((FilePath)converter.convert(item)).getIOFile())) == null ? UNKNOWN_REPOSITORY_AND_FORMAT : Pair.create((Object)path.getRepositoryUrl(), (Object)((Object)path.getFormat()));
        });
        if (multiMap == null) {
            SvnUtil.$$$reportNull$$$0(20);
        }
        return multiMap;
    }

    @NotNull
    public static WorkingCopyFormat getFormat(File path) {
        WorkingCopyFormat result = null;
        File dbFile = SvnUtil.resolveDatabase(path);
        if (dbFile != null && (result = (WorkingCopyFormat)((Object)FileUtilRt.doIOOperation((FileUtilRt.RepeatableIOOperation)(Registry.is((String)"svn.use.sqlite.jdbc") ? new SqLiteJdbcWorkingCopyFormatOperation(dbFile) : new WorkingCopyFormatOperation(dbFile))))) == null) {
            SvnUtil.notifyDatabaseError();
        }
        WorkingCopyFormat workingCopyFormat = result != null ? result : WorkingCopyFormat.UNKNOWN;
        if (workingCopyFormat == null) {
            SvnUtil.$$$reportNull$$$0(21);
        }
        return workingCopyFormat;
    }

    private static void close(@Nullable SqlJetDb db) {
        if (db != null) {
            try {
                db.close();
            }
            catch (SqlJetException e) {
                SvnUtil.notifyDatabaseError();
            }
        }
    }

    private static void notifyDatabaseError() {
        VcsBalloonProblemNotifier.NOTIFICATION_GROUP.createNotification("Some errors occurred while accessing svn working copy database.", NotificationType.ERROR).notify(null);
    }

    private static File resolveDatabase(File path) {
        File dbFile = SvnUtil.getWcDb(path);
        File result = null;
        try {
            if (dbFile.exists() && dbFile.isFile()) {
                result = dbFile;
            }
        }
        catch (SecurityException e) {
            LOG.error("Failed to access working copy database", (Throwable)e);
        }
        return result;
    }

    @Nullable
    public static String getRepositoryUUID(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        return info != null ? info.getRepositoryUUID() : null;
    }

    @Nullable
    public static String getRepositoryUUID(SvnVcs vcs, SVNURL url) {
        try {
            Info info = vcs.getInfo(url, SVNRevision.UNDEFINED);
            return info == null ? null : info.getRepositoryUUID();
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    @Nullable
    public static SVNURL getRepositoryRoot(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        return info != null ? info.getRepositoryRootURL() : null;
    }

    @Nullable
    public static SVNURL getRepositoryRoot(SvnVcs vcs, String url) {
        try {
            return SvnUtil.getRepositoryRoot(vcs, SvnUtil.createUrl(url));
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    @Nullable
    public static SVNURL getRepositoryRoot(SvnVcs vcs, SVNURL url) throws SvnBindException {
        Info info = vcs.getInfo(url, SVNRevision.HEAD);
        return info == null ? null : info.getRepositoryRootURL();
    }

    public static boolean isWorkingCopyRoot(File file) {
        return FileUtil.filesEqual((File)file, (File)SvnUtil.getWorkingCopyRootNew(file));
    }

    @Nullable
    public static File getWorkingCopyRoot(File inFile) {
        File file;
        for (file = inFile; file != null && (file.isFile() || !file.exists()); file = file.getParentFile()) {
        }
        if (file == null) {
            return null;
        }
        File workingCopyRoot = null;
        try {
            workingCopyRoot = SVNWCUtil.getWorkingCopyRoot((File)file, (boolean)true);
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        if (workingCopyRoot == null) {
            workingCopyRoot = SvnUtil.getWcCopyRootIf17(file, null);
        }
        return workingCopyRoot;
    }

    @NotNull
    public static File fileFromUrl(File baseDir, String baseUrl, String fullUrl) {
        assert (fullUrl.startsWith(baseUrl));
        String part = fullUrl.substring(baseUrl.length()).replace('/', File.separatorChar).replace('\\', File.separatorChar);
        File file = new File(baseDir, part);
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(22);
        }
        return file;
    }

    public static VirtualFile getVirtualFile(String filePath) {
        String path = VfsUtilCore.pathToUrl((String)filePath.replace(File.separatorChar, '/'));
        return (VirtualFile)ReadAction.compute(() -> VirtualFileManager.getInstance().findFileByUrl(path));
    }

    @Deprecated
    @Nullable
    public static SVNURL getBranchForUrl(@NotNull SvnVcs vcs, @NotNull VirtualFile vcsRoot, @NotNull String urlValue) {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(23);
        }
        if (vcsRoot == null) {
            SvnUtil.$$$reportNull$$$0(24);
        }
        if (urlValue == null) {
            SvnUtil.$$$reportNull$$$0(25);
        }
        SVNURL url = null;
        try {
            url = SvnUtil.createUrl(urlValue);
        }
        catch (SvnBindException e) {
            LOG.debug((Throwable)((Object)e));
        }
        return url != null ? SvnUtil.getBranchForUrl(vcs, vcsRoot, url) : null;
    }

    @Nullable
    public static SVNURL getBranchForUrl(@NotNull SvnVcs vcs, @NotNull VirtualFile vcsRoot, @NotNull SVNURL url) {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(26);
        }
        if (vcsRoot == null) {
            SvnUtil.$$$reportNull$$$0(27);
        }
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(28);
        }
        SVNURL result = null;
        SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(vcs.getProject()).get(vcsRoot);
        try {
            result = configuration.getWorkingBranch(url);
        }
        catch (SvnBindException e) {
            LOG.debug((Throwable)((Object)e));
        }
        return result;
    }

    public static boolean checkRepositoryVersion15(@NotNull SvnVcs vcs, @NotNull SVNURL url) {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(29);
        }
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(30);
        }
        boolean result = false;
        try {
            result = vcs.getFactory().createRepositoryFeaturesClient().supportsMergeTracking(url);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
        return result;
    }

    @Nullable
    public static Status getStatus(@NotNull SvnVcs vcs, @NotNull File file) {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(31);
        }
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(32);
        }
        try {
            return vcs.getFactory(file).createStatusClient().doStatus(file, false);
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    @NotNull
    public static Depth getDepth(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        Depth depth = info != null && info.getDepth() != null ? info.getDepth() : Depth.UNKNOWN;
        if (depth == null) {
            SvnUtil.$$$reportNull$$$0(33);
        }
        return depth;
    }

    public static boolean seemsLikeVersionedDir(VirtualFile file) {
        String adminName = SVNFileUtil.getAdminDirectoryName();
        VirtualFile child = file.findChild(adminName);
        return child != null && child.isDirectory();
    }

    public static boolean isAdminDirectory(VirtualFile file) {
        return SvnUtil.isAdminDirectory(file.getParent(), file.getName());
    }

    public static boolean isAdminDirectory(VirtualFile parent, String name) {
        if (name.equals(SVN_ADMIN_DIR_NAME)) {
            return true;
        }
        if (parent != null) {
            if (parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
            if ((parent = parent.getParent()) != null && parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static SVNURL getUrl(SvnVcs vcs, File file) {
        Info info = vcs.getInfo(file);
        return info == null ? null : info.getURL();
    }

    public static boolean remoteFolderIsEmpty(@NotNull SvnVcs vcs, @NotNull String url) throws VcsException {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(34);
        }
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(35);
        }
        SvnTarget target = SvnTarget.fromURL((SVNURL)SvnUtil.createUrl(url));
        Ref result = new Ref((Object)true);
        DirectoryEntryConsumer handler = entry -> {
            if (entry != null) {
                result.set((Object)false);
            }
        };
        vcs.getFactory(target).createBrowseClient().list(target, null, Depth.IMMEDIATES, handler);
        return (Boolean)result.get();
    }

    public static File getWcDb(File file) {
        return new File(file, SVN_ADMIN_DIR_NAME + "/wc.db");
    }

    @Nullable
    public static File getWcCopyRootIf17(File file, @Nullable File upperBound) {
        File current = SvnUtil.getParentWithDb(file);
        if (current == null) {
            return null;
        }
        while (current != null) {
            try {
                SvnWcGeneration svnWcGeneration = SvnOperationFactory.detectWcGeneration((File)current, (boolean)false);
                if (SvnWcGeneration.V17.equals((Object)svnWcGeneration)) {
                    return current;
                }
                if (SvnWcGeneration.V16.equals((Object)svnWcGeneration)) {
                    return null;
                }
                if (upperBound != null && FileUtil.filesEqual((File)upperBound, (File)current)) {
                    return null;
                }
                current = current.getParentFile();
            }
            catch (SVNException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static File getWorkingCopyRootNew(File file) {
        File current = SvnUtil.getParentWithDb(file);
        if (current == null) {
            return SvnUtil.getWorkingCopyRoot(file);
        }
        WorkingCopyFormat format = SvnUtil.getFormat(current);
        return format.isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN) ? current : SvnUtil.getWorkingCopyRoot(file);
    }

    private static File getParentWithDb(File file) {
        File current;
        boolean wcDbFound = false;
        for (current = file; current != null; current = current.getParentFile()) {
            File wcDb = SvnUtil.getWcDb(current);
            if (!wcDb.exists() || wcDb.isDirectory()) continue;
            wcDbFound = true;
            break;
        }
        if (!wcDbFound) {
            return null;
        }
        return current;
    }

    public static boolean isAncestor(@NotNull SVNURL parentUrl, @NotNull SVNURL childUrl) {
        if (parentUrl == null) {
            SvnUtil.$$$reportNull$$$0(36);
        }
        if (childUrl == null) {
            SvnUtil.$$$reportNull$$$0(37);
        }
        return SVNPathUtil.isAncestor((String)parentUrl.toDecodedString(), (String)childUrl.toDecodedString());
    }

    public static String getRelativeUrl(@NotNull SVNURL parentUrl, @NotNull SVNURL childUrl) {
        if (parentUrl == null) {
            SvnUtil.$$$reportNull$$$0(38);
        }
        if (childUrl == null) {
            SvnUtil.$$$reportNull$$$0(39);
        }
        return SvnUtil.getRelativeUrl(parentUrl.toDecodedString(), childUrl.toDecodedString());
    }

    public static String getRelativeUrl(@NotNull SvnTarget parent, @NotNull SvnTarget child) {
        if (parent == null) {
            SvnUtil.$$$reportNull$$$0(40);
        }
        if (child == null) {
            SvnUtil.$$$reportNull$$$0(41);
        }
        return SvnUtil.getRelativeUrl(SvnUtil.toDecodedString(parent), SvnUtil.toDecodedString(child));
    }

    private static String getRelativeUrl(@NotNull String parentUrl, @NotNull String childUrl) {
        if (parentUrl == null) {
            SvnUtil.$$$reportNull$$$0(42);
        }
        if (childUrl == null) {
            SvnUtil.$$$reportNull$$$0(43);
        }
        return FileUtilRt.getRelativePath((String)parentUrl, (String)childUrl, (char)'/', (boolean)true);
    }

    public static String getRelativePath(@NotNull String parentPath, @NotNull String childPath) {
        if (parentPath == null) {
            SvnUtil.$$$reportNull$$$0(44);
        }
        if (childPath == null) {
            SvnUtil.$$$reportNull$$$0(45);
        }
        return FileUtilRt.getRelativePath((String)FileUtil.toSystemIndependentName((String)parentPath), (String)FileUtil.toSystemIndependentName((String)childPath), (char)'/');
    }

    @NotNull
    @Contract(pure=true)
    public static String ensureStartSlash(@NotNull String path) {
        if (path == null) {
            SvnUtil.$$$reportNull$$$0(46);
        }
        String string = StringUtil.startsWithChar((CharSequence)path, (char)'/') ? path : '/' + path;
        if (string == null) {
            SvnUtil.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    public static String join(String ... parts) {
        if (parts == null) {
            SvnUtil.$$$reportNull$$$0(48);
        }
        String string = StringUtil.join((String[])parts, (String)"/");
        if (string == null) {
            SvnUtil.$$$reportNull$$$0(49);
        }
        return string;
    }

    public static String appendMultiParts(@NotNull String base, @NotNull String subPath) {
        if (base == null) {
            SvnUtil.$$$reportNull$$$0(50);
        }
        if (subPath == null) {
            SvnUtil.$$$reportNull$$$0(51);
        }
        if (StringUtil.isEmpty((String)subPath)) {
            return base;
        }
        List parts = StringUtil.split((String)subPath.replace('\\', '/'), (String)"/", (boolean)true);
        String result = base;
        for (String part : parts) {
            result = SVNPathUtil.append((String)result, (String)part);
        }
        return result;
    }

    @NotNull
    public static SVNURL removePathTail(@NotNull SVNURL url) throws SvnBindException {
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(52);
        }
        SVNURL sVNURL = SvnUtil.createUrl(SVNPathUtil.removeTail((String)url.toDecodedString()));
        if (sVNURL == null) {
            SvnUtil.$$$reportNull$$$0(53);
        }
        return sVNURL;
    }

    @NotNull
    public static SVNRevision getHeadRevision(@NotNull SvnVcs vcs, @NotNull SVNURL url) throws SvnBindException {
        Info info;
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(54);
        }
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(55);
        }
        if ((info = vcs.getInfo(url, SVNRevision.HEAD)) == null) {
            throw new SvnBindException("Could not get info for " + url);
        }
        if (info.getRevision() == null) {
            throw new SvnBindException("Could not get revision for " + url);
        }
        SVNRevision sVNRevision = info.getRevision();
        if (sVNRevision == null) {
            SvnUtil.$$$reportNull$$$0(56);
        }
        return sVNRevision;
    }

    public static byte[] getFileContents(@NotNull SvnVcs vcs, @NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable SVNRevision pegRevision) throws VcsException {
        if (vcs == null) {
            SvnUtil.$$$reportNull$$$0(57);
        }
        if (target == null) {
            SvnUtil.$$$reportNull$$$0(58);
        }
        return vcs.getFactory(target).createContentClient().getContent(target, revision, pegRevision);
    }

    public static boolean hasDefaultPort(@NotNull SVNURL result) {
        if (result == null) {
            SvnUtil.$$$reportNull$$$0(59);
        }
        return !result.hasPort() || SVNURL.getDefaultPortNumber((String)result.getProtocol()) == result.getPort();
    }

    public static int resolvePort(@NotNull SVNURL url) {
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(60);
        }
        return !SvnUtil.hasDefaultPort(url) ? url.getPort() : -1;
    }

    @NotNull
    public static SVNURL createUrl(@NotNull String url) throws SvnBindException {
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(61);
        }
        SVNURL sVNURL = SvnUtil.createUrl(url, true);
        if (sVNURL == null) {
            SvnUtil.$$$reportNull$$$0(62);
        }
        return sVNURL;
    }

    @NotNull
    public static SVNURL createUrl(@NotNull String url, boolean encoded) throws SvnBindException {
        SVNURL sVNURL;
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(63);
        }
        try {
            SVNURL result;
            SVNURL sVNURL2 = result = encoded ? SVNURL.parseURIEncoded((String)url) : SVNURL.parseURIDecoded((String)url);
            if (result.hasPort() && SvnUtil.hasDefaultPort(result)) {
                result = SVNURL.create((String)result.getProtocol(), (String)result.getUserInfo(), (String)result.getHost(), (int)-1, (String)result.getURIEncodedPath(), (boolean)true);
            }
            sVNURL = result;
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
        if (sVNURL == null) {
            SvnUtil.$$$reportNull$$$0(64);
        }
        return sVNURL;
    }

    @NotNull
    public static SVNURL parseUrl(@NotNull String url) {
        SVNURL sVNURL;
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(65);
        }
        try {
            sVNURL = SvnUtil.createUrl(url);
        }
        catch (SvnBindException e) {
            throw SvnUtil.createIllegalArgument((Exception)((Object)e));
        }
        if (sVNURL == null) {
            SvnUtil.$$$reportNull$$$0(66);
        }
        return sVNURL;
    }

    @NotNull
    public static SVNURL parseUrl(@NotNull String url, boolean encoded) {
        SVNURL sVNURL;
        if (url == null) {
            SvnUtil.$$$reportNull$$$0(67);
        }
        try {
            sVNURL = SvnUtil.createUrl(url, encoded);
        }
        catch (SvnBindException e) {
            throw SvnUtil.createIllegalArgument((Exception)((Object)e));
        }
        if (sVNURL == null) {
            SvnUtil.$$$reportNull$$$0(68);
        }
        return sVNURL;
    }

    @NotNull
    public static SVNURL append(@NotNull SVNURL parent, @NotNull String child) throws SvnBindException {
        SVNURL sVNURL;
        if (parent == null) {
            SvnUtil.$$$reportNull$$$0(69);
        }
        if (child == null) {
            SvnUtil.$$$reportNull$$$0(70);
        }
        try {
            sVNURL = parent.appendPath(child, false);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
        if (sVNURL == null) {
            SvnUtil.$$$reportNull$$$0(71);
        }
        return sVNURL;
    }

    @NotNull
    public static IllegalArgumentException createIllegalArgument(@NotNull Exception e) {
        if (e == null) {
            SvnUtil.$$$reportNull$$$0(72);
        }
        IllegalArgumentException runtimeException = new IllegalArgumentException();
        runtimeException.initCause(e);
        IllegalArgumentException illegalArgumentException = runtimeException;
        if (illegalArgumentException == null) {
            SvnUtil.$$$reportNull$$$0(73);
        }
        return illegalArgumentException;
    }

    @Nullable
    public static String getChangelistName(@NotNull Status status) {
        if (status == null) {
            SvnUtil.$$$reportNull$$$0(74);
        }
        return status.getKind().isFile() ? status.getChangelistName() : null;
    }

    public static boolean isUnversionedOrNotFound(@NotNull SvnBindException e) {
        if (e == null) {
            SvnUtil.$$$reportNull$$$0(75);
        }
        return e.contains(SVNErrorCode.WC_PATH_NOT_FOUND) || e.contains(SVNErrorCode.UNVERSIONED_RESOURCE) || e.contains(SVNErrorCode.WC_NOT_WORKING_COPY) || e.contains(SVNErrorCode.ILLEGAL_TARGET) || StringUtil.containsIgnoreCase((String)e.getMessage(), (String)"(not a versioned resource)");
    }

    @NotNull
    public static SvnTarget append(@NotNull SvnTarget target, @NotNull String path) throws SvnBindException {
        if (target == null) {
            SvnUtil.$$$reportNull$$$0(76);
        }
        if (path == null) {
            SvnUtil.$$$reportNull$$$0(77);
        }
        SvnTarget svnTarget = SvnUtil.append(target, path, false);
        if (svnTarget == null) {
            SvnUtil.$$$reportNull$$$0(78);
        }
        return svnTarget;
    }

    @NotNull
    public static SvnTarget append(@NotNull SvnTarget target, @NotNull String path, boolean checkAbsolute) throws SvnBindException {
        SvnTarget result;
        if (target == null) {
            SvnUtil.$$$reportNull$$$0(79);
        }
        if (path == null) {
            SvnUtil.$$$reportNull$$$0(80);
        }
        if (target.isFile()) {
            result = SvnTarget.fromFile((File)SvnUtil.resolvePath(target.getFile(), path));
        } else {
            try {
                result = SvnTarget.fromURL((SVNURL)(checkAbsolute && URI.create(path).isAbsolute() ? SVNURL.parseURIEncoded((String)path) : target.getURL().appendPath(path, false)));
            }
            catch (SVNException e) {
                throw new SvnBindException(e);
            }
        }
        SvnTarget svnTarget = result;
        if (svnTarget == null) {
            SvnUtil.$$$reportNull$$$0(81);
        }
        return svnTarget;
    }

    @NotNull
    public static File resolvePath(@NotNull File base, @NotNull String path) {
        File result;
        if (base == null) {
            SvnUtil.$$$reportNull$$$0(82);
        }
        if (path == null) {
            SvnUtil.$$$reportNull$$$0(83);
        }
        if (!(result = new File(path)).isAbsolute()) {
            result = ".".equals(path) ? base : new File(base, path);
        }
        File file = result;
        if (file == null) {
            SvnUtil.$$$reportNull$$$0(84);
        }
        return file;
    }

    @NotNull
    public static String toDecodedString(@NotNull SvnTarget target) {
        if (target == null) {
            SvnUtil.$$$reportNull$$$0(85);
        }
        String string = target.isFile() ? target.getFile().getPath() : target.getURL().toDecodedString();
        if (string == null) {
            SvnUtil.$$$reportNull$$$0(86);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 33: 
            case 47: 
            case 49: 
            case 53: 
            case 56: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 78: 
            case 81: 
            case 84: 
            case 86: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 33: 
            case 47: 
            case 49: 
            case 53: 
            case 56: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 78: 
            case 81: 
            case 84: 
            case 86: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 14: 
            case 17: 
            case 23: 
            case 26: 
            case 29: 
            case 31: 
            case 34: 
            case 54: 
            case 57: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 8: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 46: 
            case 77: 
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 33: 
            case 47: 
            case 49: 
            case 53: 
            case 56: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 78: 
            case 81: 
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFiles";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 19: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlValue";
                break;
            }
            case 28: 
            case 30: 
            case 35: 
            case 52: 
            case 55: 
            case 60: 
            case 61: 
            case 63: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 36: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentUrl";
                break;
            }
            case 37: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childUrl";
                break;
            }
            case 40: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 41: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPath";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childPath";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 50: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subPath";
                break;
            }
            case 58: 
            case 76: 
            case 79: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnUtil";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "crawlWCRoots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toIoFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "splitChangesIntoWc";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "splitIntoRepositoriesMap";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "fileFromUrl";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDepth";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureStartSlash";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "removePathTail";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeadRevision";
                break;
            }
            case 62: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrl";
                break;
            }
            case 66: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "parseUrl";
                break;
            }
            case 71: 
            case 78: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "createIllegalArgument";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "toDecodedString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseWarning";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSvnVersioned";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "crawlWCRoots";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 33: 
            case 47: 
            case 49: 
            case 53: 
            case 56: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 78: 
            case 81: 
            case 84: 
            case 86: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toIoFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doLockFiles";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "splitChangesIntoWc";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "splitIntoRepositoriesMap";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getBranchForUrl";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkRepositoryVersion15";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "remoteFolderIsEmpty";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeUrl";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "ensureStartSlash";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "appendMultiParts";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "removePathTail";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getHeadRevision";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getFileContents";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultPort";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "resolvePort";
                break;
            }
            case 61: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createUrl";
                break;
            }
            case 65: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "parseUrl";
                break;
            }
            case 69: 
            case 70: 
            case 76: 
            case 77: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createIllegalArgument";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getChangelistName";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isUnversionedOrNotFound";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "toDecodedString";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "lambda$splitIntoRepositoriesMap$3";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doLockFiles$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 33: 
            case 47: 
            case 49: 
            case 53: 
            case 56: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 78: 
            case 81: 
            case 84: 
            case 86: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SqLiteDb
    extends SqlJetDb {
        private SqLiteDb(@NotNull File file, boolean writable) {
            if (file == null) {
                SqLiteDb.$$$reportNull$$$0(0);
            }
            super(file, writable);
        }

        @NotNull
        public static SqLiteDb open(@NotNull File file, boolean write) throws SqlJetException {
            if (file == null) {
                SqLiteDb.$$$reportNull$$$0(1);
            }
            SqLiteDb db = new SqLiteDb(file, write);
            db.open();
            SqLiteDb sqLiteDb = db;
            if (sqLiteDb == null) {
                SqLiteDb.$$$reportNull$$$0(2);
            }
            return sqLiteDb;
        }

        private int getUserVersion() {
            int result = 0;
            ISqlJetOptions options = this.dbHandle.getOptions();
            if (options != null) {
                try {
                    result = options.getUserVersion();
                }
                catch (SqlJetException sqlJetException) {
                    // empty catch block
                }
            }
            return result;
        }

        @NotNull
        private String getDbSchema() {
            String result = "";
            try {
                result = (String)this.runSynchronized(engine -> {
                    this.btree.enter();
                    try {
                        String string = this.readDbSchema();
                        return string;
                    }
                    finally {
                        this.btree.leave();
                    }
                });
            }
            catch (SqlJetException sqlJetException) {
                // empty catch block
            }
            String string = result;
            if (string == null) {
                SqLiteDb.$$$reportNull$$$0(3);
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private String readDbSchema() throws SqlJetException {
            StringBuilder result = new StringBuilder();
            try (SqlJetBtreeSchemaTable table = new SqlJetBtreeSchemaTable(this.btree, false);){
                table.lock();
                try {
                    table.first();
                    while (!table.eof()) {
                        String sql = table.getSqlField();
                        if (sql != null) {
                            result.append(sql);
                            result.append("\n");
                        }
                        table.next();
                    }
                }
                finally {
                    table.unlock();
                }
            }
            String string = result.toString();
            if (string == null) {
                SqLiteDb.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/SvnUtil$SqLiteDb";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/SvnUtil$SqLiteDb";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "open";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbSchema";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readDbSchema";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "open";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SqLiteJdbcWorkingCopyFormatOperation
    implements FileUtilRt.RepeatableIOOperation<WorkingCopyFormat, RuntimeException> {
        private static final String SQLITE_JDBC_TEMP_DIR_PROPERTY = "org.sqlite.tmpdir";
        @NotNull
        private final File myDbFile;

        public SqLiteJdbcWorkingCopyFormatOperation(@NotNull File dbFile) {
            if (dbFile == null) {
                SqLiteJdbcWorkingCopyFormatOperation.$$$reportNull$$$0(0);
            }
            this.myDbFile = dbFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public WorkingCopyFormat execute(boolean lastAttempt) {
            Connection connection = null;
            int userVersion = 0;
            try {
                Class.forName("org.sqlite.JDBC");
                connection = DriverManager.getConnection("jdbc:sqlite:" + FileUtil.toSystemIndependentName((String)this.myDbFile.getPath()));
                ResultSet resultSet = connection.createStatement().executeQuery("pragma user_version");
                if (resultSet.next()) {
                    userVersion = resultSet.getInt(1);
                } else {
                    LOG.info("No result while getting user version for " + this.myDbFile.getPath());
                }
                SqLiteJdbcWorkingCopyFormatOperation.close(connection);
            }
            catch (ClassNotFoundException | SQLException e) {
                LOG.info((Throwable)e);
            }
            finally {
                SqLiteJdbcWorkingCopyFormatOperation.close(connection);
            }
            WorkingCopyFormat format = WorkingCopyFormat.getInstance(userVersion);
            return !WorkingCopyFormat.UNKNOWN.equals((Object)format) ? format : null;
        }

        private static void ensureTempFolder() {
            if (System.getProperty(SQLITE_JDBC_TEMP_DIR_PROPERTY) == null) {
                System.setProperty(SQLITE_JDBC_TEMP_DIR_PROPERTY, PathManager.getTempPath());
            }
        }

        private static void close(@Nullable Connection connection) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    SvnUtil.notifyDatabaseError();
                }
            }
        }

        static {
            SqLiteJdbcWorkingCopyFormatOperation.ensureTempFolder();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbFile", "org/jetbrains/idea/svn/SvnUtil$SqLiteJdbcWorkingCopyFormatOperation", "<init>"));
        }
    }

    private static class WorkingCopyFormatOperation
    implements FileUtilRt.RepeatableIOOperation<WorkingCopyFormat, RuntimeException> {
        @NotNull
        private final File myDbFile;

        public WorkingCopyFormatOperation(@NotNull File dbFile) {
            if (dbFile == null) {
                WorkingCopyFormatOperation.$$$reportNull$$$0(0);
            }
            this.myDbFile = dbFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Nullable
        public WorkingCopyFormat execute(boolean lastAttempt) {
            SqLiteDb db = null;
            int userVersion = 0;
            try {
                db = SqLiteDb.open(this.myDbFile, true);
                userVersion = db.getOptions().getUserVersion();
            }
            catch (NonWritableChannelException e) {
                LOG.info((Throwable)e);
                SvnUtil.close(db);
            }
            catch (SqlJetException e2) {
                block6: {
                    LOG.info((Throwable)e2);
                    if (db == null) break block6;
                    userVersion = db.getUserVersion();
                    LOG.debug("Working copy database schema: " + db.getDbSchema());
                    {
                        catch (Throwable throwable) {
                            SvnUtil.close(db);
                            throw throwable;
                        }
                    }
                }
                SvnUtil.close(db);
            }
            SvnUtil.close(db);
            WorkingCopyFormat format = WorkingCopyFormat.getInstance(userVersion);
            return !WorkingCopyFormat.UNKNOWN.equals((Object)format) ? format : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbFile", "org/jetbrains/idea/svn/SvnUtil$WorkingCopyFormatOperation", "<init>"));
        }
    }
}

