/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.info.Info;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;

public class RootsToWorkingCopies
implements VcsListener {
    private final Object myLock;
    private final Map<VirtualFile, WorkingCopy> myRootMapping;
    private final Set<VirtualFile> myUnversioned;
    private final BackgroundTaskQueue myQueue;
    private final Project myProject;
    private final ZipperUpdater myZipperUpdater;
    private Runnable myRechecker;
    private final SvnVcs myVcs;

    public RootsToWorkingCopies(SvnVcs vcs) {
        this.myProject = vcs.getProject();
        this.myQueue = new BackgroundTaskQueue(this.myProject, "SVN VCS roots authorization checker");
        this.myLock = new Object();
        this.myRootMapping = new HashMap<VirtualFile, WorkingCopy>();
        this.myUnversioned = new HashSet<VirtualFile>();
        this.myVcs = vcs;
        this.myRechecker = () -> {
            VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)this.myVcs);
            Object object = this.myLock;
            synchronized (object) {
                this.clear();
                for (VirtualFile root : roots) {
                    this.addRoot(root);
                }
            }
        };
        this.myZipperUpdater = new ZipperUpdater(200, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
    }

    private void addRoot(final VirtualFile root) {
        this.myQueue.run(new Task.Backgroundable(this.myProject, "Looking for '" + root.getPath() + "' working copy root", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                RootsToWorkingCopies.this.calculateRoot(root);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/svn/RootsToWorkingCopies$1", "run"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public WorkingCopy getMatchingCopy(SVNURL url) {
        assert (!ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
        if (url == null) {
            return null;
        }
        VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)SvnVcs.getInstance(this.myProject));
        Object object = this.myLock;
        synchronized (object) {
            for (VirtualFile root : roots) {
                WorkingCopy wcRoot = this.getWcRoot(root);
                if (wcRoot == null) continue;
                SVNURL common = SVNURLUtil.getCommonURLAncestor((SVNURL)wcRoot.getUrl(), (SVNURL)url);
                if (!wcRoot.getUrl().equals((Object)common) && !url.equals((Object)common)) continue;
                return wcRoot;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public WorkingCopy getWcRoot(@NotNull VirtualFile root) {
        if (root == null) {
            RootsToWorkingCopies.$$$reportNull$$$0(0);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
        Object object = this.myLock;
        synchronized (object) {
            if (this.myUnversioned.contains(root)) {
                return null;
            }
            WorkingCopy existing = this.myRootMapping.get(root);
            if (existing != null) {
                return existing;
            }
        }
        return this.calculateRoot(root);
    }

    @Nullable
    private WorkingCopy calculateRoot(@NotNull VirtualFile root) {
        Info svnInfo;
        if (root == null) {
            RootsToWorkingCopies.$$$reportNull$$$0(1);
        }
        File workingCopyRoot = SvnUtil.getWorkingCopyRootNew(VfsUtilCore.virtualToIoFile((VirtualFile)root));
        WorkingCopy workingCopy = null;
        if (workingCopyRoot != null && (svnInfo = this.myVcs.getInfo(workingCopyRoot)) != null && svnInfo.getURL() != null) {
            workingCopy = new WorkingCopy(workingCopyRoot, svnInfo.getURL(), true);
        }
        return this.registerWorkingCopy(root, workingCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkingCopy registerWorkingCopy(@NotNull VirtualFile root, @Nullable WorkingCopy resolvedWorkingCopy) {
        if (root == null) {
            RootsToWorkingCopies.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (resolvedWorkingCopy == null) {
                this.myRootMapping.remove(root);
                this.myUnversioned.add(root);
            } else {
                this.myUnversioned.remove(root);
                this.myRootMapping.put(root, resolvedWorkingCopy);
            }
        }
        return resolvedWorkingCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.myLock;
        synchronized (object) {
            this.myRootMapping.clear();
            this.myUnversioned.clear();
            this.myZipperUpdater.stop();
        }
    }

    public void directoryMappingChanged() {
        this.myVcs.getAuthNotifier().clear();
        this.myZipperUpdater.queue(this.myRechecker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "root";
        objectArray2[1] = "org/jetbrains/idea/svn/RootsToWorkingCopies";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getWcRoot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerWorkingCopy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

