/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl.sdk;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtSdkPathUtil;
import org.jetbrains.jps.util.JpsPathUtil;

public class GwtMavenSdkPaths
implements GwtSdkPaths {
    @NonNls
    public static final String TYPE_ID = "maven";
    private final String myBasePath;
    private final String myVersion;
    private final String myDevDirPath;
    private final String myRepositoryPath;

    public GwtMavenSdkPaths(String homeDirectoryPath, String version) {
        this.myDevDirPath = homeDirectoryPath;
        this.myBasePath = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)homeDirectoryPath));
        this.myVersion = version;
        this.myRepositoryPath = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)this.myBasePath)));
    }

    public static String getPlatformId() {
        return SystemInfo.isMac ? "mac" : (SystemInfo.isLinux ? "linux" : "windows");
    }

    @Override
    @NotNull
    public String getDevJarPath(boolean systemIndependent) {
        String platformSuffix = VersionComparatorUtil.compare((String)this.myVersion, (String)"2.0") >= 0 ? "" : "-" + GwtMavenSdkPaths.getPlatformId();
        String string = new File(this.myDevDirPath, "gwt-dev-" + this.myVersion + platformSuffix + ".jar").getAbsolutePath();
        if (string == null) {
            GwtMavenSdkPaths.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public String getCodeServerJarPath() {
        return this.getJarPath("gwt-codeserver");
    }

    @Override
    @NotNull
    public String getHomeDirectoryUrl() {
        String string = JpsPathUtil.pathToUrl((String)this.myDevDirPath);
        if (string == null) {
            GwtMavenSdkPaths.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getServletJarPath() {
        String string = this.getJarPath("gwt-servlet");
        if (string == null) {
            GwtMavenSdkPaths.$$$reportNull$$$0(2);
        }
        return string;
    }

    private String getJarPath(String name) {
        return new File(this.myBasePath, name + "/" + this.myVersion + "/" + name + "-" + this.myVersion + ".jar").getAbsolutePath();
    }

    @Override
    @NotNull
    public String getUserJarPath() {
        String string = this.getJarPath("gwt-user");
        if (string == null) {
            GwtMavenSdkPaths.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String getVersion() {
        return this.myVersion;
    }

    @Override
    @NotNull
    public List<String> getAdditionalCompilerJars() {
        String preferredVersion;
        ArrayList<String> additionalJars = new ArrayList<String>(GwtSdkPathUtil.findValidationJarsInMavenRepo(this.myRepositoryPath));
        if (VersionComparatorUtil.compare((String)this.myVersion, (String)"2.7.0") >= 0) {
            for (String[] dependency : GwtSdkPathUtil.DEFAULT_ADDITIONAL_2_7_DEPENDENCIES) {
                preferredVersion = dependency.length > 2 ? dependency[2] : null;
                ContainerUtil.addIfNotNull(additionalJars, (Object)this.getArtifactPath(dependency[0], dependency[1], preferredVersion));
            }
        }
        if (VersionComparatorUtil.compare((String)this.myVersion, (String)"2.8.0-beta1") > 0) {
            for (String[] dependency : GwtSdkPathUtil.DEFAULT_ADDITIONAL_2_8_DEPENDENCIES) {
                preferredVersion = dependency.length > 2 ? dependency[2] : null;
                ContainerUtil.addIfNotNull(additionalJars, (Object)this.getArtifactPath(dependency[0], dependency[1], preferredVersion));
            }
        }
        ArrayList<String> arrayList = additionalJars;
        if (arrayList == null) {
            GwtMavenSdkPaths.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public String getArtifactPath(@NotNull String groupId, @NotNull String artifactId, @Nullable String preferredVersion) {
        String version;
        File jar;
        File dir;
        String[] dirNames;
        if (groupId == null) {
            GwtMavenSdkPaths.$$$reportNull$$$0(5);
        }
        if (artifactId == null) {
            GwtMavenSdkPaths.$$$reportNull$$$0(6);
        }
        if ((dirNames = (dir = new File(FileUtil.toSystemDependentName((String)(this.myRepositoryPath + "/" + groupId.replace('.', '/') + "/" + artifactId)))).list()) != null && dirNames.length > 0 && (jar = new File(dir, (version = StringUtil.isNotEmpty((String)preferredVersion) && ArrayUtil.contains((String)preferredVersion, (String[])dirNames) ? preferredVersion : Collections.max(Arrays.asList(dirNames), VersionComparatorUtil.COMPARATOR)) + "/" + artifactId + "-" + version + ".jar")).isFile()) {
            return jar.getAbsolutePath();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevJarPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeDirectoryUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServletJarPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserJarPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalCompilerJars";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

