/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl;

import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gwt.model.JpsGwtModuleExtension;
import org.jetbrains.jps.gwt.model.impl.GwtCompilerWorkspaceState;
import org.jetbrains.jps.gwt.model.impl.GwtModuleExtensionProperties;
import org.jetbrains.jps.gwt.model.impl.JpsGwtCompilerOutputPackagingElement;
import org.jetbrains.jps.gwt.model.impl.JpsGwtCompilerProjectExtensionImpl;
import org.jetbrains.jps.gwt.model.impl.JpsGwtModuleExtensionImpl;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsPackagingElementSerializer;
import org.jetbrains.jps.model.serialization.facet.JpsFacetConfigurationSerializer;
import org.jetbrains.jps.model.serialization.facet.JpsFacetSerializer;

public class JpsGwtModelSerializerExtension
extends JpsModelSerializerExtension {
    @NonNls
    public static final String GWT_COMPILER_CONFIGURATION_COMPONENT_NAME = "GwtCompilerConfiguration";

    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        List<JpsGwtWorkspaceConfigurationSerializer> list = Collections.singletonList(new JpsGwtWorkspaceConfigurationSerializer());
        if (list == null) {
            JpsGwtModelSerializerExtension.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<? extends JpsFacetConfigurationSerializer<?>> getFacetConfigurationSerializers() {
        List<JpsGwtFacetConfigurationSerializer> list = Collections.singletonList(new JpsGwtFacetConfigurationSerializer());
        if (list == null) {
            JpsGwtModelSerializerExtension.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<? extends JpsPackagingElementSerializer<?>> getPackagingElementSerializers() {
        List<JpsGwtCompilerOutputElementSerializer> list = Arrays.asList(new JpsGwtCompilerOutputElementSerializer("gwt-compiler-output", JpsGwtCompilerOutputPackagingElement.OutputKind.REGULAR), new JpsGwtCompilerOutputElementSerializer("gwt-compiler-deploy-output", JpsGwtCompilerOutputPackagingElement.OutputKind.DEPLOY));
        if (list == null) {
            JpsGwtModelSerializerExtension.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/gwt/model/impl/JpsGwtModelSerializerExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectExtensionSerializers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetConfigurationSerializers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagingElementSerializers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class JpsGwtWorkspaceConfigurationSerializer
    extends JpsProjectExtensionSerializer {
        private JpsGwtWorkspaceConfigurationSerializer() {
            super("workspace.xml", JpsGwtModelSerializerExtension.GWT_COMPILER_CONFIGURATION_COMPONENT_NAME);
        }

        public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            if (project == null) {
                JpsGwtWorkspaceConfigurationSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                JpsGwtWorkspaceConfigurationSerializer.$$$reportNull$$$0(1);
            }
            GwtCompilerWorkspaceState state = (GwtCompilerWorkspaceState)XmlSerializer.deserialize((Element)componentTag, GwtCompilerWorkspaceState.class);
            JpsGwtCompilerProjectExtensionImpl extension = new JpsGwtCompilerProjectExtensionImpl(state.getModulesToShowCompilerOutput());
            project.getContainer().setChild(JpsGwtCompilerProjectExtensionImpl.ROLE, (JpsElement)extension);
        }

        public void saveExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            if (project == null) {
                JpsGwtWorkspaceConfigurationSerializer.$$$reportNull$$$0(2);
            }
            if (componentTag == null) {
                JpsGwtWorkspaceConfigurationSerializer.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentTag";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/gwt/model/impl/JpsGwtModelSerializerExtension$JpsGwtWorkspaceConfigurationSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadExtension";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveExtension";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JpsGwtCompilerOutputElementSerializer
    extends JpsPackagingElementSerializer<JpsGwtCompilerOutputPackagingElement> {
        private JpsGwtCompilerOutputPackagingElement.OutputKind myOutputKind;

        public JpsGwtCompilerOutputElementSerializer(String typeId, JpsGwtCompilerOutputPackagingElement.OutputKind outputKind) {
            super(typeId, JpsGwtCompilerOutputPackagingElement.class);
            this.myOutputKind = outputKind;
        }

        public JpsGwtCompilerOutputPackagingElement load(Element element) {
            JpsModuleReference moduleReference = JpsFacetSerializer.createModuleReference((String)element.getAttributeValue("facet"));
            return new JpsGwtCompilerOutputPackagingElement(moduleReference, this.myOutputKind);
        }

        public void save(JpsGwtCompilerOutputPackagingElement element, Element tag) {
            String id = JpsFacetSerializer.getFacetId((JpsModuleReference)element.getModuleReference(), (String)"gwt", (String)"GWT");
            tag.setAttribute("facet", id);
        }
    }

    private static class JpsGwtFacetConfigurationSerializer
    extends JpsFacetConfigurationSerializer<JpsGwtModuleExtension> {
        public JpsGwtFacetConfigurationSerializer() {
            super(JpsGwtModuleExtensionImpl.ROLE, "gwt", "GWT");
        }

        protected JpsGwtModuleExtension loadExtension(@NotNull Element facetConfigurationElement, String name, JpsElement parent, JpsModule module) {
            if (facetConfigurationElement == null) {
                JpsGwtFacetConfigurationSerializer.$$$reportNull$$$0(0);
            }
            GwtModuleExtensionProperties properties = (GwtModuleExtensionProperties)XmlSerializer.deserialize((Element)facetConfigurationElement, GwtModuleExtensionProperties.class);
            return new JpsGwtModuleExtensionImpl(properties);
        }

        protected void saveExtension(JpsGwtModuleExtension extension, Element facetConfigurationTag, JpsModule module) {
            XmlSerializer.serializeInto((Object)((JpsGwtModuleExtensionImpl)extension).getProperties(), (Element)facetConfigurationTag, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetConfigurationElement", "org/jetbrains/jps/gwt/model/impl/JpsGwtModelSerializerExtension$JpsGwtFacetConfigurationSerializer", "loadExtension"));
        }
    }
}

