/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSRecordType
extends JSType {
    @NotNull
    public List<TypeMember> getTypeMembers();

    public boolean hasProperty(String var1);

    public boolean hasIndexers();

    public Set<String> getPropertyNames();

    @Nullable
    public PropertySignature findPropertySignature(@NotNull String var1);

    public static interface IndexSignature
    extends TypeMember {
        @NotNull
        public IndexSignatureKind getIndexSignatureKind();

        @NotNull
        public JSType getMemberParameterType();

        @NotNull
        public JSType getMemberType();

        @Override
        @NotNull
        public IndexSignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);
    }

    public static enum IndexSignatureKind {
        STRING,
        NUMERIC,
        UNKNOWN;

    }

    public static interface CallSignature
    extends TypeMember {
        public boolean hasNew();

        public JSType getFunctionType();

        @Override
        @NotNull
        public CallSignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);
    }

    public static interface PropertySignature
    extends TypeMember {
        @NotNull
        public String getMemberName();

        @Override
        @NotNull
        public PropertySignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);

        public boolean isOptional();

        @Nullable
        public JSType getType();
    }

    public static interface TypeMember {
        public boolean isEquivalentTo(@Nullable TypeMember var1, boolean var2);

        @NotNull
        public MemberSource getMemberSource();

        @NotNull
        public TypeMember copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);

        public void appendMemberPresentation(@NotNull JSType.TypeTextFormat var1, @NotNull StringBuilder var2, @NotNull String var3, char var4);

        public void acceptChildren(JSRecursiveTypeVisitor var1);
    }

    public static interface MemberSource {
        public boolean isEmpty();

        @NotNull
        public MemberSourceKind getMemberSourceKind();

        @Nullable
        public PsiElement getSingleElement();

        @NotNull
        public List<PsiElement> getAllSourceElements();

        public MemberSource copyWithKind(MemberSourceKind var1);
    }

    public static enum MemberSourceKind {
        Empty,
        Identity,
        Union,
        Intersection,
        Mapped,
        CompositeSignature;


        public boolean isTypeScriptMergedTypeKind() {
            return this == Union || this == Intersection || this == Mapped;
        }
    }
}

