/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.usages;

import com.google.common.base.Splitter;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SingleTargetRequestResultProcessor;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.SCSSLanguage;
import org.jetbrains.plugins.scss.psi.SassScssInclude;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssVariableImpl;

public class SassScssReferenceSearch
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public SassScssReferenceSearch() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters parameters, @NotNull Processor<PsiReference> consumer) {
        PsiElement elementToSearch;
        if (parameters == null) {
            SassScssReferenceSearch.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            SassScssReferenceSearch.$$$reportNull$$$0(1);
        }
        if (!((elementToSearch = parameters.getElementToSearch()) instanceof CssNamedElement)) {
            return;
        }
        Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)elementToSearch);
        if (!SASSLanguage.INSTANCE.is(language) && !SCSSLanguage.INSTANCE.is(language)) {
            return;
        }
        String name = ((CssNamedElement)elementToSearch).getName();
        if (name == null) {
            return;
        }
        String nameToSplit = elementToSearch instanceof SassScssVariableDeclaration ? "$" + name : name;
        ArrayList names = ContainerUtil.newArrayList((Iterable)Splitter.onPattern((String)"[-_]+").trimResults().split((CharSequence)nameToSplit));
        ContainerUtil.sort((List)names, (o1, o2) -> o2.length() - o1.length());
        String longest = (String)ContainerUtil.getFirstItem((List)names);
        if (StringUtil.isEmpty((String)longest)) {
            longest = "_";
        }
        SingleTargetRequestResultProcessor singleTargetRequestResultProcessor = new SingleTargetRequestResultProcessor(elementToSearch);
        TextOccurenceProcessor occurenceProcessor = (element, offsetInElement) -> {
            if (consumer == null) {
                SassScssReferenceSearch.$$$reportNull$$$0(2);
            }
            if (element instanceof PsiNamedElement) {
                PsiNamedElement candidate = (PsiNamedElement)element;
                if (!Comparing.equal((String)name, (String)candidate.getName())) {
                    if (!(element instanceof CssFunction || element instanceof SassScssInclude || element instanceof SassScssVariableImpl)) {
                        return true;
                    }
                    if (!SASSSCSSLangUtil.nameEquals(name, candidate.getName())) {
                        return true;
                    }
                }
                offsetInElement = candidate.getTextOffset() - candidate.getTextRange().getStartOffset();
                return singleTargetRequestResultProcessor.processTextOccurrence((PsiElement)candidate, offsetInElement, consumer);
            }
            return singleTargetRequestResultProcessor.processTextOccurrence(element, offsetInElement, consumer);
        };
        SearchScope scope = SASSSCSSLangUtil.restrictedBySassFilesScope(parameters.getEffectiveSearchScope());
        EnumSet<PsiSearchHelperImpl.Options> options = EnumSet.of(PsiSearchHelperImpl.Options.CASE_SENSITIVE_SEARCH, PsiSearchHelperImpl.Options.PROCESS_INJECTED_PSI);
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)elementToSearch.getProject());
        if (helper instanceof PsiSearchHelperImpl) {
            ((PsiSearchHelperImpl)helper).processElementsWithWord(occurenceProcessor, scope, longest, (short)1, options, null);
        } else {
            helper.processElementsWithWord(occurenceProcessor, scope, longest, (short)1, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/sass/usages/SassScssReferenceSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processQuery$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

