/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.references;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UiXmlTagNameRefactoringUtil {
    public static String handleMove(XmlTag xmlTag, String newPackage, String entityName) {
        int newNestingLevel;
        String closestParentPackageCandidate;
        String newPrefix = xmlTag.getPrefixByNamespace("urn:import:" + newPackage);
        if (newPrefix != null) {
            return newPrefix + ":" + entityName;
        }
        String oldTagName = StringUtil.trimStart((String)xmlTag.getName(), (String)(xmlTag.getNamespacePrefix() + ":"));
        String newQualifiedClassName = newPackage + "." + entityName;
        int dotsInEntityName = StringUtil.countChars((CharSequence)entityName, (char)'.');
        int oldNestingLevel = StringUtil.countChars((CharSequence)oldTagName, (char)'.') - dotsInEntityName;
        if (oldNestingLevel > 0 && !(closestParentPackageCandidate = Arrays.stream(xmlTag.knownNamespaces()).filter(ns -> ns.startsWith("urn:import:")).map(ns -> StringUtil.trimStart((String)ns, (String)"urn:import:")).filter(ns -> newPackage.startsWith((String)ns) && newPackage.charAt(ns.length()) == '.').max((l, r) -> Integer.compare(l.length(), r.length())).orElse("")).isEmpty() && (newNestingLevel = StringUtil.countChars((CharSequence)newPackage, (char)'.', (int)closestParentPackageCandidate.length(), (boolean)false) - dotsInEntityName) <= oldNestingLevel) {
            String newTagName = newQualifiedClassName.substring(closestParentPackageCandidate.length() + 1);
            String newNamespacePrefix = xmlTag.getPrefixByNamespace("urn:import:" + closestParentPackageCandidate);
            return newNamespacePrefix + ":" + newTagName;
        }
        return UiXmlTagNameRefactoringUtil.createNewNamespacePrefix(xmlTag, newPackage) + ":" + entityName;
    }

    @NotNull
    private static String createNewNamespacePrefix(XmlTag xmlTag, String newPackage) {
        String name = (String)ContainerUtil.getLastItem((List)StringUtil.split((String)newPackage, (String)"."));
        String nsPrefix = UniqueNameGenerator.generateUniqueName((String)name, prefix -> xmlTag.getNamespaceByPrefix(prefix).isEmpty());
        XmlFile containingFile = (XmlFile)xmlTag.getContainingFile();
        containingFile.getRootTag().setAttribute("xmlns:" + nsPrefix, "urn:import:" + newPackage);
        String string = nsPrefix;
        if (string == null) {
            UiXmlTagNameRefactoringUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/references/UiXmlTagNameRefactoringUtil", "createNewNamespacePrefix"));
    }
}

