/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.declarations;

import com.intellij.gwt.uiBinder.declarations.UiXmlVariableDeclaration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UiImportVariable
implements UiXmlVariableDeclaration {
    private final XmlTag myTag;
    private final String myClassName;
    private final String myFieldName;

    public UiImportVariable(@NotNull XmlTag tag, @NotNull String className, @NotNull String fieldName) {
        if (tag == null) {
            UiImportVariable.$$$reportNull$$$0(0);
        }
        if (className == null) {
            UiImportVariable.$$$reportNull$$$0(1);
        }
        if (fieldName == null) {
            UiImportVariable.$$$reportNull$$$0(2);
        }
        this.myTag = tag;
        this.myClassName = className;
        this.myFieldName = fieldName;
    }

    @NotNull
    static List<UiImportVariable> createElements(@NotNull XmlTag tag) {
        String qualifiedFieldName;
        if (tag == null) {
            UiImportVariable.$$$reportNull$$$0(3);
        }
        if ((qualifiedFieldName = tag.getAttributeValue("field")) == null) {
            List<UiImportVariable> list = Collections.emptyList();
            if (list == null) {
                UiImportVariable.$$$reportNull$$$0(4);
            }
            return list;
        }
        String className = StringUtil.getPackageName((String)qualifiedFieldName);
        if (className.isEmpty()) {
            List<UiImportVariable> list = Collections.emptyList();
            if (list == null) {
                UiImportVariable.$$$reportNull$$$0(5);
            }
            return list;
        }
        String fieldName = StringUtil.getShortName((String)qualifiedFieldName);
        if (!fieldName.equals("*")) {
            List<UiImportVariable> list = Collections.singletonList(new UiImportVariable(tag, className, fieldName));
            if (list == null) {
                UiImportVariable.$$$reportNull$$$0(6);
            }
            return list;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)tag.getProject()).findClass(className, tag.getResolveScope());
        if (psiClass == null) {
            List<UiImportVariable> list = Collections.emptyList();
            if (list == null) {
                UiImportVariable.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList<UiImportVariable> variables = new ArrayList<UiImportVariable>();
        for (PsiField field : psiClass.getFields()) {
            if (!field.hasModifierProperty("static") || !field.hasModifierProperty("public")) continue;
            variables.add(new UiImportVariable(tag, className, field.getName()));
        }
        ArrayList<UiImportVariable> arrayList = variables;
        if (arrayList == null) {
            UiImportVariable.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public String getVariableName() {
        return this.myFieldName;
    }

    @Override
    @Nullable
    public String getType() {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myTag.getProject()).findClass(this.myClassName, this.myTag.getResolveScope());
        if (psiClass == null) {
            return null;
        }
        PsiField field = psiClass.findFieldByName(this.myFieldName, false);
        return field != null ? field.getType().getCanonicalText() : null;
    }

    @Override
    @Nullable
    public PsiType resolveType() {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myTag.getProject()).findClass(this.myClassName, this.myTag.getResolveScope());
        if (psiClass == null) {
            return null;
        }
        PsiField field = psiClass.findFieldByName(this.myFieldName, false);
        return field != null ? field.getType() : null;
    }

    @Override
    @NotNull
    public XmlTag getTag() {
        XmlTag xmlTag = this.myTag;
        if (xmlTag == null) {
            UiImportVariable.$$$reportNull$$$0(9);
        }
        return xmlTag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/uiBinder/declarations/UiImportVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/uiBinder/declarations/UiImportVariable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createElements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

