/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.sdk.impl;

import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.psi.GwtSourcePathsRefresherProjectComponent;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtSdkUtil;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.gwt.superSource.GwtSuperSourceClassCache;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.gwt.model.impl.GwtSourcePath;

public abstract class GwtSdkBase
implements GwtSdk {
    private final Map<String, Boolean> myCachedJreEmulationClasses = new HashMap<String, Boolean>();
    @Nullable
    protected GwtVersion myVersion;
    protected final GwtSdkPaths myPaths;

    protected GwtSdkBase(GwtSdkPaths paths) {
        this.myPaths = paths;
    }

    @Override
    public boolean containsJreEmulationClass(List<GwtModule> gwtModules, String className) {
        Boolean contains = this.myCachedJreEmulationClasses.get(className);
        if (contains == null) {
            VirtualFile userJar = this.getUserJar();
            contains = userJar != null && userJar.findFileByRelativePath(GwtSdkUtil.getJreEmulationClassPath(className)) != null;
            this.myCachedJreEmulationClasses.put(className, contains);
        }
        if (contains.booleanValue()) {
            return true;
        }
        if (gwtModules.isEmpty()) {
            return false;
        }
        Project project = gwtModules.get(0).getManager().getProject();
        GwtSuperSourceClassCache sourceClassCache = GwtSuperSourceClassCache.getInstance(project);
        return sourceClassCache.containsJreEmulationClass(gwtModules, className);
    }

    @Override
    @Nullable
    public PsiClass findJreEmulationClass(List<GwtModule> gwtModules, @NotNull PsiClass originalClass) {
        String className;
        if (originalClass == null) {
            GwtSdkBase.$$$reportNull$$$0(0);
        }
        if ((className = originalClass.getQualifiedName()) == null) {
            return null;
        }
        Project project = originalClass.getProject();
        GwtSuperSourceClassCache sourceClassCache = GwtSuperSourceClassCache.getInstance(project);
        GwtSourcePathsRefresherProjectComponent sourcePathsRefresher = (GwtSourcePathsRefresherProjectComponent)((Object)project.getComponent(GwtSourcePathsRefresherProjectComponent.class));
        for (GwtSourcePath sourcePath : sourcePathsRefresher.getSuperSourcePaths(gwtModules)) {
            PsiClass psiClass;
            VirtualFile superSourceRoot = LocalFileSystem.getInstance().findFileByPath(sourcePath.myFullPath);
            if (superSourceRoot == null || (psiClass = (PsiClass)ContainerUtil.getFirstItem(sourceClassCache.findClassesByQualifiedName(className, superSourceRoot))) == null || !sourcePathsRefresher.isIncluded(psiClass.getContainingFile().getVirtualFile().getPath(), sourcePath)) continue;
            return psiClass;
        }
        VirtualFile userJar = this.getUserJar();
        if (userJar == null) {
            return null;
        }
        VirtualFile root = userJar.findFileByRelativePath("com/google/gwt/emul/");
        if (root == null) {
            return null;
        }
        return (PsiClass)ContainerUtil.getFirstItem(sourceClassCache.findClassesByQualifiedName(className, root));
    }

    @Override
    @NotNull
    public GwtVersion getVersion() {
        if (this.myVersion == null) {
            this.myVersion = this.detectVersion();
        }
        GwtVersion gwtVersion = this.myVersion;
        if (gwtVersion == null) {
            GwtSdkBase.$$$reportNull$$$0(1);
        }
        return gwtVersion;
    }

    @NotNull
    protected abstract GwtVersion detectVersion();

    @Override
    @Nullable
    public VirtualFile getUserJar() {
        return GwtSdkUtil.findJarFile(this.getUserJarPath());
    }

    @Override
    public String getHomeDirectoryUrl() {
        return this.myPaths.getHomeDirectoryUrl();
    }

    @Override
    public String getDevJarPath() {
        return this.myPaths.getDevJarPath(this.getVersion().isUseSystemIndependentGwtDevJar());
    }

    @Override
    public String getServletJarPath() {
        return this.myPaths.getServletJarPath();
    }

    @Override
    public String getUserJarPath() {
        return this.myPaths.getUserJarPath();
    }

    @Override
    public String getCodeServerJarPath() {
        return this.myPaths.getCodeServerJarPath();
    }

    @Override
    public List<String> getAdditionalCompilerJars() {
        return this.myPaths.getAdditionalCompilerJars();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/sdk/impl/GwtSdkBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/sdk/impl/GwtSdkBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findJreEmulationClass";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

