/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.compiler.CompilerIOUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectLongHashMap;
import gnu.trove.TObjectLongIterator;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class HostedModeWarDirectoryCache {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.run.HostedModeWarDirectoryCache");
    private static final int VERSION = 0;
    private File myCacheFile;
    private TObjectLongHashMap<String> myTimestamps = new TObjectLongHashMap();
    private THashMap<String, String> myTargetPaths = new THashMap();
    private boolean myChanged;

    public HostedModeWarDirectoryCache(File cacheFile) {
        this.myCacheFile = cacheFile;
    }

    public Collection<String> getTargetPaths() {
        return this.myTargetPaths.values();
    }

    public Collection<String> getSourcePaths() {
        return this.myTargetPaths.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.myTimestamps.clear();
        this.myTargetPaths.clear();
        this.myChanged = false;
        if (!this.myCacheFile.exists()) {
            return;
        }
        try (DataInputStream input = new DataInputStream(new FileInputStream(this.myCacheFile));){
            int version = input.readInt();
            if (version != 0) {
                return;
            }
            int count = input.readInt();
            while (count-- > 0) {
                String path = CompilerIOUtil.readString((DataInput)input);
                String targetPath = CompilerIOUtil.readString((DataInput)input);
                long timestamp = input.readLong();
                this.myTimestamps.put((Object)path, timestamp);
                this.myTargetPaths.put((Object)path, (Object)targetPath);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (!this.myChanged) {
            return;
        }
        FileUtil.createIfDoesntExist((File)this.myCacheFile);
        try (DataOutputStream output = new DataOutputStream(new FileOutputStream(this.myCacheFile));){
            output.writeInt(0);
            output.writeInt(this.myTimestamps.size());
            TObjectLongIterator iterator = this.myTimestamps.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                String path = (String)iterator.key();
                CompilerIOUtil.writeString((String)path, (DataOutput)output);
                CompilerIOUtil.writeString((String)((String)this.myTargetPaths.get((Object)path)), (DataOutput)output);
                output.writeLong(iterator.value());
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public long getTimestamp(String path) {
        if (!this.myTimestamps.containsKey((Object)path)) {
            return -1L;
        }
        return this.myTimestamps.get((Object)path);
    }

    public String getTargetPath(String path) {
        return (String)this.myTargetPaths.get((Object)path);
    }

    public void updateTimestamp(String path, long timestamp, String targetPath) {
        this.myChanged = true;
        this.myTimestamps.put((Object)path, timestamp);
        this.myTargetPaths.put((Object)path, (Object)targetPath);
    }

    public void remove(Set<String> paths) {
        if (!paths.isEmpty()) {
            this.myChanged = true;
            for (String path : paths) {
                this.myTimestamps.remove((Object)path);
                this.myTargetPaths.remove((Object)path);
            }
        }
    }
}

