/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GwtClasspathUtil {
    private GwtClasspathUtil() {
    }

    private static Condition<OrderEntry> createGwtRelatedEntryCondition(Project project) {
        HashSet gwtModulesSourceRoots = new HashSet();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (GwtModule gwtModule : GwtModulesManager.getInstance(project).getAllGwtModules()) {
            VirtualFile sourceRoot = index.getSourceRootForFile(gwtModule.getModuleFile());
            ContainerUtil.addIfNotNull(gwtModulesSourceRoots, (Object)sourceRoot);
        }
        return orderEntry -> {
            if (orderEntry instanceof ModuleOrderEntry) {
                return true;
            }
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                return GwtFacet.getInstance(((ModuleSourceOrderEntry)orderEntry).getRootModel().getModule()) != null;
            }
            if (orderEntry instanceof LibraryOrderEntry) {
                Library library = ((LibraryOrderEntry)orderEntry).getLibrary();
                if (library != null) {
                    Set classesRoots = ContainerUtil.set((Object[])library.getFiles(OrderRootType.CLASSES));
                    for (VirtualFile sourceRoot : library.getFiles(OrderRootType.SOURCES)) {
                        if (classesRoots.contains(sourceRoot) || !gwtModulesSourceRoots.contains(sourceRoot)) continue;
                        return true;
                    }
                }
                return false;
            }
            return false;
        };
    }

    public static PathsList getSourceRootsOfGwtModules(@NotNull Module module, boolean productionOnly) {
        if (module == null) {
            GwtClasspathUtil.$$$reportNull$$$0(0);
        }
        return GwtClasspathUtil.enumerateEntriesWithGwtSourceRoots(module, productionOnly).getSourcePathsList();
    }

    public static OrderEnumerator enumerateEntriesWithGwtSourceRoots(Module module, boolean productionOnly) {
        OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)module);
        if (productionOnly) {
            enumerator = enumerator.productionOnly();
        }
        return enumerator.withoutSdk().satisfying(GwtClasspathUtil.createGwtRelatedEntryCondition(module.getProject())).recursively();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/run/GwtClasspathUtil", "getSourceRootsOfGwtModules"));
    }
}

