/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeAdapter;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import icons.GwtStudioIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseGwtModulesDialog
extends DialogWrapper {
    private final CheckboxTree myTree;
    private final PackageCheckedTreeNode myRoot;

    public ChooseGwtModulesDialog(@NotNull Module module, @NotNull List<String> selectedGwtModules) {
        if (module == null) {
            ChooseGwtModulesDialog.$$$reportNull$$$0(0);
        }
        if (selectedGwtModules == null) {
            ChooseGwtModulesDialog.$$$reportNull$$$0(1);
        }
        super(module.getProject(), true);
        this.setTitle("Choose GWT Modules to Load");
        this.myRoot = new PackageCheckedTreeNode("");
        Collection<GwtModule> gwtModules = GwtModulesManager.getInstance(module.getProject()).getCompilableGwtModules(module, false);
        HashMap<String, PackageCheckedTreeNode> packageNodes = new HashMap<String, PackageCheckedTreeNode>();
        packageNodes.put("", this.myRoot);
        HashSet<String> selectedGwtModulesSet = new HashSet<String>(selectedGwtModules);
        for (GwtModule gwtModule : gwtModules) {
            String moduleName = gwtModule.getQualifiedName();
            PackageCheckedTreeNode packageNode = ChooseGwtModulesDialog.getOrCreatePackageNode(StringUtil.getPackageName((String)moduleName), packageNodes);
            GwtModuleCheckedTreeNode node = new GwtModuleCheckedTreeNode(moduleName);
            node.setChecked(selectedGwtModulesSet.contains(moduleName));
            packageNode.add((MutableTreeNode)((Object)node));
        }
        this.myTree = new CheckboxTree((CheckboxTree.CheckboxTreeCellRenderer)new GwtModulesCheckboxTreeCellRenderer(), (CheckedTreeNode)this.myRoot);
        this.myTree.addCheckboxTreeListener((CheckboxTreeListener)new CheckboxTreeAdapter(){

            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                ChooseGwtModulesDialog.this.setOKActionEnabled(!ChooseGwtModulesDialog.this.getSelectedModules().isEmpty());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/gwt/run/ChooseGwtModulesDialog$1", "nodeStateChanged"));
            }
        });
        TreeUtil.expandAll((JTree)this.myTree);
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    private static PackageCheckedTreeNode getOrCreatePackageNode(String packageName, Map<String, PackageCheckedTreeNode> nodes) {
        if (!nodes.containsKey(packageName)) {
            PackageCheckedTreeNode parent = ChooseGwtModulesDialog.getOrCreatePackageNode(StringUtil.getPackageName((String)packageName), nodes);
            PackageCheckedTreeNode child = new PackageCheckedTreeNode(StringUtil.getShortName((String)packageName));
            parent.add((MutableTreeNode)((Object)child));
            nodes.put(packageName, child);
        }
        return nodes.get(packageName);
    }

    @NotNull
    public List<String> getSelectedModules() {
        ArrayList<String> modules = new ArrayList<String>();
        TreeUtil.traverse((TreeNode)((Object)this.myRoot), node -> {
            if (node instanceof GwtModuleCheckedTreeNode && ((GwtModuleCheckedTreeNode)((Object)((Object)node))).isChecked()) {
                modules.add(((GwtModuleCheckedTreeNode)((Object)((Object)node))).getQualifiedModuleName());
            }
            return true;
        });
        ArrayList<String> arrayList = modules;
        if (arrayList == null) {
            ChooseGwtModulesDialog.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        pane.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
        return pane;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "#GWT.ChooseModulesDialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedGwtModules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/run/ChooseGwtModulesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/run/ChooseGwtModulesDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GwtModuleCheckedTreeNode
    extends CheckedTreeNode {
        public GwtModuleCheckedTreeNode(@NotNull String moduleName) {
            if (moduleName == null) {
                GwtModuleCheckedTreeNode.$$$reportNull$$$0(0);
            }
            super((Object)moduleName);
        }

        public String getQualifiedModuleName() {
            return (String)this.getUserObject();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/gwt/run/ChooseGwtModulesDialog$GwtModuleCheckedTreeNode", "<init>"));
        }
    }

    private static class PackageCheckedTreeNode
    extends CheckedTreeNode {
        public PackageCheckedTreeNode(@NotNull String packageName) {
            if (packageName == null) {
                PackageCheckedTreeNode.$$$reportNull$$$0(0);
            }
            super((Object)packageName);
        }

        public String getPackageName() {
            return (String)this.getUserObject();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/gwt/run/ChooseGwtModulesDialog$PackageCheckedTreeNode", "<init>"));
        }
    }

    private static class GwtModulesCheckboxTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private GwtModulesCheckboxTreeCellRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            if (value instanceof GwtModuleCheckedTreeNode) {
                renderer.append(StringUtil.getShortName((String)((GwtModuleCheckedTreeNode)((Object)value)).getQualifiedModuleName()));
                renderer.setIcon(GwtStudioIcons.Google_small);
            } else if (value instanceof PackageCheckedTreeNode) {
                renderer.append(((PackageCheckedTreeNode)((Object)value)).getPackageName());
                renderer.setIcon(AllIcons.Nodes.Folder);
            }
        }
    }
}

